/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum StackTraceElementMarshaller implements ProtoStreamMarshaller<StackTraceElement>
{
    INSTANCE;

    private static final int CLASS_NAME_INDEX = 1;
    private static final int METHOD_NAME_INDEX = 2;
    private static final int FILE_NAME_INDEX = 3;
    private static final int LINE_NUMBER_INDEX = 4;

    @Override
    public StackTraceElement readFrom(ProtoStreamReader reader) throws IOException {
        String className = null;
        String methodName = null;
        String fileName = null;
        int line = -1;
        boolean reading = true;
        block6: while (reading) {
            int tag = reader.readTag();
            switch (WireFormat.getTagFieldNumber((int)tag)) {
                case 1: {
                    className = (String)reader.readObject(Any.class).get();
                    continue block6;
                }
                case 2: {
                    methodName = (String)reader.readObject(Any.class).get();
                    continue block6;
                }
                case 3: {
                    fileName = (String)reader.readObject(Any.class).get();
                    continue block6;
                }
                case 4: {
                    line = reader.readUInt32();
                    if (line != 0) continue block6;
                    line = -2;
                    continue block6;
                }
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        return new StackTraceElement(className, methodName, fileName, line);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, StackTraceElement element) throws IOException {
        writer.writeObject(1, new Any(element.getClassName()));
        writer.writeObject(2, new Any(element.getMethodName()));
        String fileName = element.getFileName();
        if (fileName != null) {
            writer.writeObject(3, new Any(fileName));
        }
        int line = element.getLineNumber();
        boolean nativeMethod = element.isNativeMethod();
        if (nativeMethod || line > 0) {
            writer.writeUInt32(4, nativeMethod ? 0 : line);
        }
    }

    @Override
    public Class<? extends StackTraceElement> getJavaClass() {
        return StackTraceElement.class;
    }
}

