/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.callback;

import java.util.function.Function;
import org.wildfly.security.auth.callback.ExtendedCallback;
import org.wildfly.security.evidence.Evidence;

public class EvidenceDecodePrincipalCallback
implements ExtendedCallback {
    private final Evidence evidence;

    public EvidenceDecodePrincipalCallback(Evidence evidence) {
        this.evidence = evidence;
    }

    public Evidence getEvidence() {
        return this.evidence;
    }

    public <C extends Evidence> C getEvidence(Class<C> evidenceType) {
        return (C)((Evidence)this.applyToEvidence(evidenceType, Function.identity()));
    }

    public <C extends Evidence> C getEvidence(Class<C> evidenceType, String algorithmName) {
        return (C)((Evidence)this.applyToEvidence(evidenceType, algorithmName, Function.identity()));
    }

    public <C extends Evidence, R> R applyToEvidence(Class<C> evidenceType, Function<C, R> function) {
        Evidence evidence = this.evidence;
        return evidence == null ? null : (R)evidence.castAndApply(evidenceType, function);
    }

    public <C extends Evidence, R> R applyToEvidence(Class<C> evidenceType, String algorithmName, Function<C, R> function) {
        Evidence evidence = this.evidence;
        return evidence == null ? null : (R)evidence.castAndApply(evidenceType, algorithmName, function);
    }
}

