/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.persistence.remote.configuration.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.persistence.remote.configuration.KeyStoreConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.SecurityConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.SslConfiguration;
import org.infinispan.persistence.remote.configuration.TrustStoreConfigurationBuilder;

public class SslConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<SslConfiguration>,
ConfigurationBuilderInfo {
    private static final Log log = LogFactory.getLog(SslConfigurationBuilder.class);
    private KeyStoreConfigurationBuilder keyStoreConfigurationBuilder;
    private TrustStoreConfigurationBuilder trustStoreConfigurationBuilder;
    private List<ConfigurationBuilderInfo> subElements;

    SslConfigurationBuilder(SecurityConfigurationBuilder builder) {
        super(builder, SslConfiguration.attributeDefinitionSet());
        this.keyStoreConfigurationBuilder = new KeyStoreConfigurationBuilder(builder);
        this.trustStoreConfigurationBuilder = new TrustStoreConfigurationBuilder(builder);
        this.subElements = Arrays.asList(this.keyStoreConfigurationBuilder, this.trustStoreConfigurationBuilder);
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return this.subElements;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return SslConfiguration.ELEMENT_DEFINITION;
    }

    public SslConfigurationBuilder disable() {
        this.attributes.attribute(SslConfiguration.ENABLED).set((Object)false);
        return this;
    }

    public SslConfigurationBuilder enable() {
        this.attributes.attribute(SslConfiguration.ENABLED).set((Object)true);
        return this;
    }

    public SslConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(SslConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    public SslConfigurationBuilder keyStoreFileName(String keyStoreFileName) {
        this.keyStoreConfigurationBuilder.keyStoreFileName(keyStoreFileName);
        return this;
    }

    public SslConfigurationBuilder keyStoreType(String keyStoreType) {
        this.keyStoreConfigurationBuilder.keyStoreType(keyStoreType);
        return this;
    }

    public SslConfigurationBuilder keyStorePassword(char[] keyStorePassword) {
        this.keyStoreConfigurationBuilder.keyStorePassword(keyStorePassword);
        return this;
    }

    public SslConfigurationBuilder keyStoreCertificatePassword(char[] keyStoreCertificatePassword) {
        this.keyStoreConfigurationBuilder.keyStoreCertificatePassword(keyStoreCertificatePassword);
        return this;
    }

    public SslConfigurationBuilder keyAlias(String keyAlias) {
        this.keyStoreConfigurationBuilder.keyAlias(keyAlias);
        return this;
    }

    public SslConfigurationBuilder sslContext(SSLContext sslContext) {
        this.attributes.attribute(SslConfiguration.SSL_CONTEXT).set((Object)sslContext);
        return this;
    }

    public SslConfigurationBuilder trustStoreFileName(String trustStoreFileName) {
        this.trustStoreConfigurationBuilder.trustStoreFileName(trustStoreFileName);
        return this;
    }

    public SslConfigurationBuilder trustStoreType(String trustStoreType) {
        this.trustStoreConfigurationBuilder.trustStoreType(trustStoreType);
        return this;
    }

    public SslConfigurationBuilder trustStorePassword(char[] trustStorePassword) {
        this.trustStoreConfigurationBuilder.trustStorePassword(trustStorePassword);
        return this;
    }

    public SslConfigurationBuilder sniHostName(String sniHostName) {
        this.attributes.attribute(SslConfiguration.SNI_HOSTNAME).set((Object)sniHostName);
        return this;
    }

    public SslConfigurationBuilder protocol(String protocol) {
        this.attributes.attribute(SslConfiguration.PROTOCOL).set((Object)protocol);
        return this;
    }

    public void validate() {
    }

    public SslConfiguration create() {
        return new SslConfiguration(this.attributes.protect(), this.keyStoreConfigurationBuilder.create(), this.trustStoreConfigurationBuilder.create());
    }

    public SslConfigurationBuilder read(SslConfiguration template) {
        this.attributes.read(template.attributes());
        this.keyStoreConfigurationBuilder.read(template.keyStoreConfiguration());
        this.trustStoreConfigurationBuilder.read(template.trustStoreConfiguration());
        return this;
    }
}

