/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.service;

import java.util.function.Consumer;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.service.ConfigurationServiceConfigurator;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class TemplateConfigurationServiceConfigurator
implements CapabilityServiceConfigurator,
Consumer<ConfigurationBuilder> {
    private final ConfigurationServiceConfigurator configurator;
    private final String containerName;
    private final String templateCacheName;
    private volatile SupplierDependency<Configuration> template;

    public TemplateConfigurationServiceConfigurator(ServiceName name, String containerName, String cacheName, String templateCacheName) {
        this(name, containerName, cacheName, templateCacheName, builder -> {});
    }

    public TemplateConfigurationServiceConfigurator(ServiceName name, String containerName, String cacheName, String templateCacheName, Consumer<ConfigurationBuilder> templateConsumer) {
        this.configurator = new ConfigurationServiceConfigurator(name, containerName, cacheName, this.andThen(templateConsumer));
        this.containerName = containerName;
        this.templateCacheName = templateCacheName;
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        builder.read((Configuration)this.template.get());
    }

    public ServiceName getServiceName() {
        return this.configurator.getServiceName();
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.template = new ServiceSupplierDependency(InfinispanCacheRequirement.CONFIGURATION.getServiceName(support, this.containerName, this.templateCacheName));
        this.configurator.configure(support);
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        return this.configurator.require((Dependency)this.template).build(target);
    }
}

