/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.impl.ResourceUtils;

public final class FileDescriptorSource {
    private final Map<String, String> files = new LinkedHashMap<String, String>();
    private ProgressCallback progressCallback;

    public FileDescriptorSource withProgressCallback(ProgressCallback progressCallback) {
        this.progressCallback = progressCallback;
        return this;
    }

    public FileDescriptorSource addProtoFiles(String ... classpathResources) throws IOException {
        return this.addProtoFiles((ClassLoader)null, classpathResources);
    }

    public FileDescriptorSource addProtoFiles(ClassLoader userClassLoader, String ... classpathResources) throws IOException {
        for (String classpathResource : classpathResources) {
            InputStream resource;
            if (classpathResource == null) {
                throw new IllegalArgumentException("classpathResource argument cannot be null");
            }
            if (classpathResource.startsWith("/")) {
                classpathResource = classpathResource.substring(1);
            }
            if ((resource = ResourceUtils.getResourceAsStream(userClassLoader, classpathResource)) == null) {
                throw new IOException("Resource not found in class path : " + classpathResource);
            }
            this.addProtoFile(classpathResource, resource);
        }
        return this;
    }

    public FileDescriptorSource addProtoFile(String name, String fileContents) {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        if (fileContents == null) {
            throw new IllegalArgumentException("fileContents argument cannot be null");
        }
        String path = name.startsWith("/") ? name.substring(1) : name;
        this.files.put(path, fileContents);
        return this;
    }

    public FileDescriptorSource addProtoFile(String name, InputStream fileContents) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        if (fileContents == null) {
            throw new IllegalArgumentException("fileContents argument cannot be null");
        }
        String path = name.startsWith("/") ? name.substring(1) : name;
        this.files.put(path, ResourceUtils.getContentsAsString(fileContents));
        return this;
    }

    public FileDescriptorSource addProtoFile(String name, Reader fileContents) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        if (fileContents == null) {
            throw new IllegalArgumentException("contents argument cannot be null");
        }
        String path = name.startsWith("/") ? name.substring(1) : name;
        this.files.put(path, ResourceUtils.getContentsAsString(fileContents));
        return this;
    }

    public FileDescriptorSource addProtoFile(String name, File protoFile) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        if (protoFile == null) {
            throw new IllegalArgumentException("protoFile argument cannot be null");
        }
        String path = name.startsWith("/") ? name.substring(1) : name;
        this.files.put(path, ResourceUtils.getContentsAsString(protoFile));
        return this;
    }

    public static FileDescriptorSource fromResources(ClassLoader userClassLoader, String ... classPathResources) throws IOException {
        return new FileDescriptorSource().addProtoFiles(userClassLoader, classPathResources);
    }

    public static FileDescriptorSource fromResources(String ... classPathResources) throws IOException {
        return new FileDescriptorSource().addProtoFiles(classPathResources);
    }

    public static FileDescriptorSource fromString(String name, String fileContents) {
        return new FileDescriptorSource().addProtoFile(name, fileContents);
    }

    @Deprecated
    public Map<String, char[]> getFileDescriptors() {
        LinkedHashMap<String, char[]> map = new LinkedHashMap<String, char[]>();
        for (Map.Entry<String, String> e : this.files.entrySet()) {
            map.put(e.getKey(), e.getValue().toCharArray());
        }
        return map;
    }

    public Map<String, String> getFiles() {
        return Collections.unmodifiableMap(this.files);
    }

    public ProgressCallback getProgressCallback() {
        return this.progressCallback;
    }

    @Deprecated
    public static String getResourceAsString(Class<?> c, String resourcePath) throws UncheckedIOException {
        return ResourceUtils.getResourceAsString(c, resourcePath);
    }

    public static interface ProgressCallback {
        default public void handleError(String fileName, DescriptorParserException exception) {
        }

        default public void handleSuccess(String fileName) {
        }
    }
}

