/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.interceptors.impl.AbstractIracRemoteSiteInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PessimisticTxIracRemoteSiteInterceptor
extends AbstractIracRemoteSiteInterceptor {
    private static final Log log = LogFactory.getLog(PessimisticTxIracRemoteSiteInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    boolean isTraceEnabled() {
        return trace;
    }

    @Override
    Log getLog() {
        return log;
    }

    private Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) {
        if (PessimisticTxIracRemoteSiteInterceptor.isNormalWriteCommand(command)) {
            return this.invokeNext(ctx, command);
        }
        Object key = command.getKey();
        DistributionInfo dInfo = this.getDistributionInfo(key);
        if (ctx.isOriginLocal()) {
            if (dInfo.isPrimary()) {
                this.validateOnPrimary(ctx, command, null);
                return command.isSuccessful() ? this.invokeNext(ctx, command) : null;
            }
            throw new CacheException("Update must be executed in the primary owner!", null, false, false);
        }
        if (dInfo.isWriteOwner()) {
            this.setIracMetadataForOwner(ctx, command, null);
        }
        return this.invokeNext(ctx, command);
    }
}

