/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceNameFactory;
import org.jboss.as.controller.PathAddress;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;

public abstract class ComponentServiceConfigurator<C>
implements ResourceServiceConfigurator,
Supplier<C>,
Dependency {
    private final ServiceName name;
    private final ServiceController.Mode initialMode;

    protected ComponentServiceConfigurator(ResourceServiceNameFactory factory, PathAddress address) {
        this(factory, address, ServiceController.Mode.ON_DEMAND);
    }

    protected ComponentServiceConfigurator(ResourceServiceNameFactory factory, PathAddress address, ServiceController.Mode initialMode) {
        this.name = factory.getServiceName(address.getParent());
        this.initialMode = initialMode;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer component = this.register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(component, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service).setInitialMode(this.initialMode);
    }

    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        return builder;
    }
}

