/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.affinity.KeyAffinityService;
import org.jboss.as.clustering.context.DefaultExecutorService;
import org.jboss.as.clustering.context.DefaultThreadFactory;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.affinity.DefaultKeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.service.AsyncServiceConfigurator;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

public class KeyAffinityServiceFactoryServiceConfigurator
extends CapabilityServiceNameProvider
implements ServiceConfigurator,
Function<ExecutorService, KeyAffinityServiceFactory>,
Supplier<ExecutorService>,
Consumer<ExecutorService> {
    private volatile int bufferSize = 100;

    public KeyAffinityServiceFactoryServiceConfigurator(PathAddress address) {
        super((Capability)CacheContainerResourceDefinition.Capability.KEY_AFFINITY_FACTORY, address);
    }

    public KeyAffinityServiceFactoryServiceConfigurator setBufferSize(int size) {
        this.bufferSize = size;
        return this;
    }

    @Override
    public ExecutorService get() {
        return Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory(KeyAffinityService.class));
    }

    @Override
    public KeyAffinityServiceFactory apply(ExecutorService executor) {
        return new DefaultKeyAffinityServiceFactory(executor, this.bufferSize);
    }

    @Override
    public void accept(ExecutorService executor) {
        WildFlySecurityManager.doUnchecked((Object)executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = new AsyncServiceConfigurator(this.getServiceName()).startSynchronously().build(target);
        Consumer affinityFactory = builder.provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(affinityFactory, (Function)this, (Supplier)this, (Consumer)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

