/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ApiError;

public class AlterUserScramCredentialsRequest
extends AbstractRequest {
    private AlterUserScramCredentialsRequestData data;
    private final short version;

    private AlterUserScramCredentialsRequest(AlterUserScramCredentialsRequestData data, short version) {
        super(ApiKeys.ALTER_USER_SCRAM_CREDENTIALS, version);
        this.data = data;
        this.version = version;
    }

    AlterUserScramCredentialsRequest(Struct struct, short version) {
        super(ApiKeys.ALTER_USER_SCRAM_CREDENTIALS, version);
        this.data = new AlterUserScramCredentialsRequestData(struct, version);
        this.version = version;
    }

    public static AlterUserScramCredentialsRequest parse(ByteBuffer buffer, short version) {
        return new AlterUserScramCredentialsRequest(ApiKeys.ALTER_USER_SCRAM_CREDENTIALS.parseRequest(version, buffer), version);
    }

    public AlterUserScramCredentialsRequestData data() {
        return this.data;
    }

    @Override
    public Struct toStruct() {
        return this.data.toStruct(this.version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        short errorCode = apiError.error().code();
        String errorMessage = apiError.message();
        Set users = Stream.concat(this.data.deletions().stream().map(deletion -> deletion.name()), this.data.upsertions().stream().map(upsertion -> upsertion.name())).collect(Collectors.toSet());
        List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> results = users.stream().sorted().map(user -> new AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult().setUser((String)user).setErrorCode(errorCode).setErrorMessage(errorMessage)).collect(Collectors.toList());
        return new AlterUserScramCredentialsResponse(new AlterUserScramCredentialsResponseData().setResults(results));
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterUserScramCredentialsRequest> {
        private final AlterUserScramCredentialsRequestData data;

        public Builder(AlterUserScramCredentialsRequestData data) {
            super(ApiKeys.ALTER_USER_SCRAM_CREDENTIALS);
            this.data = data;
        }

        @Override
        public AlterUserScramCredentialsRequest build(short version) {
            return new AlterUserScramCredentialsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

