/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import io.smallrye.health.SmallRyeHealth;
import java.util.function.Function;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.microprofile.health.MicroProfileHealthExtension;
import org.wildfly.extension.microprofile.health.MicroProfileHealthReporter;

public class CheckOperations
extends AbstractRuntimeOnlyHandler {
    private static final OperationDefinition CHECK_DEFINITION = new SimpleOperationDefinitionBuilder("check", MicroProfileHealthExtension.getResourceDescriptionResolver("microprofile-health-smallrye")).setRuntimeOnly().setReplyType(ModelType.OBJECT).setReplyValueType(ModelType.OBJECT).setRuntimeOnly().build();
    private static final OperationDefinition CHECK_LIVE_DEFINITION = new SimpleOperationDefinitionBuilder("check-live", MicroProfileHealthExtension.getResourceDescriptionResolver("microprofile-health-smallrye")).setRuntimeOnly().setReplyType(ModelType.OBJECT).setReplyValueType(ModelType.OBJECT).setRuntimeOnly().build();
    private static final OperationDefinition CHECK_READY_DEFINITION = new SimpleOperationDefinitionBuilder("check-ready", MicroProfileHealthExtension.getResourceDescriptionResolver("microprofile-health-smallrye")).setRuntimeOnly().setReplyType(ModelType.OBJECT).setReplyValueType(ModelType.OBJECT).setRuntimeOnly().build();
    private final Function<MicroProfileHealthReporter, SmallRyeHealth> healthOperation;

    public CheckOperations(Function<MicroProfileHealthReporter, SmallRyeHealth> healthOperation) {
        this.healthOperation = healthOperation;
    }

    static void register(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerOperationHandler(CHECK_DEFINITION, (OperationStepHandler)new CheckOperations(h -> h.getHealth()));
        resourceRegistration.registerOperationHandler(CHECK_LIVE_DEFINITION, (OperationStepHandler)new CheckOperations(h -> h.getLiveness()));
        resourceRegistration.registerOperationHandler(CHECK_READY_DEFINITION, (OperationStepHandler)new CheckOperations(h -> h.getReadiness()));
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) {
        ServiceName serviceName = context.getCapabilityServiceName("org.wildfly.extension.microprofile.health.reporter", MicroProfileHealthReporter.class);
        MicroProfileHealthReporter reporter = (MicroProfileHealthReporter)context.getServiceRegistry(false).getService(serviceName).getValue();
        SmallRyeHealth health = this.healthOperation.apply(reporter);
        ModelNode result = ModelNode.fromJSONString((String)health.getPayload().toString());
        context.getResult().set(result);
    }
}

