/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.URI;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.AbstractInvocationContext;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptorInformation;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverSessionCreationContext;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationContext;

public final class EJBSessionCreationInvocationContext
extends AbstractInvocationContext {
    private final AuthenticationContext authenticationContext;
    private final EJBClientContext.InterceptorList interceptorList;
    private int interceptorChainIndex;
    private boolean retry;

    EJBSessionCreationInvocationContext(StatelessEJBLocator<?> locator, EJBClientContext ejbClientContext, AuthenticationContext authenticationContext, EJBClientContext.InterceptorList interceptorList) {
        super(locator, ejbClientContext);
        this.authenticationContext = authenticationContext;
        this.interceptorList = interceptorList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionID proceed() throws Exception {
        int idx = this.interceptorChainIndex++;
        try {
            EJBClientInterceptorInformation[] chain = this.interceptorList.getInformation();
            if (idx > chain.length) {
                throw Assert.unreachableCode();
            }
            if (chain.length == idx) {
                URI destination = this.getDestination();
                EJBReceiver receiver = this.getClientContext().resolveReceiver(destination, this.getLocator());
                if (Logs.INVOCATION.isDebugEnabled()) {
                    Logs.INVOCATION.debugf("session creation proceed(): setting receiver, remote destination is: %s", destination);
                }
                this.setReceiver(receiver);
                SessionID sessionID = receiver.createSession(new EJBReceiverSessionCreationContext(this, this.authenticationContext));
                if (sessionID == null) {
                    throw Logs.INVOCATION.nullSessionID(receiver, this.getLocator().asStateless());
                }
                this.retry = false;
                SessionID sessionID2 = sessionID;
                return sessionID2;
            }
            if (Logs.INVOCATION.isDebugEnabled()) {
                Logs.INVOCATION.debugf("session creation proceed(): calling interceptor: %s", chain[idx].getInterceptorInstance());
            }
            SessionID sessionID = chain[idx].getInterceptorInstance().handleSessionCreation(this);
            return sessionID;
        }
        finally {
            --this.interceptorChainIndex;
        }
    }

    @Override
    public void requestRetry() {
        this.retry = true;
    }

    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    boolean shouldRetry() {
        return this.retry;
    }
}

