/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.metrics;

import java.util.OptionalDouble;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.metrics.Metric;
import org.wildfly.extension.metrics._private.MetricsLogger;

public class WildFlyMetric
implements Metric {
    private LocalModelControllerClient modelControllerClient;
    private final PathAddress address;
    private final String attributeName;

    public WildFlyMetric(LocalModelControllerClient modelControllerClient, PathAddress address, String attributeName) {
        this.modelControllerClient = modelControllerClient;
        this.address = address;
        this.attributeName = attributeName;
    }

    @Override
    public OptionalDouble getValue() {
        ModelNode result = this.readAttributeValue(this.address, this.attributeName);
        if (result.isDefined()) {
            try {
                return OptionalDouble.of(result.asDouble());
            }
            catch (Exception e) {
                MetricsLogger.LOGGER.unableToConvertAttribute(this.attributeName, this.address, e);
            }
        }
        return OptionalDouble.empty();
    }

    private ModelNode readAttributeValue(PathAddress address, String attributeName) {
        ModelNode readAttributeOp = new ModelNode();
        readAttributeOp.get("operation").set("read-attribute");
        readAttributeOp.get("address").set(address.toModelNode());
        readAttributeOp.get("include-undefined-metric-values").set(false);
        readAttributeOp.get("name").set(attributeName);
        ModelNode response = this.modelControllerClient.execute(readAttributeOp);
        String error = this.getFailureDescription(response);
        if (error != null) {
            if (error.contains("WFLYCTL0216")) {
                MetricsLogger.LOGGER.debugf("Unable to read attribute %s: %s.", attributeName, error);
            } else {
                MetricsLogger.LOGGER.unableToReadAttribute(attributeName, address, error);
            }
            return new ModelNode(ModelType.UNDEFINED);
        }
        return response.get("result");
    }

    private String getFailureDescription(ModelNode result) {
        if (result.hasDefined("failure-description")) {
            return result.get("failure-description").toString();
        }
        return null;
    }
}

