/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.time.YearMarshaller;

public class YearMonthMarshaller
implements ProtoStreamMarshaller<YearMonth> {
    private static final Month[] MONTHS = Month.values();
    private static final YearMonth DEFAULT = YearMonth.of(YearMarshaller.INSTANCE.getBuilder().getValue(), Month.JANUARY);
    private static final int YEAR_INDEX = 1;
    private static final int MONTH_INDEX = 1 + YearMarshaller.INSTANCE.getFields();

    @Override
    public YearMonth readFrom(ProtoStreamReader reader) throws IOException {
        YearMonth result = DEFAULT;
        boolean reading = true;
        while (reading) {
            int tag = reader.readTag();
            int index = WireFormat.getTagFieldNumber((int)tag);
            if (index >= 1 && index < MONTH_INDEX) {
                result = result.withYear(YearMarshaller.INSTANCE.readField(reader, index - 1, Year.of(result.getYear())).getValue());
                continue;
            }
            if (index == MONTH_INDEX) {
                result = result.withMonth(MONTHS[reader.readEnum()].getValue());
                continue;
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        return result;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, YearMonth value) throws IOException {
        Month month;
        int year = value.getYear();
        if (year != DEFAULT.getYear()) {
            YearMarshaller.INSTANCE.writeFields(writer, 1, Year.of(year));
        }
        if ((month = value.getMonth()) != DEFAULT.getMonth()) {
            writer.writeEnum(MONTH_INDEX, month.ordinal());
        }
    }

    @Override
    public Class<? extends YearMonth> getJavaClass() {
        return YearMonth.class;
    }
}

