/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.services.model.items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.services.model.FormItemRepresentation;
import org.jbpm.form.builder.services.model.forms.FormEncodingException;
import org.jbpm.form.builder.services.model.forms.FormEncodingFactory;
import org.jbpm.form.builder.services.model.forms.FormRepresentationDecoder;

public class MIGPanelRepresentation
extends FormItemRepresentation {
    private final List<List<FormItemRepresentation>> elements;
    private final Map<Cell, Integer> colspans = new HashMap<Cell, Integer>();
    private final Map<Cell, Integer> rowspans = new HashMap<Cell, Integer>();
    private Integer rows;
    private Integer borderWidth;
    private Integer cellSpacing;
    private Integer cellPadding;
    private String title;

    public MIGPanelRepresentation() {
        super("migPanel");
        this.elements = new ArrayList<List<FormItemRepresentation>>();
    }

    public Integer getRows() {
        return this.rows;
    }

    public void setRows(Integer rows) {
        this.rows = rows;
    }

    public Integer getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(Integer borderWidth) {
        this.borderWidth = borderWidth;
    }

    public Integer getCellSpacing() {
        return this.cellSpacing;
    }

    public void setCellSpacing(Integer cellSpacing) {
        this.cellSpacing = cellSpacing;
    }

    public Integer getCellPadding() {
        return this.cellPadding;
    }

    public void setCellPadding(Integer cellPadding) {
        this.cellPadding = cellPadding;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setElement(int rowNumber, int cellNumber, FormItemRepresentation subRep, int colspan, int rowspan) {
        while (this.elements.size() <= rowNumber) {
            this.elements.add(new ArrayList());
            this.rows = this.elements.size();
        }
        List<FormItemRepresentation> row = this.elements.get(rowNumber);
        while (row.size() <= cellNumber) {
            row.add(null);
        }
        row.set(cellNumber, subRep);
        this.elements.set(rowNumber, row);
        Cell cell = new Cell(rowNumber, cellNumber);
        this.colspans.put(cell, colspan);
        this.rowspans.put(cell, rowspan);
    }

    public List<List<FormItemRepresentation>> getElements() {
        return this.elements;
    }

    public int getColspan(int rowNumber, int cellNumber) {
        Cell index = new Cell(rowNumber, cellNumber);
        Integer colspan = this.colspans.get(index);
        return colspan == null ? 1 : colspan;
    }

    public int getRowspan(int rowNumber, int cellNumber) {
        Cell index = new Cell(rowNumber, cellNumber);
        Integer rowspan = this.rowspans.get(index);
        return rowspan == null ? 1 : rowspan;
    }

    @Override
    public Map<String, Object> getDataMap() {
        Map<String, Object> data = super.getDataMap();
        data.put("borderWidth", this.borderWidth);
        data.put("cellPadding", this.cellPadding);
        data.put("cellSpacing", this.cellSpacing);
        data.put("rows", this.rows);
        data.put("title", this.title);
        ArrayList colrowspanList = new ArrayList();
        ArrayList<Cell> cells = new ArrayList<Cell>();
        cells.addAll(this.colspans.keySet());
        cells.addAll(this.rowspans.keySet());
        for (Cell key : cells) {
            Integer colspan = this.colspans.get(key);
            Integer rowspan = this.rowspans.get(key);
            HashMap<String, Integer> obj = new HashMap<String, Integer>();
            obj.put("row", key.getRow());
            obj.put("cellNumber", key.getCellNumber());
            if (colspan != null) {
                obj.put("colspan", colspan);
            }
            if (rowspan != null) {
                obj.put("rowspan", rowspan);
            }
            colrowspanList.add(obj);
        }
        data.put("colrowspans", colrowspanList);
        ArrayList mapElements = new ArrayList();
        if (this.elements != null) {
            for (List<FormItemRepresentation> row : this.elements) {
                ArrayList<Map<String, Object>> mapRow = null;
                if (row != null) {
                    mapRow = new ArrayList<Map<String, Object>>();
                    for (FormItemRepresentation cell : row) {
                        mapRow.add(cell == null ? null : cell.getDataMap());
                    }
                }
                mapElements.add(mapRow);
            }
        }
        data.put("elements", mapElements);
        return data;
    }

    @Override
    public void setDataMap(Map<String, Object> data) throws FormEncodingException {
        super.setDataMap(data);
        this.borderWidth = data.get("borderWidth") == null ? null : Integer.valueOf(((Number)data.get("borderWidth")).intValue());
        this.cellPadding = data.get("cellPadding") == null ? null : Integer.valueOf(((Number)data.get("cellPadding")).intValue());
        this.cellSpacing = data.get("cellSpacing") == null ? null : Integer.valueOf(((Number)data.get("cellSpacing")).intValue());
        this.rows = data.get("rows") == null ? null : Integer.valueOf(((Number)data.get("rows")).intValue());
        this.title = (String)data.get("title");
        this.elements.clear();
        FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
        List mapElements = (List)data.get("elements");
        if (mapElements != null) {
            for (List mapRow : mapElements) {
                ArrayList<FormItemRepresentation> row = new ArrayList<FormItemRepresentation>();
                if (mapRow != null) {
                    for (Map mapCell : mapRow) {
                        row.add((FormItemRepresentation)decoder.decode(mapCell));
                    }
                }
                this.elements.add(row);
            }
        }
        this.rowspans.clear();
        this.colspans.clear();
        Object colrowspanList = data.get("colrowspans");
        if (colrowspanList != null) {
            List colrow = (List)colrowspanList;
            for (Object obj : colrow) {
                Integer rowspan;
                Map cell = (Map)obj;
                Integer row = cell.get("row") == null ? null : Integer.valueOf(((Number)cell.get("row")).intValue());
                Integer cellNumber = cell.get("cellNumber") == null ? null : Integer.valueOf(((Number)cell.get("cellNumber")).intValue());
                Integer colspan = cell.get("colspan") == null ? null : Integer.valueOf(((Number)cell.get("colspan")).intValue());
                Integer n = rowspan = cell.get("rowspan") == null ? null : Integer.valueOf(((Number)cell.get("rowspan")).intValue());
                if (colspan != null && row != null && cellNumber != null) {
                    this.colspans.put(new Cell(row, cellNumber), colspan);
                }
                if (rowspan == null || row == null || cellNumber == null) continue;
                this.rowspans.put(new Cell(row, cellNumber), rowspan);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals;
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MIGPanelRepresentation)) {
            return false;
        }
        MIGPanelRepresentation other = (MIGPanelRepresentation)obj;
        boolean bl = equals = this.rows == null && other.rows == null || this.rows != null && this.rows.equals(other.rows);
        if (!equals) {
            return equals;
        }
        boolean bl2 = equals = this.title == null && other.title == null || this.title != null && this.title.equals(other.title);
        if (!equals) {
            return equals;
        }
        boolean bl3 = equals = this.borderWidth == null && other.borderWidth == null || this.borderWidth != null && this.borderWidth.equals(other.borderWidth);
        if (!equals) {
            return equals;
        }
        boolean bl4 = equals = this.cellPadding == null && other.cellPadding == null || this.cellPadding != null && this.cellPadding.equals(other.cellPadding);
        if (!equals) {
            return equals;
        }
        boolean bl5 = equals = this.cellSpacing == null && other.cellSpacing == null || this.cellSpacing != null && this.cellSpacing.equals(other.cellSpacing);
        if (!equals) {
            return equals;
        }
        boolean bl6 = equals = this.elements == null && other.elements == null || this.elements != null && ((Object)this.elements).equals(other.elements);
        if (!equals) {
            return equals;
        }
        boolean bl7 = equals = this.rowspans == null && other.rowspans == null || this.rowspans != null && ((Object)this.rowspans.entrySet()).equals(other.rowspans.entrySet());
        if (!equals) {
            return equals;
        }
        equals = this.colspans == null && other.colspans == null || this.colspans != null && ((Object)this.colspans.entrySet()).equals(other.colspans.entrySet());
        return equals;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        int aux = this.rows == null ? 0 : this.rows.hashCode();
        result = 37 * result + aux;
        aux = this.title == null ? 0 : this.title.hashCode();
        result = 37 * result + aux;
        aux = this.borderWidth == null ? 0 : this.borderWidth.hashCode();
        result = 37 * result + aux;
        aux = this.cellPadding == null ? 0 : this.cellPadding.hashCode();
        result = 37 * result + aux;
        aux = this.cellSpacing == null ? 0 : this.cellSpacing.hashCode();
        result = 37 * result + aux;
        aux = this.elements == null ? 0 : ((Object)this.elements).hashCode();
        result = 37 * result + aux;
        aux = this.colspans == null ? 0 : ((Object)this.colspans).hashCode();
        result = 37 * result + aux;
        aux = this.rowspans == null ? 0 : ((Object)this.rowspans).hashCode();
        result = 37 * result + aux;
        return result;
    }

    class Cell {
        private int row;
        private int cellNumber;

        public Cell(int row, int cellNumber) {
            this.row = row;
            this.cellNumber = cellNumber;
        }

        public Cell() {
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public int getCellNumber() {
            return this.cellNumber;
        }

        public void setCellNumber(int cellNumber) {
            this.cellNumber = cellNumber;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.cellNumber;
            result = 31 * result + this.row;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Cell other = (Cell)obj;
            if (this.cellNumber != other.cellNumber) {
                return false;
            }
            return this.row == other.row;
        }
    }
}

