/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.command;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.command.AuditCommand;
import org.kie.internal.command.Context;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class FindActiveProcessInstancesCommand
extends AuditCommand<List<ProcessInstanceLog>> {
    private static final long serialVersionUID = 3096240261041200350L;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="string")
    private String processId = null;

    public FindActiveProcessInstancesCommand() {
    }

    public FindActiveProcessInstancesCommand(String processId) {
        this.processId = processId;
        if (processId == null || processId.isEmpty()) {
            throw new IllegalArgumentException("The processId field must not be null or empty.");
        }
    }

    public List<ProcessInstanceLog> execute(Context cntxt) {
        this.setLogEnvironment(cntxt);
        return this.auditLogService.findActiveProcessInstances(this.processId);
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String toString() {
        return AuditLogService.class.getSimpleName() + ".findActiveProcessInstances(" + this.processId + ")";
    }
}

