/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.TransactionManagerServices;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.impl.EnvironmentFactory;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorkingMemoryDbLoggerTest
extends AbstractBaseTest {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractWorkingMemoryDbLoggerTest.class);
    protected HashMap<String, Object> context;
    protected AuditLogService logService;

    @Before
    public void setUp() throws Exception {
        System.out.println("parent");
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory"));
        this.logService = new JPAAuditLogService(env);
    }

    @After
    public void tearDown() throws Exception {
        BitronixTransactionManager txm = TransactionManagerServices.getTransactionManager();
        Assert.assertTrue((String)"There is still a transaction running!", (txm.getCurrentTransaction() == null ? 1 : 0) != 0);
        PersistenceUtil.cleanUp(this.context);
        this.logService.dispose();
    }

    protected static KnowledgeBase createKnowledgeBase() {
        KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
        InputStreamReader source = new InputStreamReader(AbstractWorkingMemoryDbLoggerTest.class.getResourceAsStream("/ruleflow.rf"));
        builder.addProcessFromXml((Reader)source);
        source = new InputStreamReader(AbstractWorkingMemoryDbLoggerTest.class.getResourceAsStream("/ruleflow2.rf"));
        builder.addProcessFromXml((Reader)source);
        source = new InputStreamReader(AbstractWorkingMemoryDbLoggerTest.class.getResourceAsStream("/ruleflow3.rf"));
        builder.addProcessFromXml((Reader)source);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(Arrays.asList(builder.getPackage()));
        return kbase;
    }

    public abstract ProcessInstance startProcess(String var1);

    @Test
    public void testLogger1() {
        long processInstanceId = this.startProcess("com.sample.ruleflow").getId();
        logger.info("Checking process instances for process 'com.sample.ruleflow'");
        List processInstances = this.logService.findProcessInstances("com.sample.ruleflow");
        Assert.assertEquals((long)1L, (long)processInstances.size());
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(0);
        logger.info("{}", (Object)processInstance);
        Assert.assertNotNull((Object)processInstance.getStart());
        Assert.assertNotNull((Object)processInstance.getEnd());
        Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
        Assert.assertEquals((Object)"com.sample.ruleflow", (Object)processInstance.getProcessId());
        List nodeInstances = this.logService.findNodeInstances(processInstanceId);
        Assert.assertEquals((long)6L, (long)nodeInstances.size());
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            logger.info("{}", (Object)nodeInstance);
            Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
            Assert.assertEquals((Object)"com.sample.ruleflow", (Object)processInstance.getProcessId());
            Assert.assertNotNull((Object)nodeInstance.getDate());
        }
        this.logService.clear();
    }

    @Test
    public void testLogger2() {
        this.startProcess("com.sample.ruleflow");
        this.startProcess("com.sample.ruleflow");
        logger.info("Checking process instances for process 'com.sample.ruleflow'");
        List processInstances = this.logService.findProcessInstances("com.sample.ruleflow");
        Assert.assertEquals((long)2L, (long)processInstances.size());
        for (ProcessInstanceLog processInstance : processInstances) {
            logger.info("{}", (Object)processInstance);
            logger.info(" -> {} - {}", (Object)processInstance.getStart(), (Object)processInstance.getEnd());
            List nodeInstances = this.logService.findNodeInstances(processInstance.getProcessInstanceId());
            for (NodeInstanceLog nodeInstance : nodeInstances) {
                logger.info("{}", (Object)nodeInstance);
                logger.info(" -> {}", (Object)nodeInstance.getDate());
            }
            Assert.assertEquals((long)6L, (long)nodeInstances.size());
        }
        this.logService.clear();
    }

    @Test
    public void testLogger3() {
        long processInstanceId = this.startProcess("com.sample.ruleflow2").getId();
        logger.info("Checking process instances for process 'com.sample.ruleflow2'");
        List processInstances = this.logService.findProcessInstances("com.sample.ruleflow2");
        Assert.assertEquals((long)1L, (long)processInstances.size());
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(0);
        logger.info("{}", (Object)processInstance);
        logger.info(" -> {} - {} ", (Object)processInstance.getStart(), (Object)processInstance.getEnd());
        Assert.assertNotNull((Object)processInstance.getStart());
        Assert.assertNotNull((Object)processInstance.getEnd());
        Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
        Assert.assertEquals((Object)"com.sample.ruleflow2", (Object)processInstance.getProcessId());
        List nodeInstances = this.logService.findNodeInstances(processInstanceId);
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            logger.info("{}", (Object)nodeInstance);
            logger.info(" -> {}", (Object)nodeInstance.getDate());
            Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
            Assert.assertEquals((Object)"com.sample.ruleflow2", (Object)processInstance.getProcessId());
            Assert.assertNotNull((Object)nodeInstance.getDate());
        }
        Assert.assertEquals((long)14L, (long)nodeInstances.size());
        this.logService.clear();
    }
}

