/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.query;

import javax.persistence.EntityManagerFactory;
import org.jbpm.persistence.correlation.JPACorrelationKeyFactory;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.query.AuditQueryDataUtil;
import org.jbpm.process.audit.strategy.StandaloneJtaStrategy;
import org.jbpm.query.QueryBuilderCoverageTestUtil;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.query.ExtendedParametrizedQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.AuditLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.NodeInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditQueryCoverageTest
extends JPAAuditLogService {
    private static final Logger logger = LoggerFactory.getLogger(AuditQueryCoverageTest.class);
    private static EntityManagerFactory emf;
    private ProcessInstanceLog[] pilTestData;
    private VariableInstanceLog[] vilTestData;
    private NodeInstanceLog[] nilTestData;
    private static QueryBuilderCoverageTestUtil.ModuleSpecificInputFiller inputFiller;

    @BeforeClass
    public static void configure() {
        emf = QueryBuilderCoverageTestUtil.beforeClass((String)"org.jbpm.persistence.jpa");
    }

    @AfterClass
    public static void reset() {
        QueryBuilderCoverageTestUtil.afterClass();
    }

    @Before
    public void setUp() throws Exception {
        if (this.pilTestData == null) {
            this.pilTestData = AuditQueryDataUtil.createTestProcessInstanceLogData(emf);
            this.vilTestData = AuditQueryDataUtil.createTestVariableInstanceLogData(emf);
            this.nilTestData = AuditQueryDataUtil.createTestNodeInstanceLogData(emf);
        }
        this.persistenceStrategy = new StandaloneJtaStrategy(emf);
    }

    @Test
    public void processInstanceLogQueryCoverageTest() {
        ProcessInstanceLogQueryBuilder queryBuilder = this.processInstanceLogQuery();
        Class<ProcessInstanceLogQueryBuilder> builderClass = ProcessInstanceLogQueryBuilder.class;
        QueryBuilderCoverageTestUtil.queryBuilderCoverageTest((ExtendedParametrizedQueryBuilder)queryBuilder, builderClass, (QueryBuilderCoverageTestUtil.ModuleSpecificInputFiller)inputFiller, (String[])new String[0]);
    }

    @Test
    public void variableInstanceLogQueryBuilderCoverageTest() {
        VariableInstanceLogQueryBuilder queryBuilder = this.variableInstanceLogQuery();
        Class<VariableInstanceLogQueryBuilder> builderClass = VariableInstanceLogQueryBuilder.class;
        QueryBuilderCoverageTestUtil.queryBuilderCoverageTest((ExtendedParametrizedQueryBuilder)queryBuilder, builderClass, (QueryBuilderCoverageTestUtil.ModuleSpecificInputFiller)inputFiller, (String[])new String[0]);
    }

    @Test
    public void nodeInstanceLogQueryBuilderCoverageTest() {
        NodeInstanceLogQueryBuilder queryBuilder = this.nodeInstanceLogQuery();
        Class<NodeInstanceLogQueryBuilder> builderClass = NodeInstanceLogQueryBuilder.class;
        QueryBuilderCoverageTestUtil.queryBuilderCoverageTest((ExtendedParametrizedQueryBuilder)queryBuilder, builderClass, (QueryBuilderCoverageTestUtil.ModuleSpecificInputFiller)inputFiller, (String[])new String[0]);
    }

    static {
        inputFiller = new QueryBuilderCoverageTestUtil.ModuleSpecificInputFiller(){
            private final JPACorrelationKeyFactory correlationKeyFactory = new JPACorrelationKeyFactory();
            private int orderByType = 0;

            public Object fillInput(Class type) {
                if (type.equals(CorrelationKey.class)) {
                    return this.correlationKeyFactory.newCorrelationKey("business-key");
                }
                if (type.equals(AuditLogQueryBuilder.OrderBy.class)) {
                    return this.orderByType++ % 2 == 0 ? AuditLogQueryBuilder.OrderBy.processId : AuditLogQueryBuilder.OrderBy.processInstanceId;
                }
                if (type.isArray()) {
                    CorrelationKey[] corrKeyArr = new CorrelationKey[]{this.correlationKeyFactory.newCorrelationKey("key:one"), this.correlationKeyFactory.newCorrelationKey("key:two")};
                    return corrKeyArr;
                }
                return null;
            }
        };
    }
}

