/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.HashMap;
import java.util.List;
import org.jbpm.process.audit.AbstractAuditLogServiceTest;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.command.AuditCommand;
import org.jbpm.process.audit.command.ClearHistoryLogsCommand;
import org.jbpm.process.audit.command.FindNodeInstancesCommand;
import org.jbpm.process.audit.command.FindProcessInstancesCommand;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneAuditLogServiceTest
extends AbstractAuditLogServiceTest {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneAuditLogServiceTest.class);
    private HashMap<String, Object> context;
    private AuditLogService auditLogService;
    private KieSession ksession;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.jbpm.persistence.jpa");
        Environment env = PersistenceUtil.createEnvironment(this.context);
        KieBase kbase = StandaloneAuditLogServiceTest.createKnowledgeBase();
        this.ksession = StandaloneAuditLogServiceTest.createKieSession(kbase, env);
        new JPAWorkingMemoryDbLogger(this.ksession);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.auditLogService = new JPAAuditLogService(env);
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    private <T> T setAuditLogServiceAndExecute(AuditCommand<T> cmd) {
        cmd.setAuditLogService(this.auditLogService);
        return (T)cmd.execute(null);
    }

    @Test
    public void setAuditLogServiceForCommandTest() {
        String PROCESS_ID = "com.sample.ruleflow";
        List processInstances = (List)this.setAuditLogServiceAndExecute((AuditCommand)new FindProcessInstancesCommand(PROCESS_ID));
        int initialProcessInstanceSize = processInstances.size();
        long processInstanceId = this.ksession.startProcess(PROCESS_ID).getId();
        logger.debug("Checking process instances for process '{}'", (Object)PROCESS_ID);
        processInstances = (List)this.setAuditLogServiceAndExecute((AuditCommand)new FindProcessInstancesCommand(PROCESS_ID));
        Assert.assertEquals((long)(initialProcessInstanceSize + 1), (long)processInstances.size());
        ProcessInstanceLog processInstance = (ProcessInstanceLog)processInstances.get(initialProcessInstanceSize);
        logger.debug("{} -> {} - {}", new Object[]{processInstance.toString(), processInstance.getStart(), processInstance.getEnd()});
        Assert.assertNotNull((Object)processInstance.getStart());
        Assert.assertNotNull((String)"ProcessInstanceLog does not contain end date.", (Object)processInstance.getEnd());
        Assert.assertEquals((long)processInstanceId, (long)processInstance.getProcessInstanceId());
        Assert.assertEquals((Object)PROCESS_ID, (Object)processInstance.getProcessId());
        List nodeInstances = (List)this.setAuditLogServiceAndExecute((AuditCommand)new FindNodeInstancesCommand(processInstanceId));
        Assert.assertEquals((long)6L, (long)nodeInstances.size());
        this.setAuditLogServiceAndExecute((AuditCommand)new ClearHistoryLogsCommand());
        nodeInstances = (List)this.setAuditLogServiceAndExecute((AuditCommand)new FindNodeInstancesCommand(processInstanceId));
        Assert.assertEquals((long)0L, (long)nodeInstances.size());
        processInstances = (List)this.setAuditLogServiceAndExecute((AuditCommand)new FindProcessInstancesCommand(PROCESS_ID));
        Assert.assertEquals((long)0L, (long)processInstances.size());
    }
}

