/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.query;

import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.strategy.StandaloneJtaStrategy;
import org.junit.Assert;

public class AuditQueryDataUtil {
    private static Random random = new Random();
    private static List<Object> createdEntities = new LinkedList<Object>();
    static int MAX = 2;
    static int MIN = 1;
    static int BOTH = 0;

    static long randomLong() {
        long result = Math.abs(random.nextInt());
        while (result == 23L) {
            result = Math.abs(random.nextInt());
        }
        return result;
    }

    static String randomString() {
        return UUID.randomUUID().toString();
    }

    static Calendar randomCal() {
        Calendar cal = GregorianCalendar.getInstance();
        cal.roll(6, -1 * random.nextInt(3650));
        cal.set(14, 0);
        cal.set(13, 0);
        return cal;
    }

    static ProcessInstanceLog[] createTestProcessInstanceLogData(EntityManagerFactory emf) {
        int i;
        StandaloneJtaStrategy jtaHelper = new StandaloneJtaStrategy(emf);
        EntityManager em = jtaHelper.getEntityManager();
        int numEntities = 11;
        ProcessInstanceLog[] testData = new ProcessInstanceLog[numEntities];
        Calendar cal = AuditQueryDataUtil.randomCal();
        for (i = 0; i < numEntities; ++i) {
            ProcessInstanceLog pil = new ProcessInstanceLog(AuditQueryDataUtil.randomLong(), AuditQueryDataUtil.randomString());
            pil.setDuration(Long.valueOf(AuditQueryDataUtil.randomLong()));
            pil.setExternalId(AuditQueryDataUtil.randomString());
            pil.setIdentity(AuditQueryDataUtil.randomString());
            pil.setOutcome(AuditQueryDataUtil.randomString());
            pil.setParentProcessInstanceId(AuditQueryDataUtil.randomLong());
            pil.setProcessId(AuditQueryDataUtil.randomString());
            pil.setProcessName(AuditQueryDataUtil.randomString());
            pil.setProcessVersion(AuditQueryDataUtil.randomString());
            pil.setStatus(random.nextInt());
            pil.setCorrelationKey(AuditQueryDataUtil.randomString());
            cal.add(12, 1);
            pil.setStart(cal.getTime());
            cal.add(6, 1);
            pil.setEnd(cal.getTime());
            testData[i] = pil;
        }
        block13: for (i = 0; i < numEntities; ++i) {
            switch (i) {
                case 1: {
                    testData[i - 1].setDuration(testData[i].getDuration());
                    continue block13;
                }
                case 2: {
                    testData[i - 1].setEnd(testData[i].getEnd());
                    continue block13;
                }
                case 3: {
                    testData[i - 1].setIdentity(testData[i].getIdentity());
                    continue block13;
                }
                case 4: {
                    testData[i - 1].setProcessId(testData[i].getProcessId());
                    continue block13;
                }
                case 5: {
                    testData[i - 1].setProcessInstanceId(testData[i].getProcessInstanceId().longValue());
                    continue block13;
                }
                case 6: {
                    testData[i - 1].setProcessName(testData[i].getProcessName());
                    continue block13;
                }
                case 7: {
                    testData[i - 1].setProcessVersion(testData[i].getProcessVersion());
                    continue block13;
                }
                case 8: {
                    testData[i - 1].setStart(testData[i].getStart());
                    continue block13;
                }
                case 9: {
                    testData[i - 1].setStatus(testData[i].getStatus().intValue());
                    continue block13;
                }
                case 10: {
                    testData[i - 1].setOutcome(testData[i].getOutcome());
                }
            }
        }
        Object tx = jtaHelper.joinTransaction(em);
        for (int i2 = 0; i2 < numEntities; ++i2) {
            em.persist((Object)testData[i2]);
        }
        jtaHelper.leaveTransaction(em, tx);
        createdEntities.addAll(Arrays.asList(testData));
        return testData;
    }

    static VariableInstanceLog[] createTestVariableInstanceLogData(EntityManagerFactory emf) {
        int i;
        StandaloneJtaStrategy jtaHelper = new StandaloneJtaStrategy(emf);
        EntityManager em = jtaHelper.getEntityManager();
        int numEntities = 8;
        VariableInstanceLog[] testData = new VariableInstanceLog[numEntities];
        Calendar cal = AuditQueryDataUtil.randomCal();
        for (i = 0; i < numEntities; ++i) {
            VariableInstanceLog vil = new VariableInstanceLog();
            vil.setProcessInstanceId(AuditQueryDataUtil.randomLong());
            vil.setProcessId(AuditQueryDataUtil.randomString());
            cal.add(12, 1);
            vil.setDate(cal.getTime());
            vil.setVariableInstanceId(AuditQueryDataUtil.randomString());
            vil.setVariableId(AuditQueryDataUtil.randomString());
            vil.setValue(AuditQueryDataUtil.randomString());
            vil.setOldValue(AuditQueryDataUtil.randomString());
            vil.setExternalId(AuditQueryDataUtil.randomString());
            testData[i] = vil;
        }
        block10: for (i = 0; i < numEntities; ++i) {
            switch (i) {
                case 1: {
                    testData[i - 1].setDate(testData[i].getDate());
                    continue block10;
                }
                case 2: {
                    testData[i - 1].setOldValue(testData[i].getOldValue());
                    continue block10;
                }
                case 3: {
                    testData[i - 1].setProcessId(testData[i].getProcessId());
                    continue block10;
                }
                case 4: {
                    testData[i - 1].setProcessInstanceId(testData[i].getProcessInstanceId().longValue());
                    continue block10;
                }
                case 5: {
                    testData[i - 1].setValue(testData[i].getValue());
                    continue block10;
                }
                case 6: {
                    testData[i - 1].setVariableId(testData[i].getVariableId());
                    continue block10;
                }
                case 7: {
                    testData[i - 1].setVariableInstanceId(testData[i].getVariableInstanceId());
                }
            }
        }
        Object tx = jtaHelper.joinTransaction(em);
        for (int i2 = 0; i2 < numEntities; ++i2) {
            em.persist((Object)testData[i2]);
        }
        jtaHelper.leaveTransaction(em, tx);
        createdEntities.addAll(Arrays.asList(testData));
        return testData;
    }

    static NodeInstanceLog[] createTestNodeInstanceLogData(EntityManagerFactory emf) {
        int i;
        StandaloneJtaStrategy jtaHelper = new StandaloneJtaStrategy(emf);
        EntityManager em = jtaHelper.getEntityManager();
        int numEntities = 9;
        NodeInstanceLog[] testData = new NodeInstanceLog[numEntities];
        Calendar cal = AuditQueryDataUtil.randomCal();
        for (i = 0; i < numEntities; ++i) {
            NodeInstanceLog nil = new NodeInstanceLog();
            nil.setProcessInstanceId(AuditQueryDataUtil.randomLong());
            nil.setProcessId(AuditQueryDataUtil.randomString());
            cal.add(13, 1);
            nil.setDate(cal.getTime());
            nil.setType(Math.abs(random.nextInt()));
            nil.setNodeInstanceId(AuditQueryDataUtil.randomString());
            nil.setNodeId(AuditQueryDataUtil.randomString());
            nil.setNodeName(AuditQueryDataUtil.randomString());
            nil.setNodeType(AuditQueryDataUtil.randomString());
            nil.setWorkItemId(Long.valueOf(AuditQueryDataUtil.randomLong()));
            nil.setConnection(AuditQueryDataUtil.randomString());
            nil.setExternalId(AuditQueryDataUtil.randomString());
            testData[i] = nil;
        }
        block11: for (i = 0; i < numEntities; ++i) {
            switch (i) {
                case 1: {
                    testData[i - 1].setDate(testData[i].getDate());
                    continue block11;
                }
                case 2: {
                    testData[i - 1].setNodeId(testData[i].getNodeId());
                    continue block11;
                }
                case 3: {
                    testData[i - 1].setNodeInstanceId(testData[i].getNodeInstanceId());
                    continue block11;
                }
                case 4: {
                    testData[i - 1].setNodeName(testData[i].getNodeName());
                    continue block11;
                }
                case 5: {
                    testData[i - 1].setNodeType(testData[i].getNodeType());
                    continue block11;
                }
                case 6: {
                    testData[i - 1].setProcessId(testData[i].getProcessId());
                    continue block11;
                }
                case 7: {
                    testData[i - 1].setProcessInstanceId(testData[i].getProcessInstanceId().longValue());
                    continue block11;
                }
                case 8: {
                    testData[i - 1].setWorkItemId(testData[i].getWorkItemId());
                }
            }
        }
        Object tx = jtaHelper.joinTransaction(em);
        for (int i2 = 0; i2 < numEntities; ++i2) {
            em.persist((Object)testData[i2]);
        }
        jtaHelper.leaveTransaction(em, tx);
        createdEntities.addAll(Arrays.asList(testData));
        return testData;
    }

    static void verifyMaxMinDuration(List<org.kie.api.runtime.manager.audit.ProcessInstanceLog> procInstLogs, int test, long ... maxOrMin) {
        for (org.kie.api.runtime.manager.audit.ProcessInstanceLog log : procInstLogs) {
            Assert.assertNotNull((String)"Duration is null", (Object)log.getDuration());
            long dur = log.getDuration();
            if (test == MAX) {
                Assert.assertTrue((String)("Duration " + dur + " is larger than max " + maxOrMin[0] + ": " + dur), (dur <= maxOrMin[0] ? 1 : 0) != 0);
                continue;
            }
            if (test == MIN) {
                Assert.assertTrue((String)("Duration " + dur + " is smaller than min " + maxOrMin[0]), (dur >= maxOrMin[0] ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((String)("Duration " + dur + " is smaller than min " + maxOrMin[0]), (dur >= maxOrMin[0] ? 1 : 0) != 0);
            Assert.assertTrue((String)("Duration " + dur + " is larger than max " + maxOrMin[1]), (dur <= maxOrMin[1] ? 1 : 0) != 0);
        }
    }

    static void cleanDB(EntityManagerFactory emf) {
        StandaloneJtaStrategy jtaHelper = new StandaloneJtaStrategy(emf);
        EntityManager em = jtaHelper.getEntityManager();
        Object tx = jtaHelper.joinTransaction(em);
        for (Object entity : createdEntities) {
            Object mergedEntity = em.merge(entity);
            em.remove(mergedEntity);
        }
        jtaHelper.leaveTransaction(em, tx);
    }
}

