/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.emfextmodel.util;

import java.math.BigInteger;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.jbpm.bpmn2.emfextmodel.DocumentRoot;
import org.jbpm.bpmn2.emfextmodel.EmfextmodelPackage;
import org.jbpm.bpmn2.emfextmodel.GlobalType;
import org.jbpm.bpmn2.emfextmodel.ImportType;
import org.jbpm.bpmn2.emfextmodel.OnEntryScriptType;
import org.jbpm.bpmn2.emfextmodel.OnExitScriptType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfextmodelValidator
extends EObjectValidator {
    public static final EmfextmodelValidator INSTANCE = new EmfextmodelValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.jbpm.bpmn2.emfextmodel";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;
    public static final BigInteger PRIORITY_TYPE__MIN__VALUE = new BigInteger("1");
    public static final BigInteger VERSION_TYPE__MIN__VALUE = new BigInteger("0");

    protected EPackage getEPackage() {
        return EmfextmodelPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateDocumentRoot((DocumentRoot)value, diagnostics, context);
            }
            case 1: {
                return this.validateGlobalType((GlobalType)value, diagnostics, context);
            }
            case 2: {
                return this.validateImportType((ImportType)value, diagnostics, context);
            }
            case 3: {
                return this.validateOnEntryScriptType((OnEntryScriptType)value, diagnostics, context);
            }
            case 4: {
                return this.validateOnExitScriptType((OnExitScriptType)value, diagnostics, context);
            }
            case 5: {
                return this.validatePackageNameType((String)value, diagnostics, context);
            }
            case 6: {
                return this.validatePriorityType((BigInteger)value, diagnostics, context);
            }
            case 7: {
                return this.validateRuleFlowGroupType((String)value, diagnostics, context);
            }
            case 8: {
                return this.validateTaskNameType((String)value, diagnostics, context);
            }
            case 9: {
                return this.validateVersionType((BigInteger)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateDocumentRoot(DocumentRoot documentRoot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(documentRoot, diagnostics, context);
    }

    public boolean validateGlobalType(GlobalType globalType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(globalType, diagnostics, context);
    }

    public boolean validateImportType(ImportType importType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(importType, diagnostics, context);
    }

    public boolean validateOnEntryScriptType(OnEntryScriptType onEntryScriptType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(onEntryScriptType, diagnostics, context);
    }

    public boolean validateOnExitScriptType(OnExitScriptType onExitScriptType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(onExitScriptType, diagnostics, context);
    }

    public boolean validatePackageNameType(String packageNameType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validatePriorityType(BigInteger priorityType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validatePriorityType_Min(priorityType, diagnostics, context);
        return result;
    }

    public boolean validatePriorityType_Min(BigInteger priorityType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = priorityType.compareTo(PRIORITY_TYPE__MIN__VALUE) >= 0;
        if (!result && diagnostics != null) {
            this.reportMinViolation(EmfextmodelPackage.Literals.PRIORITY_TYPE, priorityType, PRIORITY_TYPE__MIN__VALUE, true, diagnostics, context);
        }
        return result;
    }

    public boolean validateRuleFlowGroupType(String ruleFlowGroupType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateTaskNameType(String taskNameType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateVersionType(BigInteger versionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateVersionType_Min(versionType, diagnostics, context);
        return result;
    }

    public boolean validateVersionType_Min(BigInteger versionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = versionType.compareTo(VERSION_TYPE__MIN__VALUE) >= 0;
        if (!result && diagnostics != null) {
            this.reportMinViolation(EmfextmodelPackage.Literals.VERSION_TYPE, versionType, VERSION_TYPE__MIN__VALUE, true, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

