/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.drools;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TimeUnit implements Enumerator
{
    MS(0, "ms", "ms"),
    S(1, "s", "s"),
    MIN(2, "min", "min"),
    HOUR(3, "hour", "hour"),
    DAY(4, "day", "day"),
    YEAR(5, "year", "year");

    public static final int MS_VALUE = 0;
    public static final int S_VALUE = 1;
    public static final int MIN_VALUE = 2;
    public static final int HOUR_VALUE = 3;
    public static final int DAY_VALUE = 4;
    public static final int YEAR_VALUE = 5;
    private static final TimeUnit[] VALUES_ARRAY;
    public static final List<TimeUnit> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static TimeUnit get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            TimeUnit result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static TimeUnit getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            TimeUnit result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static TimeUnit get(int value) {
        switch (value) {
            case 0: {
                return MS;
            }
            case 1: {
                return S;
            }
            case 2: {
                return MIN;
            }
            case 3: {
                return HOUR;
            }
            case 4: {
                return DAY;
            }
            case 5: {
                return YEAR;
            }
        }
        return null;
    }

    private TimeUnit(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new TimeUnit[]{MS, S, MIN, HOUR, DAY, YEAR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

