/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.emfextmodel;

import bpsim.BPSimDataType;
import bpsim.BpsimFactory;
import bpsim.BpsimPackage;
import bpsim.DocumentRoot;
import bpsim.ElementParameters;
import bpsim.Parameter;
import bpsim.Scenario;
import bpsim.ScenarioParameters;
import bpsim.TimeParameters;
import bpsim.TimeUnit;
import bpsim.UniformDistributionType;
import bpsim.util.BpsimResourceFactoryImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class BpsimTest
extends TestCase {
    private ResourceSet resourceSet;

    protected void setUp() throws Exception {
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new BpsimResourceFactoryImpl());
        this.resourceSet.getPackageRegistry().put((Object)"http://www.bpsim.org/schemas/1.0", (Object)BpsimPackage.eINSTANCE);
    }

    protected void tearDown() throws Exception {
    }

    public void testBpsimData() throws Exception {
        XMLResource inResource = (XMLResource)this.resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
        inResource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
        inResource.setEncoding("UTF-8");
        DocumentRoot documentRoot = BpsimFactory.eINSTANCE.createDocumentRoot();
        BPSimDataType bpsimData = BpsimFactory.eINSTANCE.createBPSimDataType();
        Scenario defaultScenario = BpsimFactory.eINSTANCE.createScenario();
        defaultScenario.setId("default");
        defaultScenario.setName("Scenario");
        ScenarioParameters scenarioParams = BpsimFactory.eINSTANCE.createScenarioParameters();
        scenarioParams.setBaseTimeUnit(TimeUnit.S);
        defaultScenario.setScenarioParameters(scenarioParams);
        ElementParameters elementParams = BpsimFactory.eINSTANCE.createElementParameters();
        TimeParameters elementTimeParams = BpsimFactory.eINSTANCE.createTimeParameters();
        Parameter processingTimeParameter = BpsimFactory.eINSTANCE.createParameter();
        UniformDistributionType uniformDistrobutionType = BpsimFactory.eINSTANCE.createUniformDistributionType();
        uniformDistrobutionType.setMin(180.0);
        uniformDistrobutionType.setMax(600.0);
        processingTimeParameter.getParameterValue().add((Object)uniformDistrobutionType);
        elementTimeParams.setProcessingTime(processingTimeParameter);
        elementParams.setTimeParameters(elementTimeParams);
        defaultScenario.getElementParameters().add((Object)elementParams);
        bpsimData.getScenario().add((Object)defaultScenario);
        documentRoot.setBPSimData(bpsimData);
        inResource.getContents().add((Object)documentRoot);
        StringWriter stringWriter = new StringWriter();
        inResource.save((Writer)stringWriter, null);
        BpsimTest.assertNotNull((Object)stringWriter.getBuffer().toString());
        if (stringWriter.getBuffer().toString().length() < 1) {
            BpsimTest.fail((String)"generated xml is empty");
        }
        XMLResource outResource = (XMLResource)this.resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
        outResource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
        outResource.setEncoding("UTF-8");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        ByteArrayInputStream is = new ByteArrayInputStream(stringWriter.getBuffer().toString().getBytes("UTF-8"));
        outResource.load((InputStream)is, options);
        DocumentRoot outRoot = (DocumentRoot)outResource.getContents().get(0);
        BpsimTest.assertNotNull((Object)outRoot.getBPSimData());
        BPSimDataType outAnalysisData = outRoot.getBPSimData();
        BpsimTest.assertEquals((int)outAnalysisData.getScenario().size(), (int)1);
        Scenario outScenario = (Scenario)outAnalysisData.getScenario().get(0);
        BpsimTest.assertEquals((int)outScenario.getElementParameters().size(), (int)1);
        BpsimTest.assertEquals((String)outScenario.getId(), (String)"default");
        BpsimTest.assertEquals((String)outScenario.getName(), (String)"Scenario");
        BpsimTest.assertNotNull((Object)outScenario.getScenarioParameters());
        BpsimTest.assertNotNull((Object)outScenario.getElementParameters());
        BpsimTest.assertEquals((int)outScenario.getElementParameters().size(), (int)1);
        ElementParameters outElementParamType = (ElementParameters)outScenario.getElementParameters().get(0);
        BpsimTest.assertNotNull((Object)outElementParamType.getTimeParameters());
        TimeParameters outTimeParams = outElementParamType.getTimeParameters();
        BpsimTest.assertNotNull((Object)outTimeParams.getProcessingTime());
        BpsimTest.assertEquals((int)outTimeParams.getProcessingTime().getParameterValue().size(), (int)1);
        UniformDistributionType outDistributionType = (UniformDistributionType)outTimeParams.getProcessingTime().getParameterValue().get(0);
        BpsimTest.assertEquals((Object)outDistributionType.getMax(), (Object)600.0);
        BpsimTest.assertEquals((Object)outDistributionType.getMin(), (Object)180.0);
    }
}

