/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.Map;
import org.drools.core.command.impl.RegistryContext;
import org.jbpm.casemgmt.api.StageNotFoundException;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.DynamicUtils;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;

public class AddDynamicTaskToStageCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6345222909719335954L;
    private String caseId;
    private String nodeType;
    private String stageId;
    private long processInstanceId;
    private Map<String, Object> parameters;

    public AddDynamicTaskToStageCommand(String caseId, String nodeType, Long processInstanceId, String stageId, Map<String, Object> parameters) {
        this.caseId = caseId;
        this.nodeType = nodeType;
        this.processInstanceId = processInstanceId;
        this.stageId = stageId;
        this.parameters = parameters;
        if (processInstanceId == null || stageId == null) {
            throw new IllegalArgumentException("Process instance id and stage id are mandatory");
        }
    }

    public Void execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        ProcessInstance processInstance = ksession.getProcessInstance(this.processInstanceId);
        DynamicNodeInstance dynamicContext = ((WorkflowProcessInstanceImpl)processInstance).getNodeInstances(true).stream().filter(ni -> ni instanceof DynamicNodeInstance && this.stageId.equals(ni.getNode().getMetaData().get("UniqueId"))).findFirst().orElse(null);
        if (dynamicContext == null) {
            throw new StageNotFoundException("No stage found with id " + this.stageId);
        }
        CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
        caseEventSupport.fireBeforeDynamicTaskAdded(this.caseId, this.processInstanceId, this.nodeType, this.parameters);
        DynamicUtils.addDynamicWorkItem((DynamicNodeInstance)dynamicContext, (KieRuntime)ksession, (String)this.nodeType, this.parameters);
        caseEventSupport.fireAfterDynamicTaskAdded(this.caseId, this.processInstanceId, this.nodeType, this.parameters);
        return null;
    }
}

