/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.marshalling;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.persistence.TransactionAware;
import org.drools.persistence.TransactionManager;
import org.jbpm.casemgmt.api.model.instance.CaseRoleInstance;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.jbpm.casemgmt.impl.marshalling.SerializedContent;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.internal.runtime.Cacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseFileInstanceMarshallingStrategy
implements ObjectMarshallingStrategy,
TransactionAware,
Cacheable {
    private static final Logger logger = LoggerFactory.getLogger(CaseFileInstanceMarshallingStrategy.class);
    private static final String CASE_ID_KEY = "CaseId";
    private static final String CASE_START_KEY = "CaseStart";
    private static final String CASE_END_KEY = "CaseEnd";
    private static final String CASE_REOPEN_KEY = "CaseReopen";
    private static final String CASE_ROLE_ASSIGNMENTS_KEY = "CaseRoleAssignments";
    private static final String CASE_COMMENTS_KEY = "CaseComments";
    private static final String CASE_DATA_KEY = "CaseData";
    private Map<String, ObjectMarshallingStrategy> marshallersByName = new LinkedHashMap<String, ObjectMarshallingStrategy>();
    private SerializablePlaceholderResolverStrategy caseFileMarshaller = new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT);

    public CaseFileInstanceMarshallingStrategy() {
        this.marshallersByName.put(this.caseFileMarshaller.getClass().getName(), (ObjectMarshallingStrategy)this.caseFileMarshaller);
        logger.debug("Created CaseFileInstance marshaller with default marshaller only");
    }

    public CaseFileInstanceMarshallingStrategy(ObjectMarshallingStrategy ... strategies) {
        for (ObjectMarshallingStrategy strategy : strategies) {
            logger.debug("Adding {} marshaller into CaseFileInstance marshaller under name {}", (Object)strategy, (Object)strategy.getClass().getName());
            this.marshallersByName.put(strategy.getClass().getName(), strategy);
        }
        this.marshallersByName.put(this.caseFileMarshaller.getClass().getName(), (ObjectMarshallingStrategy)this.caseFileMarshaller);
        logger.debug("Created CaseFileInstance marshaller with following marshallers {}", this.marshallersByName);
    }

    public void close() {
        this.marshallersByName.values().stream().filter(m -> m instanceof Cacheable).forEach(m -> {
            logger.debug("Closing {} marshaller on close of {}", m, (Object)this);
            ((Cacheable)m).close();
        });
    }

    public void onStart(TransactionManager txm) {
        this.marshallersByName.values().stream().filter(m -> m instanceof TransactionAware).forEach(m -> {
            logger.debug("Calling onStart (txm) on {} marshaller", m);
            ((TransactionAware)m).onStart(txm);
        });
    }

    public void onEnd(TransactionManager txm) {
        this.marshallersByName.values().stream().filter(m -> m instanceof TransactionAware).forEach(m -> {
            logger.debug("Calling onEnd (txm) on {} marshaller", m);
            ((TransactionAware)m).onStart(txm);
        });
    }

    public boolean accept(Object object) {
        if (object instanceof CaseFileInstanceImpl) {
            logger.debug("{} object is of CaseFileInstanceImpl type, will be serialized by CaseFileInstanceMarshaller", object);
            return true;
        }
        return false;
    }

    public void write(ObjectOutputStream os, Object object) throws IOException {
        throw new UnsupportedOperationException("org.jbpm.casemgmt.impl.marshalling.CaseFileInstanceMarshallingStrategy.write(ObjectOutputStream, Object) is not supported");
    }

    public Object read(ObjectInputStream os) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("org.jbpm.casemgmt.impl.marshalling.CaseFileInstanceMarshallingStrategy.read(ObjectInputStream) is not supported");
    }

    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream os, Object object) throws IOException {
        logger.debug("About to marshal {}", object);
        CaseFileInstanceImpl caseFile = (CaseFileInstanceImpl)object;
        HashMap<String, Object> caseFileContent = new HashMap<String, Object>();
        caseFileContent.put(CASE_ID_KEY, caseFile.getCaseId());
        caseFileContent.put(CASE_START_KEY, caseFile.getCaseStartDate());
        caseFileContent.put(CASE_END_KEY, caseFile.getCaseEndDate());
        caseFileContent.put(CASE_REOPEN_KEY, caseFile.getCaseReopenDate());
        caseFileContent.put(CASE_ROLE_ASSIGNMENTS_KEY, new HashMap<String, CaseRoleInstance>(caseFile.getRolesAssignments()));
        caseFileContent.put(CASE_COMMENTS_KEY, new ArrayList<CommentInstance>(caseFile.getComments()));
        logger.debug("CaseFileContent before case file data is {}", caseFileContent);
        ArrayList<SerializedContent> caseDataContent = new ArrayList<SerializedContent>();
        caseFileContent.put(CASE_DATA_KEY, caseDataContent);
        for (Map.Entry<String, Object> dataEntry : caseFile.getData().entrySet()) {
            byte[] content = null;
            String marshallerName = null;
            logger.debug("About to find marshaller for {}", dataEntry.getValue());
            for (ObjectMarshallingStrategy marshaller : this.marshallersByName.values()) {
                if (!marshaller.accept(dataEntry.getValue())) continue;
                content = marshaller.marshal(context, os, dataEntry.getValue());
                marshallerName = marshaller.getClass().getName();
                logger.debug("Object {} marshalled by {}", dataEntry.getValue(), (Object)marshallerName);
                break;
            }
            SerializedContent serializedContent = new SerializedContent(marshallerName, dataEntry.getKey(), content);
            caseDataContent.add(serializedContent);
            logger.debug("Serialized content for object {} is {}", dataEntry.getValue(), (Object)serializedContent);
        }
        byte[] caseFileBytes = this.caseFileMarshaller.marshal(context, os, caseFileContent);
        logger.debug("Content of the case file instance after marshaller is of length {}", (Object)(caseFileBytes == null ? 0 : caseFileBytes.length));
        return caseFileBytes;
    }

    public Object unmarshal(ObjectMarshallingStrategy.Context context, ObjectInputStream is, byte[] object, ClassLoader classloader) throws IOException, ClassNotFoundException {
        logger.debug("About to read {} bytes to unmarshal CaseFileInstance", (Object)(object == null ? 0 : object.length));
        Map caseFileContent = (Map)this.caseFileMarshaller.unmarshal(context, is, object, classloader);
        CaseFileInstanceImpl caseFileInstance = new CaseFileInstanceImpl();
        caseFileInstance.setCaseId((String)caseFileContent.get(CASE_ID_KEY));
        caseFileInstance.setCaseStartDate((Date)caseFileContent.get(CASE_START_KEY));
        caseFileInstance.setCaseEndDate((Date)caseFileContent.get(CASE_END_KEY));
        caseFileInstance.setCaseReopenDate((Date)caseFileContent.get(CASE_REOPEN_KEY));
        caseFileInstance.setRolesAssignments((Map)caseFileContent.get(CASE_ROLE_ASSIGNMENTS_KEY));
        caseFileInstance.setComments((List)caseFileContent.get(CASE_COMMENTS_KEY));
        logger.debug("CaseFileInstance meta data unmarshalled properly into {}", (Object)caseFileInstance);
        List caseDataContent = (List)caseFileContent.get(CASE_DATA_KEY);
        logger.debug("About to read serialized content {}", (Object)caseDataContent);
        for (SerializedContent serializedContent : caseDataContent) {
            ObjectMarshallingStrategy marshaller = this.marshallersByName.get(serializedContent.getMarshaller());
            logger.debug("Marshaller for {} is of type {}", (Object)serializedContent, (Object)marshaller);
            Object value = marshaller.unmarshal(context, is, serializedContent.getContent(), classloader);
            caseFileInstance.add(serializedContent.getName(), value);
            logger.debug("Data unmarshalled into {} and put into case file under '{}' name", value, (Object)serializedContent.getName());
        }
        logger.debug("Unmarshal of CaseFileInstance completed - result {}", (Object)caseFileInstance);
        return caseFileInstance;
    }

    public ObjectMarshallingStrategy.Context createContext() {
        return this.caseFileMarshaller.createContext();
    }
}

