/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.casemgmt.api.model.AdHocFragment;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.CaseMilestone;
import org.jbpm.casemgmt.api.model.CaseRole;
import org.jbpm.casemgmt.api.model.CaseStage;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryContext;
import org.kie.scanner.MavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseRuntimeDataServiceImplTest
extends AbstractCaseServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(CaseRuntimeDataServiceImplTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    public static final String SORT_BY_CASE_DEFINITION_NAME = "CaseName";

    @Before
    public void prepare() {
        this.configureServices();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/EmptyCase.bpmn2");
        processes.add("cases/UserTaskCase.bpmn2");
        processes.add("cases/UserTaskCaseBoundary.bpmn2");
        processes.add("cases/UserTaskWithStageCase.bpmn2");
        processes.add("processes/DataVerificationProcess.bpmn2");
        processes.add("processes/UserTaskProcess.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        CaseRuntimeDataServiceImplTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testGetCaseDefinitions() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Collection cases = this.caseRuntimeDataService.getCases(new QueryContext());
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)4L, (long)cases.size());
        Map<String, CaseDefinition> mappedCases = this.mapCases(cases);
        Assert.assertTrue((boolean)mappedCases.containsKey("EmptyCase"));
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskCase"));
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskCaseBoundary"));
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskWithStageCase"));
        CaseDefinition caseDef = mappedCases.get("EmptyCase");
        Assert.assertNotNull((Object)caseDef);
        Assert.assertEquals((Object)"EmptyCase", (Object)caseDef.getId());
        Assert.assertEquals((Object)"New Case", (Object)caseDef.getName());
        Assert.assertEquals((Object)"", (Object)caseDef.getVersion());
        Assert.assertEquals((Object)"CASE", (Object)caseDef.getIdentifierPrefix());
        Assert.assertNotNull((Object)caseDef.getCaseMilestones());
        Assert.assertTrue((boolean)caseDef.getCaseMilestones().isEmpty());
        Assert.assertNotNull((Object)caseDef.getCaseStages());
        Assert.assertTrue((boolean)caseDef.getCaseStages().isEmpty());
        Assert.assertNotNull((Object)caseDef.getCaseRoles());
        Assert.assertTrue((boolean)caseDef.getCaseRoles().isEmpty());
        Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
        caseDef = mappedCases.get("UserTaskCase");
        Assert.assertNotNull((Object)caseDef);
        Assert.assertEquals((Object)"UserTaskCase", (Object)caseDef.getId());
        Assert.assertEquals((Object)"Simple Case with User Tasks", (Object)caseDef.getName());
        Assert.assertEquals((Object)"1.0", (Object)caseDef.getVersion());
        Assert.assertEquals((Object)"HR", (Object)caseDef.getIdentifierPrefix());
        Assert.assertNotNull((Object)caseDef.getCaseMilestones());
        Assert.assertEquals((long)2L, (long)caseDef.getCaseMilestones().size());
        Map<String, CaseMilestone> mappedMilestones = this.mapMilestones(caseDef.getCaseMilestones());
        Assert.assertTrue((boolean)mappedMilestones.containsKey("Milestone1"));
        Assert.assertTrue((boolean)mappedMilestones.containsKey("Milestone2"));
        CaseMilestone milestone = mappedMilestones.get("Milestone1");
        Assert.assertEquals((Object)"_SomeID4", (Object)milestone.getId());
        Assert.assertEquals((Object)"Milestone1", (Object)milestone.getName());
        Assert.assertEquals((Object)"", (Object)milestone.getAchievementCondition());
        Assert.assertEquals((Object)false, (Object)milestone.isMandatory());
        milestone = mappedMilestones.get("Milestone2");
        Assert.assertEquals((Object)"_5", (Object)milestone.getId());
        Assert.assertEquals((Object)"Milestone2", (Object)milestone.getName());
        Assert.assertEquals((Object)"org.kie.api.runtime.process.CaseData(data.get(\"dataComplete\") == true)", (Object)milestone.getAchievementCondition());
        Assert.assertEquals((Object)false, (Object)milestone.isMandatory());
        Assert.assertNotNull((Object)caseDef.getCaseStages());
        Assert.assertEquals((long)0L, (long)caseDef.getCaseStages().size());
        Assert.assertNotNull((Object)caseDef.getCaseRoles());
        Assert.assertEquals((long)3L, (long)caseDef.getCaseRoles().size());
        Map<String, CaseRole> mappedRoles = this.mapRoles(caseDef.getCaseRoles());
        Assert.assertTrue((boolean)mappedRoles.containsKey("owner"));
        Assert.assertTrue((boolean)mappedRoles.containsKey("contact"));
        Assert.assertTrue((boolean)mappedRoles.containsKey("participant"));
        Assert.assertEquals((long)1L, (long)mappedRoles.get("owner").getCardinality().intValue());
        Assert.assertEquals((long)2L, (long)mappedRoles.get("contact").getCardinality().intValue());
        Assert.assertEquals((long)-1L, (long)mappedRoles.get("participant").getCardinality().intValue());
        caseDef = mappedCases.get("UserTaskWithStageCase");
        Assert.assertNotNull((Object)caseDef);
        Assert.assertEquals((Object)"UserTaskWithStageCase", (Object)caseDef.getId());
        Assert.assertEquals((Object)"UserTaskWithStageCase", (Object)caseDef.getName());
        Assert.assertEquals((Object)"1.0", (Object)caseDef.getVersion());
        Assert.assertEquals((Object)"CASE", (Object)caseDef.getIdentifierPrefix());
        Assert.assertNotNull((Object)caseDef.getCaseMilestones());
        Assert.assertEquals((long)0L, (long)caseDef.getCaseMilestones().size());
        Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
        Assert.assertNotNull((Object)caseDef.getCaseStages());
        Assert.assertEquals((long)1L, (long)caseDef.getCaseStages().size());
        Map<String, CaseStage> mappedStages = this.mapStages(caseDef.getCaseStages());
        Assert.assertTrue((boolean)mappedStages.containsKey("Collect input"));
        CaseStage caseStage = mappedStages.get("Collect input");
        Assert.assertNotNull((Object)caseStage);
        Assert.assertEquals((Object)"Collect input", (Object)caseStage.getName());
        Assert.assertEquals((long)2L, (long)caseStage.getAdHocFragments().size());
        Map<String, AdHocFragment> mappedFragments = this.mapAdHocFragments(caseStage.getAdHocFragments());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Missing data"));
        Assert.assertEquals((Object)"HumanTaskNode", (Object)mappedFragments.get("Missing data").getType());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Verification of data"));
        Assert.assertEquals((Object)"SubProcessNode", (Object)mappedFragments.get("Verification of data").getType());
        Assert.assertNotNull((Object)caseDef.getCaseRoles());
        Assert.assertEquals((long)3L, (long)caseDef.getCaseRoles().size());
        mappedRoles = this.mapRoles(caseDef.getCaseRoles());
        Assert.assertTrue((boolean)mappedRoles.containsKey("owner"));
        Assert.assertTrue((boolean)mappedRoles.containsKey("contact"));
        Assert.assertTrue((boolean)mappedRoles.containsKey("participant"));
        Assert.assertEquals((long)1L, (long)mappedRoles.get("owner").getCardinality().intValue());
        Assert.assertEquals((long)2L, (long)mappedRoles.get("contact").getCardinality().intValue());
        Assert.assertEquals((long)-1L, (long)mappedRoles.get("participant").getCardinality().intValue());
    }

    @Test
    public void testGetCaseDefinitionsSorted() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Collection cases = this.caseRuntimeDataService.getCases(new QueryContext(Integer.valueOf(0), Integer.valueOf(1), SORT_BY_CASE_DEFINITION_NAME, true));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Assert.assertEquals((Object)"EmptyCase", (Object)((CaseDefinition)cases.iterator().next()).getId());
        cases = this.caseRuntimeDataService.getCases(new QueryContext(Integer.valueOf(1), Integer.valueOf(1), SORT_BY_CASE_DEFINITION_NAME, true));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Assert.assertEquals((Object)"UserTaskCase", (Object)((CaseDefinition)cases.iterator().next()).getId());
        cases = this.caseRuntimeDataService.getCases(new QueryContext(Integer.valueOf(2), Integer.valueOf(1), SORT_BY_CASE_DEFINITION_NAME, true));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Assert.assertEquals((Object)"UserTaskCaseBoundary", (Object)((CaseDefinition)cases.iterator().next()).getId());
        cases = this.caseRuntimeDataService.getCases(new QueryContext(SORT_BY_CASE_DEFINITION_NAME, false));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)4L, (long)cases.size());
        ArrayList sortedCases = new ArrayList(cases);
        Assert.assertEquals((Object)"UserTaskWithStageCase", (Object)((CaseDefinition)sortedCases.get(0)).getId());
        Assert.assertEquals((Object)"UserTaskCaseBoundary", (Object)((CaseDefinition)sortedCases.get(1)).getId());
        Assert.assertEquals((Object)"UserTaskCase", (Object)((CaseDefinition)sortedCases.get(2)).getId());
        Assert.assertEquals((Object)"EmptyCase", (Object)((CaseDefinition)sortedCases.get(3)).getId());
    }

    @Test
    public void testGetCaseDefinitionsByDeploymentId() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Collection cases = this.caseRuntimeDataService.getCasesByDeployment(deploymentUnit.getIdentifier(), new QueryContext());
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)4L, (long)cases.size());
        Map<String, CaseDefinition> mappedCases = this.mapCases(cases);
        Assert.assertTrue((boolean)mappedCases.containsKey("EmptyCase"));
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskCase"));
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskCaseBoundary"));
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskWithStageCase"));
        cases = this.caseRuntimeDataService.getCasesByDeployment("not-existing", new QueryContext());
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)0L, (long)cases.size());
    }

    @Test
    public void testGetCaseDefinitionsByDeploymentIdSorted() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Collection cases = this.caseRuntimeDataService.getCasesByDeployment(deploymentUnit.getIdentifier(), new QueryContext(Integer.valueOf(0), Integer.valueOf(1), SORT_BY_CASE_DEFINITION_NAME, true));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Assert.assertEquals((Object)"EmptyCase", (Object)((CaseDefinition)cases.iterator().next()).getId());
        cases = this.caseRuntimeDataService.getCasesByDeployment(deploymentUnit.getIdentifier(), new QueryContext(Integer.valueOf(1), Integer.valueOf(1), SORT_BY_CASE_DEFINITION_NAME, true));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Assert.assertEquals((Object)"UserTaskCase", (Object)((CaseDefinition)cases.iterator().next()).getId());
        cases = this.caseRuntimeDataService.getCasesByDeployment(deploymentUnit.getIdentifier(), new QueryContext(Integer.valueOf(2), Integer.valueOf(1), SORT_BY_CASE_DEFINITION_NAME, true));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Assert.assertEquals((Object)"UserTaskCaseBoundary", (Object)((CaseDefinition)cases.iterator().next()).getId());
        cases = this.caseRuntimeDataService.getCasesByDeployment(deploymentUnit.getIdentifier(), new QueryContext(SORT_BY_CASE_DEFINITION_NAME, false));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)4L, (long)cases.size());
        ArrayList sortedCases = new ArrayList(cases);
        Assert.assertEquals((Object)"UserTaskWithStageCase", (Object)((CaseDefinition)sortedCases.get(0)).getId());
        Assert.assertEquals((Object)"UserTaskCaseBoundary", (Object)((CaseDefinition)sortedCases.get(1)).getId());
        Assert.assertEquals((Object)"UserTaskCase", (Object)((CaseDefinition)sortedCases.get(2)).getId());
        Assert.assertEquals((Object)"EmptyCase", (Object)((CaseDefinition)sortedCases.get(3)).getId());
    }

    @Test
    public void testGetCaseDefinitionsByFilter() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Collection cases = this.caseRuntimeDataService.getCases("empty", new QueryContext());
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Map<String, CaseDefinition> mappedCases = this.mapCases(cases);
        Assert.assertTrue((boolean)mappedCases.containsKey("EmptyCase"));
        cases = this.caseRuntimeDataService.getCases("User", new QueryContext());
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)3L, (long)cases.size());
        mappedCases = this.mapCases(cases);
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskCase"));
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskCaseBoundary"));
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskWithStageCase"));
        cases = this.caseRuntimeDataService.getCases("nomatch", new QueryContext());
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)0L, (long)cases.size());
    }

    @Test
    public void testGetCaseDefinitionsByFilterSorted() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Collection cases = this.caseRuntimeDataService.getCases("User", new QueryContext(Integer.valueOf(0), Integer.valueOf(1), SORT_BY_CASE_DEFINITION_NAME, true));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Assert.assertEquals((Object)"UserTaskCase", (Object)((CaseDefinition)cases.iterator().next()).getId());
        cases = this.caseRuntimeDataService.getCases("User", new QueryContext(Integer.valueOf(1), Integer.valueOf(1), SORT_BY_CASE_DEFINITION_NAME, true));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Assert.assertEquals((Object)"UserTaskCaseBoundary", (Object)((CaseDefinition)cases.iterator().next()).getId());
        cases = this.caseRuntimeDataService.getCases("User", new QueryContext(SORT_BY_CASE_DEFINITION_NAME, false));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)3L, (long)cases.size());
        ArrayList sortedCases = new ArrayList(cases);
        Assert.assertEquals((Object)"UserTaskWithStageCase", (Object)((CaseDefinition)sortedCases.get(0)).getId());
        Assert.assertEquals((Object)"UserTaskCaseBoundary", (Object)((CaseDefinition)sortedCases.get(1)).getId());
        Assert.assertEquals((Object)"UserTaskCase", (Object)((CaseDefinition)sortedCases.get(2)).getId());
    }

    @Test
    public void testGetCaseDefinitionById() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        CaseDefinition caseDef = this.caseRuntimeDataService.getCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase");
        Assert.assertNotNull((Object)caseDef);
        Assert.assertEquals((Object)"UserTaskWithStageCase", (Object)caseDef.getId());
        Assert.assertEquals((Object)"UserTaskWithStageCase", (Object)caseDef.getName());
        Assert.assertEquals((Object)"1.0", (Object)caseDef.getVersion());
        Assert.assertEquals((Object)"CASE", (Object)caseDef.getIdentifierPrefix());
        Assert.assertNotNull((Object)caseDef.getCaseMilestones());
        Assert.assertEquals((long)0L, (long)caseDef.getCaseMilestones().size());
        Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
        Assert.assertNotNull((Object)caseDef.getCaseStages());
        Assert.assertEquals((long)1L, (long)caseDef.getCaseStages().size());
        Map<String, CaseStage> mappedStages = this.mapStages(caseDef.getCaseStages());
        Assert.assertTrue((boolean)mappedStages.containsKey("Collect input"));
        CaseStage caseStage = mappedStages.get("Collect input");
        Assert.assertNotNull((Object)caseStage);
        Assert.assertEquals((Object)"Collect input", (Object)caseStage.getName());
        Assert.assertEquals((long)2L, (long)caseStage.getAdHocFragments().size());
        Map<String, AdHocFragment> mappedFragments = this.mapAdHocFragments(caseStage.getAdHocFragments());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Missing data"));
        Assert.assertEquals((Object)"HumanTaskNode", (Object)mappedFragments.get("Missing data").getType());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Verification of data"));
        Assert.assertEquals((Object)"SubProcessNode", (Object)mappedFragments.get("Verification of data").getType());
        Assert.assertNotNull((Object)caseDef.getCaseRoles());
        Assert.assertEquals((long)3L, (long)caseDef.getCaseRoles().size());
        Map<String, CaseRole> mappedRoles = this.mapRoles(caseDef.getCaseRoles());
        Assert.assertTrue((boolean)mappedRoles.containsKey("owner"));
        Assert.assertTrue((boolean)mappedRoles.containsKey("contact"));
        Assert.assertTrue((boolean)mappedRoles.containsKey("participant"));
        Assert.assertEquals((long)1L, (long)mappedRoles.get("owner").getCardinality().intValue());
        Assert.assertEquals((long)2L, (long)mappedRoles.get("contact").getCardinality().intValue());
        Assert.assertEquals((long)-1L, (long)mappedRoles.get("participant").getCardinality().intValue());
    }

    @Test
    public void testGetCaseDefinitionByIdWithBoundaryEvent() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        CaseDefinition caseDef = this.caseRuntimeDataService.getCase(deploymentUnit.getIdentifier(), "UserTaskCaseBoundary");
        Assert.assertNotNull((Object)caseDef);
        Assert.assertEquals((Object)"UserTaskCaseBoundary", (Object)caseDef.getId());
        Assert.assertEquals((Object)"Simple Case with User Tasks and Boundary", (Object)caseDef.getName());
        Assert.assertEquals((Object)"1.0", (Object)caseDef.getVersion());
        Assert.assertEquals((Object)"HR", (Object)caseDef.getIdentifierPrefix());
        Assert.assertEquals((long)2L, (long)caseDef.getCaseMilestones().size());
        Assert.assertEquals((long)0L, (long)caseDef.getCaseStages().size());
        Assert.assertEquals((long)3L, (long)caseDef.getAdHocFragments().size());
        Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
        Map<String, CaseMilestone> mappedMilestones = this.mapMilestones(caseDef.getCaseMilestones());
        Assert.assertTrue((boolean)mappedMilestones.containsKey("Milestone1"));
        Assert.assertTrue((boolean)mappedMilestones.containsKey("Milestone2"));
        Map<String, AdHocFragment> mappedFragments = this.mapAdHocFragments(caseDef.getAdHocFragments());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Hello2"));
        Assert.assertEquals((Object)"HumanTaskNode", (Object)mappedFragments.get("Hello2").getType());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Milestone1"));
        Assert.assertEquals((Object)"MilestoneNode", (Object)mappedFragments.get("Milestone1").getType());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Milestone2"));
        Assert.assertEquals((Object)"MilestoneNode", (Object)mappedFragments.get("Milestone2").getType());
        Assert.assertNotNull((Object)caseDef.getCaseRoles());
        Assert.assertEquals((long)3L, (long)caseDef.getCaseRoles().size());
        Map<String, CaseRole> mappedRoles = this.mapRoles(caseDef.getCaseRoles());
        Assert.assertTrue((boolean)mappedRoles.containsKey("owner"));
        Assert.assertTrue((boolean)mappedRoles.containsKey("contact"));
        Assert.assertTrue((boolean)mappedRoles.containsKey("participant"));
        Assert.assertEquals((long)1L, (long)mappedRoles.get("owner").getCardinality().intValue());
        Assert.assertEquals((long)2L, (long)mappedRoles.get("contact").getCardinality().intValue());
        Assert.assertEquals((long)-1L, (long)mappedRoles.get("participant").getCardinality().intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseWithCaseFile() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertNotNull((Object)cInstance.getCaseFile());
            Assert.assertEquals((Object)"my first case", (Object)cInstance.getCaseFile().getData("name"));
            Collection instances = this.caseRuntimeDataService.getCaseInstances(new QueryContext());
            Assert.assertNotNull((Object)instances);
            Assert.assertEquals((long)1L, (long)instances.size());
            CaseInstance instance = (CaseInstance)instances.iterator().next();
            Assert.assertNotNull((Object)instance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)instance.getCaseId());
            Assert.assertEquals((Object)"EmptyCase", (Object)instance.getCaseDefinitionId());
            Assert.assertEquals((Object)"my first case", (Object)instance.getCaseDescription());
            Assert.assertEquals((Object)"testUser", (Object)instance.getOwner());
            Assert.assertEquals((long)1L, (long)instance.getStatus().intValue());
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)instance.getDeploymentId());
            Assert.assertNotNull((Object)instance.getStartedAt());
            HashMap parameters = new HashMap();
            this.caseService.addDynamicTask("CASE-0000000001", this.caseService.newHumanTaskSpec("First task", "test", "john", null, parameters));
            Collection activeNodes = this.caseRuntimeDataService.getActiveNodesForCase("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)activeNodes);
            Assert.assertEquals((long)1L, (long)activeNodes.size());
            NodeInstanceDesc activeNode = (NodeInstanceDesc)activeNodes.iterator().next();
            Assert.assertNotNull((Object)activeNodes);
            Assert.assertEquals((Object)"[Dynamic] First task", (Object)activeNode.getName());
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            TaskSummary task = (TaskSummary)tasks.get(0);
            Assert.assertEquals((Object)"First task", (Object)task.getName());
            Assert.assertEquals((Object)"test", (Object)task.getDescription());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserTasksInCase() {
        block9: {
            String caseId2;
            block8: {
                Assert.assertNotNull((Object)this.deploymentService);
                KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
                this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
                this.units.add((DeploymentUnit)deploymentUnit);
                HashMap data = new HashMap();
                CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "UserTaskCase", data);
                caseId2 = null;
                String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
                Assert.assertNotNull((Object)caseId);
                Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
                try {
                    CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
                    Assert.assertNotNull((Object)cInstance);
                    Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
                    Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
                    List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)0L, (long)tasks.size());
                    HashMap<String, String> taskInput = new HashMap<String, String>();
                    taskInput.put("ActorId", "john");
                    this.caseService.triggerAdHocFragment(caseId, "Missing data", taskInput);
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    TaskSummary task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    caseId2 = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
                    Assert.assertNotNull((Object)caseId2);
                    Assert.assertEquals((Object)"CASE-0000000002", (Object)caseId2);
                    this.caseService.triggerAdHocFragment(caseId2, "Missing data", taskInput);
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId2, "john", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    if (caseId == null) break block8;
                }
                catch (Exception e) {
                    logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
                    Assert.fail((String)("Unexpected exception " + e.getMessage()));
                    break block9;
                }
                finally {
                    if (caseId != null) {
                        this.caseService.cancelCase(caseId);
                    }
                    if (caseId2 != null) {
                        this.caseService.cancelCase(caseId2);
                    }
                }
                this.caseService.cancelCase(caseId);
            }
            if (caseId2 != null) {
                this.caseService.cancelCase(caseId2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserTasksInCaseWithSubprocess() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "UserTaskCase", data);
        String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)0L, (long)tasks.size());
            HashMap<String, String> taskInput = new HashMap<String, String>();
            taskInput.put("ActorId", "john");
            this.caseService.triggerAdHocFragment(caseId, "Missing data", taskInput);
            tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            TaskSummary task = (TaskSummary)tasks.get(0);
            Assert.assertEquals((Object)"Missing data", (Object)task.getName());
            this.caseService.addDynamicSubprocess(caseId, "UserTask", null);
            tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)2L, (long)tasks.size());
            task = (TaskSummary)tasks.get(0);
            Assert.assertEquals((Object)"Hello", (Object)task.getName());
            task = (TaskSummary)tasks.get(1);
            Assert.assertEquals((Object)"Missing data", (Object)task.getName());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserTasksInCaseAdBusinessAdmin() {
        block9: {
            String caseId2;
            block8: {
                Assert.assertNotNull((Object)this.deploymentService);
                KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
                this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
                this.units.add((DeploymentUnit)deploymentUnit);
                HashMap data = new HashMap();
                CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "UserTaskCase", data);
                caseId2 = null;
                String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
                Assert.assertNotNull((Object)caseId);
                Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
                try {
                    CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
                    Assert.assertNotNull((Object)cInstance);
                    Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
                    Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
                    List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsBusinessAdmin(caseId, "Administrator", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)0L, (long)tasks.size());
                    HashMap<String, String> taskInput = new HashMap<String, String>();
                    taskInput.put("ActorId", "john");
                    this.caseService.triggerAdHocFragment(caseId, "Missing data", taskInput);
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsBusinessAdmin(caseId, "Administrator", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    TaskSummary task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    caseId2 = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
                    Assert.assertNotNull((Object)caseId2);
                    Assert.assertEquals((Object)"CASE-0000000002", (Object)caseId2);
                    this.caseService.triggerAdHocFragment(caseId2, "Missing data", taskInput);
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsBusinessAdmin(caseId2, "Administrator", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsBusinessAdmin(caseId, "Administrator", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    if (caseId == null) break block8;
                }
                catch (Exception e) {
                    logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
                    Assert.fail((String)("Unexpected exception " + e.getMessage()));
                    break block9;
                }
                finally {
                    if (caseId != null) {
                        this.caseService.cancelCase(caseId);
                    }
                    if (caseId2 != null) {
                        this.caseService.cancelCase(caseId2);
                    }
                }
                this.caseService.cancelCase(caseId);
            }
            if (caseId2 != null) {
                this.caseService.cancelCase(caseId2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserTasksInCaseAdStakeholder() {
        block9: {
            String caseId2;
            block8: {
                Assert.assertNotNull((Object)this.deploymentService);
                KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
                this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
                this.units.add((DeploymentUnit)deploymentUnit);
                HashMap data = new HashMap();
                CaseFileInstance caseFile = this.caseService.newCaseFileInstance(deploymentUnit.getIdentifier(), "UserTaskCase", data);
                caseId2 = null;
                String caseId = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
                Assert.assertNotNull((Object)caseId);
                Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
                try {
                    CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
                    Assert.assertNotNull((Object)cInstance);
                    Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
                    Assert.assertEquals((Object)deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
                    List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsStakeholder(caseId, "john", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)0L, (long)tasks.size());
                    HashMap<String, String> taskInput = new HashMap<String, String>();
                    taskInput.put("ActorId", "mary");
                    taskInput.put("TaskStakeholderId", "john");
                    this.caseService.triggerAdHocFragment(caseId, "Missing data", taskInput);
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsStakeholder(caseId, "john", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    TaskSummary task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    caseId2 = this.caseService.startCase(deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
                    Assert.assertNotNull((Object)caseId2);
                    Assert.assertEquals((Object)"CASE-0000000002", (Object)caseId2);
                    this.caseService.triggerAdHocFragment(caseId2, "Missing data", taskInput);
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsStakeholder(caseId2, "john", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsStakeholder(caseId, "john", null, new QueryContext());
                    Assert.assertNotNull((Object)tasks);
                    Assert.assertEquals((long)1L, (long)tasks.size());
                    task = (TaskSummary)tasks.get(0);
                    Assert.assertEquals((Object)"Missing data", (Object)task.getName());
                    if (caseId == null) break block8;
                }
                catch (Exception e) {
                    logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
                    Assert.fail((String)("Unexpected exception " + e.getMessage()));
                    break block9;
                }
                finally {
                    if (caseId != null) {
                        this.caseService.cancelCase(caseId);
                    }
                    if (caseId2 != null) {
                        this.caseService.cancelCase(caseId2);
                    }
                }
                this.caseService.cancelCase(caseId);
            }
            if (caseId2 != null) {
                this.caseService.cancelCase(caseId2);
            }
        }
    }
}

