/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.util;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import org.dashbuilder.DataSetCore;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.casemgmt.api.CaseRuntimeDataService;
import org.jbpm.casemgmt.api.CaseService;
import org.jbpm.casemgmt.api.auth.AuthorizationManager;
import org.jbpm.casemgmt.api.generator.CaseIdGenerator;
import org.jbpm.casemgmt.api.model.AdHocFragment;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.CaseMilestone;
import org.jbpm.casemgmt.api.model.CaseRole;
import org.jbpm.casemgmt.api.model.CaseStage;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.jbpm.casemgmt.impl.AuthorizationManagerImpl;
import org.jbpm.casemgmt.impl.CaseRuntimeDataServiceImpl;
import org.jbpm.casemgmt.impl.CaseServiceImpl;
import org.jbpm.casemgmt.impl.event.CaseConfigurationDeploymentListener;
import org.jbpm.casemgmt.impl.generator.TableCaseIdGenerator;
import org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory;
import org.jbpm.casemgmt.impl.util.TestIdentityProvider;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.kie.services.impl.FormManagerServiceImpl;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.ProcessServiceImpl;
import org.jbpm.kie.services.impl.RuntimeDataServiceImpl;
import org.jbpm.kie.services.impl.UserTaskServiceImpl;
import org.jbpm.kie.services.impl.bpmn2.BPMN2DataServiceImpl;
import org.jbpm.kie.services.impl.query.QueryServiceImpl;
import org.jbpm.kie.services.impl.security.DeploymentRolesManager;
import org.jbpm.runtime.manager.impl.RuntimeManagerFactoryImpl;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.UserTaskDefinition;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.audit.TaskAuditServiceFactory;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.junit.Assert;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.conf.DeploymentDescriptorBuilder;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCaseServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCaseServicesBaseTest.class);
    protected static final String ARTIFACT_ID = "case-module";
    protected static final String GROUP_ID = "org.jbpm.cases";
    protected static final String VERSION = "1.0.0-SNAPSHOT";
    protected PoolingDataSource ds;
    protected EntityManagerFactory emf;
    protected DeploymentService deploymentService;
    protected DefinitionService bpmn2Service;
    protected RuntimeDataService runtimeDataService;
    protected ProcessService processService;
    protected UserTaskService userTaskService;
    protected QueryService queryService;
    protected CaseRuntimeDataService caseRuntimeDataService;
    protected CaseService caseService;
    protected TestIdentityProvider identityProvider;
    protected CaseIdGenerator caseIdGenerator;
    protected AuthorizationManager authorizationManager;
    protected static final String EMPTY_CASE_P_ID = "EmptyCase";
    protected static final String USER_TASK_STAGE_CASE_P_ID = "UserTaskWithStageCase";
    protected static final String USER_TASK_CASE_P_ID = "UserTaskCase";
    protected static final String USER_TASK_STAGE_AUTO_START_CASE_P_ID = "UserTaskWithStageCaseAutoStart";
    protected static final String USER_TASK_STAGE_ADHOC_CASE_P_ID = "UserStageAdhocCase";
    protected static final String NO_START_NODE_CASE_P_ID = "NoStartNodeAdhocCase";
    protected static final String COND_CASE_P_ID = "CaseFileConditionalEvent";
    protected static final String TWO_STAGES_CASE_P_ID = "CaseWithTwoStages";
    protected static final String TWO_STAGES_CONDITIONS_CASE_P_ID = "CaseWithTwoStagesConditions";
    protected static final String SUBPROCESS_P_ID = "DataVerification";
    protected static final String FIRST_CASE_ID = "CASE-0000000001";
    protected static final String HR_CASE_ID = "HR-0000000001";

    protected void close() {
        DataSetCore.set(null);
        if (this.emf != null) {
            this.emf.close();
        }
        EntityManagerFactoryManager.get().clear();
        this.closeDataSource();
    }

    protected void configureServices() {
        this.buildDatasource();
        this.emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.domain");
        this.identityProvider = new TestIdentityProvider();
        this.authorizationManager = new AuthorizationManagerImpl((IdentityProvider)this.identityProvider, new TransactionalCommandService(this.emf));
        this.bpmn2Service = new BPMN2DataServiceImpl();
        DeploymentRolesManager deploymentRolesManager = new DeploymentRolesManager();
        this.queryService = new QueryServiceImpl();
        ((QueryServiceImpl)this.queryService).setIdentityProvider((IdentityProvider)this.identityProvider);
        ((QueryServiceImpl)this.queryService).setCommandService(new TransactionalCommandService(this.emf));
        ((QueryServiceImpl)this.queryService).init();
        this.deploymentService = new KModuleDeploymentService();
        ((KModuleDeploymentService)this.deploymentService).setBpmn2Service(this.bpmn2Service);
        ((KModuleDeploymentService)this.deploymentService).setEmf(this.emf);
        ((KModuleDeploymentService)this.deploymentService).setIdentityProvider((IdentityProvider)this.identityProvider);
        ((KModuleDeploymentService)this.deploymentService).setManagerFactory((RuntimeManagerFactory)new RuntimeManagerFactoryImpl());
        ((KModuleDeploymentService)this.deploymentService).setFormManagerService((FormManagerService)new FormManagerServiceImpl());
        TaskService taskService = HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(this.emf).getTaskService();
        this.runtimeDataService = new RuntimeDataServiceImpl();
        ((RuntimeDataServiceImpl)this.runtimeDataService).setCommandService(new TransactionalCommandService(this.emf));
        ((RuntimeDataServiceImpl)this.runtimeDataService).setIdentityProvider((IdentityProvider)this.identityProvider);
        ((RuntimeDataServiceImpl)this.runtimeDataService).setTaskService(taskService);
        ((RuntimeDataServiceImpl)this.runtimeDataService).setDeploymentRolesManager(deploymentRolesManager);
        ((RuntimeDataServiceImpl)this.runtimeDataService).setTaskAuditService(TaskAuditServiceFactory.newTaskAuditServiceConfigurator().setTaskService(taskService).getTaskAuditService());
        ((KModuleDeploymentService)this.deploymentService).setRuntimeDataService(this.runtimeDataService);
        this.processService = new ProcessServiceImpl();
        ((ProcessServiceImpl)this.processService).setDataService(this.runtimeDataService);
        ((ProcessServiceImpl)this.processService).setDeploymentService(this.deploymentService);
        this.userTaskService = new UserTaskServiceImpl();
        ((UserTaskServiceImpl)this.userTaskService).setDataService(this.runtimeDataService);
        ((UserTaskServiceImpl)this.userTaskService).setDeploymentService(this.deploymentService);
        this.caseIdGenerator = new TableCaseIdGenerator(new TransactionalCommandService(this.emf));
        this.caseRuntimeDataService = new CaseRuntimeDataServiceImpl();
        ((CaseRuntimeDataServiceImpl)this.caseRuntimeDataService).setCaseIdGenerator(this.caseIdGenerator);
        ((CaseRuntimeDataServiceImpl)this.caseRuntimeDataService).setRuntimeDataService(this.runtimeDataService);
        ((CaseRuntimeDataServiceImpl)this.caseRuntimeDataService).setCommandService(new TransactionalCommandService(this.emf));
        ((CaseRuntimeDataServiceImpl)this.caseRuntimeDataService).setIdentityProvider((IdentityProvider)this.identityProvider);
        ((CaseRuntimeDataServiceImpl)this.caseRuntimeDataService).setDeploymentRolesManager(deploymentRolesManager);
        this.caseService = new CaseServiceImpl();
        ((CaseServiceImpl)this.caseService).setCaseIdGenerator(this.caseIdGenerator);
        ((CaseServiceImpl)this.caseService).setCaseRuntimeDataService(this.caseRuntimeDataService);
        ((CaseServiceImpl)this.caseService).setProcessService(this.processService);
        ((CaseServiceImpl)this.caseService).setDeploymentService(this.deploymentService);
        ((CaseServiceImpl)this.caseService).setRuntimeDataService(this.runtimeDataService);
        ((CaseServiceImpl)this.caseService).setCommandService(new TransactionalCommandService(this.emf));
        ((CaseServiceImpl)this.caseService).setAuthorizationManager(this.authorizationManager);
        ((CaseServiceImpl)this.caseService).setIdentityProvider((IdentityProvider)this.identityProvider);
        CaseConfigurationDeploymentListener configurationListener = new CaseConfigurationDeploymentListener();
        ((KModuleDeploymentService)this.deploymentService).addListener((DeploymentEventListener)((RuntimeDataServiceImpl)this.runtimeDataService));
        ((KModuleDeploymentService)this.deploymentService).addListener((DeploymentEventListener)((BPMN2DataServiceImpl)this.bpmn2Service));
        ((KModuleDeploymentService)this.deploymentService).addListener((DeploymentEventListener)((QueryServiceImpl)this.queryService));
        ((KModuleDeploymentService)this.deploymentService).addListener((DeploymentEventListener)((CaseRuntimeDataServiceImpl)this.caseRuntimeDataService));
        ((KModuleDeploymentService)this.deploymentService).addListener((DeploymentEventListener)configurationListener);
    }

    protected String getPom(ReleaseId releaseId, ReleaseId ... dependencies) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n  <version>" + releaseId.getVersion() + "</version>\n\n";
        if (dependencies != null && dependencies.length > 0) {
            pom = pom + "<dependencies>\n";
            for (ReleaseId dep : dependencies) {
                pom = pom + "<dependency>\n";
                pom = pom + "  <groupId>" + dep.getGroupId() + "</groupId>\n";
                pom = pom + "  <artifactId>" + dep.getArtifactId() + "</artifactId>\n";
                pom = pom + "  <version>" + dep.getVersion() + "</version>\n";
                pom = pom + "</dependency>\n";
            }
            pom = pom + "</dependencies>\n";
        }
        pom = pom + "</project>";
        return pom;
    }

    protected InternalKieModule createKieJar(KieServices ks, ReleaseId releaseId, List<String> resources) {
        return this.createKieJar(ks, releaseId, resources, null);
    }

    protected InternalKieModule createKieJar(KieServices ks, ReleaseId releaseId, List<String> resources, Map<String, String> extraResources) {
        KieBuilder kieBuilder;
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks);
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        DeploymentDescriptorImpl customDescriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        DeploymentDescriptorBuilder ddBuilder = customDescriptor.getBuilder().runtimeStrategy(RuntimeStrategy.PER_CASE).addMarshalingStrategy(new ObjectModel("mvel", CaseMarshallerFactory.builder().withDoc().toString(), new Object[0])).addEventListener(new ObjectModel("mvel", "new org.jbpm.casemgmt.impl.util.TrackingCaseEventListener()", new Object[0]));
        for (ObjectModel objectModel : this.getProcessListeners()) {
            ddBuilder.addEventListener(objectModel);
        }
        if (extraResources == null) {
            extraResources = new HashMap<String, String>();
        }
        extraResources.put("src/main/resources/META-INF/kie-deployment-descriptor.xml", customDescriptor.toXml());
        for (String string : resources) {
            kfs.write("src/main/resources/KBase-test/" + string, ResourceFactory.newClassPathResource((String)string));
        }
        if (extraResources != null) {
            for (Map.Entry entry : extraResources.entrySet()) {
                kfs.write((String)entry.getKey(), ResourceFactory.newByteArrayResource((byte[])((String)entry.getValue()).getBytes()));
            }
        }
        if (!(kieBuilder = ks.newKieBuilder(kfs)).buildAll().getResults().getMessages().isEmpty()) {
            for (Message message : kieBuilder.buildAll().getResults().getMessages()) {
                logger.error("Error Message: ({}) {}", (Object)message.getPath(), (Object)message.getText());
            }
            throw new RuntimeException("There are errors builing the package, please check your knowledge assets!");
        }
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    protected KieFileSystem createKieFileSystemWithKProject(KieServices ks) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("KBase-test").setDefault(true).addPackage("*").setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        KieSessionModel ksessionModel = kieBaseModel1.newKieSessionModel("ksession-test");
        ksessionModel.setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime"));
        ksessionModel.newWorkItemHandlerModel("Log", "new org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler()");
        ksessionModel.newWorkItemHandlerModel("Service Task", "new org.jbpm.bpmn2.handler.ServiceTaskHandler(\"name\")");
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        return kfs;
    }

    protected void buildDatasource() {
        this.ds = new PoolingDataSource();
        this.ds.setUniqueName("jdbc/testDS1");
        this.ds.setClassName("org.h2.jdbcx.JdbcDataSource");
        this.ds.setMaxPoolSize(3);
        this.ds.setAllowLocalTransactions(true);
        this.ds.getDriverProperties().put("user", "sa");
        this.ds.getDriverProperties().put("password", "sasa");
        this.ds.getDriverProperties().put("URL", "jdbc:h2:mem:mydb");
        this.ds.init();
    }

    protected void closeDataSource() {
        if (this.ds != null) {
            this.ds.close();
        }
    }

    public static void cleanupSingletonSessionId() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (tempDir.exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = tempDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("-jbpmSessionId.ser");
                }
            })) {
                logger.debug("Temp dir to be removed {} file {}", (Object)tempDir, (Object)file);
                new File(tempDir, file).delete();
            }
        }
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setBpmn2Service(DefinitionService bpmn2Service) {
        this.bpmn2Service = bpmn2Service;
    }

    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        this.runtimeDataService = runtimeDataService;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setUserTaskService(UserTaskService userTaskService) {
        this.userTaskService = userTaskService;
    }

    public void setQueryService(QueryService queryService) {
        this.queryService = queryService;
    }

    public void setIdentityProvider(TestIdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void setCaseRuntimeDataService(CaseRuntimeDataService caseRuntimeDataService) {
        this.caseRuntimeDataService = caseRuntimeDataService;
    }

    protected static void waitForTheOtherThreads(CyclicBarrier barrier) {
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Thread 1 was interrupted while waiting for the other threads!");
        }
        catch (BrokenBarrierException e) {
            Assert.fail((String)"Thread 1's barrier was broken while waiting for the other threads!");
        }
    }

    protected void deleteFolder(String pathStr) {
        File[] directories;
        File path = new File(pathStr);
        if (path.exists() && (directories = path.listFiles()) != null) {
            for (File file : directories) {
                if (file.isDirectory()) {
                    this.deleteFolder(file.getAbsolutePath());
                }
                file.delete();
            }
        }
    }

    protected List<ObjectModel> getProcessListeners() {
        return new ArrayList<ObjectModel>();
    }

    protected Map<String, CaseDefinition> mapCases(Collection<CaseDefinition> cases) {
        return cases.stream().collect(Collectors.toMap(CaseDefinition::getId, c -> c));
    }

    protected Map<String, CaseRole> mapRoles(Collection<CaseRole> caseRoles) {
        return caseRoles.stream().collect(Collectors.toMap(CaseRole::getName, c -> c));
    }

    protected Map<String, CaseMilestone> mapMilestones(Collection<CaseMilestone> caseMilestones) {
        return caseMilestones.stream().collect(Collectors.toMap(CaseMilestone::getName, c -> c));
    }

    protected Map<String, CaseStage> mapStages(Collection<CaseStage> caseStages) {
        return caseStages.stream().collect(Collectors.toMap(CaseStage::getName, c -> c));
    }

    protected Map<String, UserTaskDefinition> mapTasksDef(Collection<UserTaskDefinition> tasks) {
        return tasks.stream().collect(Collectors.toMap(UserTaskDefinition::getName, t -> t));
    }

    protected Map<String, AdHocFragment> mapAdHocFragments(Collection<AdHocFragment> adHocFragments) {
        return adHocFragments.stream().collect(Collectors.toMap(AdHocFragment::getName, t -> t));
    }

    protected Map<String, ProcessDefinition> mapProcesses(Collection<ProcessDefinition> processes) {
        return processes.stream().collect(Collectors.toMap(ProcessDefinition::getId, p -> p));
    }

    protected Map<String, NodeInstanceDesc> mapNodeInstances(Collection<NodeInstanceDesc> nodes) {
        return nodes.stream().collect(Collectors.toMap(NodeInstanceDesc::getName, n -> n));
    }

    protected void assertComment(CommentInstance comment, String author, String content) {
        Assert.assertNotNull((Object)comment);
        Assert.assertEquals((Object)author, (Object)comment.getAuthor());
        Assert.assertEquals((Object)content, (Object)comment.getComment());
    }

    protected void assertTask(TaskSummary task, String actor, String name, Status status) {
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)name, (Object)task.getName());
        Assert.assertEquals((Object)actor, (Object)task.getActualOwnerId());
        Assert.assertEquals((Object)status, (Object)task.getStatus());
    }

    protected void assertCaseInstance(String caseId, String name) {
        CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
        Assert.assertNotNull((Object)cInstance);
        Assert.assertEquals((Object)caseId, (Object)cInstance.getCaseId());
        Assert.assertNotNull((Object)cInstance.getCaseFile());
        Assert.assertEquals((Object)name, (Object)cInstance.getCaseFile().getData("name"));
    }
}

