/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.jbpm.casemgmt.api.auth.AuthorizationManager;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.command.Command;
import org.kie.internal.identity.IdentityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationManagerImpl
implements AuthorizationManager {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationManagerImpl.class);
    private static final String NO_ACCESS_MSG = "User {0} is not authorized to access case {1}";
    private static final String NO_AUTH_OPER_MSG = "User {0} is not authorized to {1} on case {2}";
    private IdentityProvider identityProvider;
    private TransactionalCommandService commandService;
    private boolean enabled = Boolean.parseBoolean(System.getProperty("org.jbpm.cases.auth.enabled", "true"));
    private Map<AuthorizationManager.ProtectedOperation, List<String>> operationAuthorization = new HashMap<AuthorizationManager.ProtectedOperation, List<String>>();

    public AuthorizationManagerImpl(IdentityProvider identityProvider, TransactionalCommandService commandService) {
        this.identityProvider = identityProvider;
        this.commandService = commandService;
        this.buildAuthorizationConfig();
    }

    public void checkAuthorization(String caseId) throws SecurityException {
        if (!this.isEnabled()) {
            return;
        }
        logger.debug("Checking authorization to case {} for user {}", (Object)caseId, (Object)this.identityProvider.getName());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("caseId", caseId);
        List authorizedEntities = (List)this.commandService.execute((Command)new QueryNameCommand("getAuthorizationToCaseInstance", params));
        this.verifyAuthorization(caseId, authorizedEntities, MessageFormat.format(NO_ACCESS_MSG, this.identityProvider.getName(), caseId));
    }

    public void checkOperationAuthorization(String caseId, AuthorizationManager.ProtectedOperation operation) throws SecurityException {
        List<String> rolesForOperation = this.operationAuthorization.get(operation);
        if (rolesForOperation == null || rolesForOperation.isEmpty()) {
            logger.debug("No restrictions defined for operation {}", (Object)operation);
            this.checkAuthorization(caseId);
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("caseId", caseId);
        params.put("roles", rolesForOperation);
        List authorizedEntities = (List)this.commandService.execute((Command)new QueryNameCommand("getAuthorizationToCaseInstanceByRole", params));
        this.verifyAuthorization(caseId, authorizedEntities, MessageFormat.format(NO_AUTH_OPER_MSG, this.identityProvider.getName(), operation, caseId));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected void buildAuthorizationConfig() {
        Properties loaded = new Properties();
        InputStream configuration = this.getClass().getResourceAsStream("/case-authorization.properties");
        if (configuration != null) {
            try {
                loaded.load(configuration);
            }
            catch (IOException e) {
                logger.error("Error loading case autorization config from file due to {}", (Object)e.getMessage(), (Object)e);
            }
        }
        Stream.of(AuthorizationManager.ProtectedOperation.values()).forEach(operation -> {
            ArrayList<String> roles = new ArrayList<String>();
            String grantedRoles = loaded.getProperty(operation.toString());
            if (grantedRoles != null) {
                roles.addAll(Arrays.asList(grantedRoles.split(",")));
            }
            this.operationAuthorization.put((AuthorizationManager.ProtectedOperation)operation, (List<String>)roles);
        });
    }

    protected void verifyAuthorization(String caseId, List<String> authorizedEntities, String errorMessage) {
        logger.debug("Case {} authorization set is {}", (Object)caseId, authorizedEntities);
        if (authorizedEntities.isEmpty()) {
            logger.debug("Not access restrictions defined for case {}", (Object)caseId);
            return;
        }
        List<String> callerAuthorization = this.collectUserAuthInfo();
        logger.debug("Caller authorization set is {}", callerAuthorization);
        boolean isAuthorized = callerAuthorization.stream().anyMatch(entity -> authorizedEntities.contains(entity));
        if (!isAuthorized) {
            logger.debug("User {} not authorized to access case {}", (Object)this.identityProvider.getName(), (Object)caseId);
            throw new SecurityException(errorMessage);
        }
        logger.debug("User {} authorized to access case {}", (Object)this.identityProvider.getName(), (Object)caseId);
    }

    protected List<String> collectUserAuthInfo() {
        ArrayList<String> entities = new ArrayList<String>();
        entities.add(this.identityProvider.getName());
        entities.addAll(this.identityProvider.getRoles());
        entities.add("_public_");
        return entities;
    }
}

