/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CaseStageInstance;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.services.api.ProcessDefinitionNotFoundException;
import org.junit.Test;

public class CaseDynamicNodesTest
extends AbstractCaseServicesBaseTest {
    private static final String EMPTY_CASE_STAGE = "EmptyCaseStage";
    private static final String NOT_EXISTING_SUBPROCESS = "NotExistingSubprocess";

    @Override
    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/EmptyCase.bpmn2");
        processes.add("cases/EmptyCaseStage.bpmn2");
        processes.add("cases/CaseWithTwoStages.bpmn2");
        processes.add("processes/UserTaskProcess.bpmn2");
        return processes;
    }

    @Test
    public void testAddDynamicSubprocessWithNotExistingProcessId() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        CaseInstance caseInstance = this.caseService.getCaseInstance(caseId, false, false, false, true);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        CaseStatus initialStatus = CaseStatus.fromId((int)caseInstance.getStatus());
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicSubprocess(caseId, NOT_EXISTING_SUBPROCESS, Collections.emptyMap())).isInstanceOf(ProcessDefinitionNotFoundException.class);
        CaseStatus afterStatus = CaseStatus.fromId((int)caseInstance.getStatus());
        Assertions.assertThat((initialStatus.getId() == afterStatus.getId() ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testAddDynamicSubprocessToStageWithNotExistingProcessId() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), EMPTY_CASE_STAGE);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        CaseInstance caseInstance = this.caseService.getCaseInstance(caseId, false, false, false, true);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        Assertions.assertThat((Iterable)caseInstance.getCaseStages()).hasSize(1);
        CaseStatus initialStatus = CaseStatus.fromId((int)caseInstance.getStatus());
        String stageId = ((CaseStageInstance)caseInstance.getCaseStages().iterator().next()).getId();
        Assertions.assertThat((String)stageId).isNotNull();
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicSubprocessToStage(caseId, stageId, NOT_EXISTING_SUBPROCESS, Collections.emptyMap())).isInstanceOf(ProcessDefinitionNotFoundException.class);
        CaseStatus afterStatus = CaseStatus.fromId((int)caseInstance.getStatus());
        Assertions.assertThat((initialStatus.getId() == afterStatus.getId() ? 1 : 0) != 0).isTrue();
    }
}

