/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.appformer.maven.support.AFReleaseId;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.casemgmt.api.CaseNotFoundException;
import org.jbpm.casemgmt.api.admin.CaseMigrationReport;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.admin.ProcessInstanceMigrationServiceImpl;
import org.jbpm.services.api.admin.ProcessInstanceMigrationService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.task.impl.model.UserImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseInstanceMigrationServiceImplTest
extends AbstractCaseServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(CaseInstanceMigrationServiceImplTest.class);
    protected static final String MIGRATION_ARTIFACT_ID = "test-migration";
    protected static final String MIGRATION_GROUP_ID = "org.jbpm.test";
    protected static final String MIGRATION_VERSION_V1 = "1.0.0";
    protected static final String MIGRATION_VERSION_V2 = "2.0.0";
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    private KModuleDeploymentUnit deploymentUnitV1;
    private KModuleDeploymentUnit deploymentUnitV2;
    protected ProcessInstanceMigrationService migrationService;
    private static final String CASE_DEF_ID_V1 = "UserTaskCase_V1";
    private static final String CASE_DEF_ID_V2 = "UserTaskCase_V2";
    private static final String PROCESS_DEF_ID_V1 = "UserTask_V1";
    private static final String PROCESS_DEF_ID_V2 = "UserTask_V2";
    private static final String PROCESS_DEF_ID_V3 = "UserTask_V3";

    @Override
    @Before
    public void setUp() throws Exception {
        this.configureServices();
        this.identityProvider.setName("john");
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(MIGRATION_GROUP_ID, MIGRATION_ARTIFACT_ID, MIGRATION_VERSION_V1);
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("migration/v1/UserTaskCase-v1.bpmn2");
        processes.add("migration/v1/UserTaskProcess-v1.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/migration-v1", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, pom);
        ReleaseId releaseId2 = ks.newReleaseId(MIGRATION_GROUP_ID, MIGRATION_ARTIFACT_ID, MIGRATION_VERSION_V2);
        processes = new ArrayList();
        processes.add("migration/v2/UserTaskCase-v2.bpmn2");
        processes.add("migration/v2/UserTaskProcess-v2.bpmn2");
        processes.add("migration/v2/UserTaskProcess-v3.bpmn2");
        InternalKieModule kJar2 = this.createKieJar(ks, releaseId2, processes);
        File pom2 = new File("target/migration-v2", "pom.xml");
        pom2.getParentFile().mkdirs();
        try {
            FileOutputStream fs = new FileOutputStream(pom2);
            fs.write(this.getPom(releaseId2, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId2, kJar2, pom2);
        this.migrationService = new ProcessInstanceMigrationServiceImpl();
        this.deploymentUnitV1 = new KModuleDeploymentUnit(MIGRATION_GROUP_ID, MIGRATION_ARTIFACT_ID, MIGRATION_VERSION_V1);
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnitV1);
        this.units.add((DeploymentUnit)this.deploymentUnitV1);
        this.deploymentUnitV2 = new KModuleDeploymentUnit(MIGRATION_GROUP_ID, MIGRATION_ARTIFACT_ID, MIGRATION_VERSION_V2);
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnitV2);
        this.units.add((DeploymentUnit)this.deploymentUnitV2);
    }

    @After
    public void cleanup() {
        CaseInstanceMigrationServiceImplTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMigrateSingleCaseInstance() {
        String caseId = this.createCaseInstanceV1();
        try {
            this.assertCaseInstance(caseId, this.deploymentUnitV1.getIdentifier(), CASE_DEF_ID_V1);
            HashMap<String, String> processMapping = new HashMap<String, String>();
            processMapping.put(CASE_DEF_ID_V1, CASE_DEF_ID_V2);
            CaseMigrationReport report = this.caseInstanceMigrationService.migrate(caseId, this.deploymentUnitV2.getIdentifier(), processMapping);
            Assert.assertNotNull((Object)report);
            Assertions.assertThat((boolean)report.isSuccessful()).isTrue();
            Assertions.assertThat((List)report.getReports()).hasSize(1);
            this.assertCaseInstance(caseId, this.deploymentUnitV2.getIdentifier(), CASE_DEF_ID_V2);
            this.caseService.destroyCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMigrateSingleCaseInstanceMissingMapping() {
        String caseId = this.createCaseInstanceV1();
        try {
            this.assertCaseInstance(caseId, this.deploymentUnitV1.getIdentifier(), CASE_DEF_ID_V1);
            HashMap processMapping = new HashMap();
            String caseIdFinal = caseId;
            Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.caseInstanceMigrationService.migrate(caseIdFinal, this.deploymentUnitV2.getIdentifier(), processMapping)).withMessageContaining("Not possible to migrate case instance " + caseId + " due to missing process mapping");
            this.assertCaseInstance(caseId, this.deploymentUnitV1.getIdentifier(), CASE_DEF_ID_V1);
            this.caseService.destroyCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    @Test
    public void testMigrateSingleCaseInstanceNotExisting() {
        Assertions.assertThatExceptionOfType(CaseNotFoundException.class).isThrownBy(() -> this.caseInstanceMigrationService.migrate("not-existing", this.deploymentUnitV2.getIdentifier(), new HashMap())).withMessageContaining("Case not-existing does not exist or is not active, cannot be migrated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMigrateSingleCaseInstanceWithDynamicSubprocess() {
        String caseId = this.createCaseInstanceV1();
        try {
            this.assertCaseInstance(caseId, this.deploymentUnitV1.getIdentifier(), CASE_DEF_ID_V1);
            this.caseService.addDynamicSubprocess(caseId, PROCESS_DEF_ID_V1, null);
            Collection pInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertEquals((long)2L, (long)pInstances.size());
            for (ProcessInstanceDesc instance : pInstances) {
                Assert.assertEquals((Object)this.deploymentUnitV1.getIdentifier(), (Object)instance.getDeploymentId());
            }
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assertions.assertThat((List)tasks).hasSize(2);
            Map<String, TaskSummary> mappedTasks = this.mapTaskSummaries(tasks);
            Assertions.assertThat(mappedTasks).containsKeys((Object[])new String[]{"Hello1", "Hello_V1"});
            HashMap<String, String> processMapping = new HashMap<String, String>();
            processMapping.put(CASE_DEF_ID_V1, CASE_DEF_ID_V2);
            processMapping.put(PROCESS_DEF_ID_V1, PROCESS_DEF_ID_V2);
            CaseMigrationReport report = this.caseInstanceMigrationService.migrate(caseId, this.deploymentUnitV2.getIdentifier(), processMapping);
            Assert.assertNotNull((Object)report);
            Assertions.assertThat((boolean)report.isSuccessful()).isTrue();
            Assertions.assertThat((List)report.getReports()).hasSize(2);
            this.assertCaseInstance(caseId, this.deploymentUnitV2.getIdentifier(), CASE_DEF_ID_V2);
            pInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertEquals((long)2L, (long)pInstances.size());
            for (ProcessInstanceDesc instance : pInstances) {
                Assert.assertEquals((Object)this.deploymentUnitV2.getIdentifier(), (Object)instance.getDeploymentId());
            }
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assertions.assertThat((List)tasks).hasSize(2);
            mappedTasks = this.mapTaskSummaries(tasks);
            Assertions.assertThat(mappedTasks).containsKeys((Object[])new String[]{"Hello1", "Hello_V2"});
            this.userTaskService.completeAutoProgress(mappedTasks.get("Hello_V2").getId(), "john", null);
            this.caseService.destroyCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMigrateSingleCaseInstanceWithDynamicSubprocessNodeMapping() {
        String caseId = this.createCaseInstanceV1();
        try {
            this.assertCaseInstance(caseId, this.deploymentUnitV1.getIdentifier(), CASE_DEF_ID_V1);
            this.caseService.addDynamicSubprocess(caseId, PROCESS_DEF_ID_V1, null);
            Collection pInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertEquals((long)2L, (long)pInstances.size());
            for (ProcessInstanceDesc instance : pInstances) {
                Assert.assertEquals((Object)this.deploymentUnitV1.getIdentifier(), (Object)instance.getDeploymentId());
            }
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assertions.assertThat((List)tasks).hasSize(2);
            Map<String, TaskSummary> mappedTasks = this.mapTaskSummaries(tasks);
            Assertions.assertThat(mappedTasks).containsKeys((Object[])new String[]{"Hello1", "Hello_V1"});
            HashMap<String, String> processMapping = new HashMap<String, String>();
            processMapping.put(CASE_DEF_ID_V1, CASE_DEF_ID_V2);
            processMapping.put(PROCESS_DEF_ID_V1, PROCESS_DEF_ID_V3);
            HashMap<String, String> nodeMapping = new HashMap<String, String>();
            nodeMapping.put("_22", "_33");
            CaseMigrationReport report = this.caseInstanceMigrationService.migrate(caseId, this.deploymentUnitV2.getIdentifier(), processMapping, nodeMapping);
            Assert.assertNotNull((Object)report);
            Assertions.assertThat((boolean)report.isSuccessful()).isTrue();
            Assertions.assertThat((List)report.getReports()).hasSize(2);
            this.assertCaseInstance(caseId, this.deploymentUnitV2.getIdentifier(), CASE_DEF_ID_V2);
            pInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertEquals((long)2L, (long)pInstances.size());
            for (ProcessInstanceDesc instance : pInstances) {
                Assert.assertEquals((Object)this.deploymentUnitV2.getIdentifier(), (Object)instance.getDeploymentId());
            }
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assertions.assertThat((List)tasks).hasSize(2);
            mappedTasks = this.mapTaskSummaries(tasks);
            Assertions.assertThat(mappedTasks).containsKeys((Object[])new String[]{"Hello1", "Hello_V3"});
            this.userTaskService.completeAutoProgress(mappedTasks.get("Hello_V3").getId(), "john", null);
            this.caseService.destroyCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMigrateSingleCaseInstanceWithDynamicSubprocessRevert() {
        String caseId = this.createCaseInstanceV1();
        try {
            this.assertCaseInstance(caseId, this.deploymentUnitV1.getIdentifier(), CASE_DEF_ID_V1);
            this.caseService.addDynamicSubprocess(caseId, PROCESS_DEF_ID_V1, null);
            Collection pInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertEquals((long)2L, (long)pInstances.size());
            for (ProcessInstanceDesc instance : pInstances) {
                Assert.assertEquals((Object)this.deploymentUnitV1.getIdentifier(), (Object)instance.getDeploymentId());
            }
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assertions.assertThat((List)tasks).hasSize(2);
            Map<String, TaskSummary> mappedTasks = this.mapTaskSummaries(tasks);
            Assertions.assertThat(mappedTasks).containsKeys((Object[])new String[]{"Hello1", "Hello_V1"});
            HashMap<String, String> processMapping = new HashMap<String, String>();
            processMapping.put(CASE_DEF_ID_V1, CASE_DEF_ID_V2);
            processMapping.put(PROCESS_DEF_ID_V1, PROCESS_DEF_ID_V3);
            Map<String, Integer> erronousMapping = Collections.singletonMap("_22", 2);
            CaseMigrationReport report = this.caseInstanceMigrationService.migrate(caseId, this.deploymentUnitV2.getIdentifier(), processMapping, erronousMapping);
            Assert.assertNotNull((Object)report);
            Assertions.assertThat((boolean)report.isSuccessful()).isFalse();
            Assertions.assertThat((List)report.getReports()).hasSize(2);
            this.assertCaseInstance(caseId, this.deploymentUnitV1.getIdentifier(), CASE_DEF_ID_V1);
            pInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertEquals((long)2L, (long)pInstances.size());
            for (ProcessInstanceDesc instance : pInstances) {
                Assert.assertEquals((Object)this.deploymentUnitV1.getIdentifier(), (Object)instance.getDeploymentId());
            }
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assertions.assertThat((List)tasks).hasSize(2);
            mappedTasks = this.mapTaskSummaries(tasks);
            Assertions.assertThat(mappedTasks).containsKeys((Object[])new String[]{"Hello1", "Hello_V1"});
            this.userTaskService.completeAutoProgress(mappedTasks.get("Hello_V1").getId(), "john", null);
            this.caseService.destroyCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    protected String createCaseInstanceV1() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "case description");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnitV1.getIdentifier(), CASE_DEF_ID_V1, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnitV1.getIdentifier(), CASE_DEF_ID_V1, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"HR-0000000001", (Object)caseId);
        return caseId;
    }

    protected void assertCaseInstance(String caseId, String deploymentId, String definitionId) {
        CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
        Assert.assertNotNull((Object)cInstance);
        Assert.assertEquals((Object)deploymentId, (Object)cInstance.getDeploymentId());
        Assert.assertEquals((Object)definitionId, (Object)cInstance.getCaseDefinitionId());
        CaseFileInstance caseFileInstance = this.caseService.getCaseFileInstance(caseId);
        Assert.assertNotNull((Object)caseFileInstance);
        Assert.assertEquals((Object)definitionId, (Object)caseFileInstance.getDefinitionId());
    }

    @Override
    protected List<String> getProcessDefinitionFiles() {
        return null;
    }
}

