/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.utils;

import javax.persistence.EntityManagerFactory;
import org.jbpm.casemgmt.api.CaseRuntimeDataService;
import org.jbpm.casemgmt.api.CaseService;
import org.jbpm.casemgmt.api.admin.CaseInstanceMigrationService;
import org.jbpm.casemgmt.api.auth.AuthorizationManager;
import org.jbpm.casemgmt.api.generator.CaseIdGenerator;
import org.jbpm.casemgmt.api.utils.CaseServiceConfigurator;
import org.jbpm.casemgmt.impl.AuthorizationManagerImpl;
import org.jbpm.casemgmt.impl.CaseRuntimeDataServiceImpl;
import org.jbpm.casemgmt.impl.CaseServiceImpl;
import org.jbpm.casemgmt.impl.admin.CaseInstanceMigrationServiceImpl;
import org.jbpm.casemgmt.impl.event.CaseConfigurationDeploymentListener;
import org.jbpm.casemgmt.impl.generator.TableCaseIdGenerator;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.kie.services.impl.FormManagerServiceImpl;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.ProcessServiceImpl;
import org.jbpm.kie.services.impl.RuntimeDataServiceImpl;
import org.jbpm.kie.services.impl.UserTaskServiceImpl;
import org.jbpm.kie.services.impl.admin.ProcessInstanceMigrationServiceImpl;
import org.jbpm.kie.services.impl.bpmn2.BPMN2DataServiceImpl;
import org.jbpm.kie.services.impl.query.QueryServiceImpl;
import org.jbpm.kie.services.impl.security.DeploymentRolesManager;
import org.jbpm.runtime.manager.impl.RuntimeManagerFactoryImpl;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.admin.ProcessInstanceMigrationService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.audit.TaskAuditServiceFactory;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.task.TaskService;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.RuntimeStrategy;

public class DefaultCaseServiceConfigurator
implements CaseServiceConfigurator {
    protected EntityManagerFactory emf;
    protected DeploymentService deploymentService;
    protected DefinitionService bpmn2Service;
    protected RuntimeDataService runtimeDataService;
    protected ProcessService processService;
    protected UserTaskService userTaskService;
    protected QueryService queryService;
    protected CaseRuntimeDataService caseRuntimeDataService;
    protected CaseService caseService;
    protected CaseInstanceMigrationService caseInstanceMigrationService;
    protected ProcessInstanceMigrationService migrationService;
    protected IdentityProvider identityProvider;
    protected CaseIdGenerator caseIdGenerator;
    protected AuthorizationManager authorizationManager;

    public void configureServices(String puName, IdentityProvider identityProvider) {
        this.emf = EntityManagerFactoryManager.get().getOrCreate(puName);
        this.authorizationManager = new AuthorizationManagerImpl(identityProvider, new TransactionalCommandService(this.emf));
        this.bpmn2Service = new BPMN2DataServiceImpl();
        DeploymentRolesManager deploymentRolesManager = new DeploymentRolesManager();
        this.queryService = new QueryServiceImpl();
        ((QueryServiceImpl)this.queryService).setIdentityProvider(identityProvider);
        ((QueryServiceImpl)this.queryService).setCommandService(new TransactionalCommandService(this.emf));
        ((QueryServiceImpl)this.queryService).init();
        this.deploymentService = new KModuleDeploymentService();
        ((KModuleDeploymentService)this.deploymentService).setBpmn2Service(this.bpmn2Service);
        ((KModuleDeploymentService)this.deploymentService).setEmf(this.emf);
        ((KModuleDeploymentService)this.deploymentService).setIdentityProvider(identityProvider);
        ((KModuleDeploymentService)this.deploymentService).setManagerFactory((RuntimeManagerFactory)new RuntimeManagerFactoryImpl());
        ((KModuleDeploymentService)this.deploymentService).setFormManagerService((FormManagerService)new FormManagerServiceImpl());
        TaskService taskService = HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(this.emf).getTaskService();
        this.runtimeDataService = new RuntimeDataServiceImpl();
        ((RuntimeDataServiceImpl)this.runtimeDataService).setCommandService(new TransactionalCommandService(this.emf));
        ((RuntimeDataServiceImpl)this.runtimeDataService).setIdentityProvider(identityProvider);
        ((RuntimeDataServiceImpl)this.runtimeDataService).setTaskService(taskService);
        ((RuntimeDataServiceImpl)this.runtimeDataService).setDeploymentRolesManager(deploymentRolesManager);
        ((RuntimeDataServiceImpl)this.runtimeDataService).setTaskAuditService(TaskAuditServiceFactory.newTaskAuditServiceConfigurator().setTaskService(taskService).getTaskAuditService());
        ((KModuleDeploymentService)this.deploymentService).setRuntimeDataService(this.runtimeDataService);
        this.processService = new ProcessServiceImpl();
        ((ProcessServiceImpl)this.processService).setDataService(this.runtimeDataService);
        ((ProcessServiceImpl)this.processService).setDeploymentService(this.deploymentService);
        this.userTaskService = new UserTaskServiceImpl();
        ((UserTaskServiceImpl)this.userTaskService).setDataService(this.runtimeDataService);
        ((UserTaskServiceImpl)this.userTaskService).setDeploymentService(this.deploymentService);
        this.caseIdGenerator = new TableCaseIdGenerator(new TransactionalCommandService(this.emf));
        this.caseRuntimeDataService = new CaseRuntimeDataServiceImpl();
        ((CaseRuntimeDataServiceImpl)this.caseRuntimeDataService).setCaseIdGenerator(this.caseIdGenerator);
        ((CaseRuntimeDataServiceImpl)this.caseRuntimeDataService).setRuntimeDataService(this.runtimeDataService);
        ((CaseRuntimeDataServiceImpl)this.caseRuntimeDataService).setCommandService(new TransactionalCommandService(this.emf));
        ((CaseRuntimeDataServiceImpl)this.caseRuntimeDataService).setIdentityProvider(identityProvider);
        ((CaseRuntimeDataServiceImpl)this.caseRuntimeDataService).setDeploymentRolesManager(deploymentRolesManager);
        this.caseService = new CaseServiceImpl();
        ((CaseServiceImpl)this.caseService).setCaseIdGenerator(this.caseIdGenerator);
        ((CaseServiceImpl)this.caseService).setCaseRuntimeDataService(this.caseRuntimeDataService);
        ((CaseServiceImpl)this.caseService).setProcessService(this.processService);
        ((CaseServiceImpl)this.caseService).setDeploymentService(this.deploymentService);
        ((CaseServiceImpl)this.caseService).setRuntimeDataService(this.runtimeDataService);
        ((CaseServiceImpl)this.caseService).setCommandService(new TransactionalCommandService(this.emf));
        ((CaseServiceImpl)this.caseService).setAuthorizationManager(this.authorizationManager);
        ((CaseServiceImpl)this.caseService).setIdentityProvider(identityProvider);
        CaseConfigurationDeploymentListener configurationListener = new CaseConfigurationDeploymentListener(identityProvider);
        ((KModuleDeploymentService)this.deploymentService).addListener((DeploymentEventListener)((RuntimeDataServiceImpl)this.runtimeDataService));
        ((KModuleDeploymentService)this.deploymentService).addListener((DeploymentEventListener)((BPMN2DataServiceImpl)this.bpmn2Service));
        ((KModuleDeploymentService)this.deploymentService).addListener((DeploymentEventListener)((QueryServiceImpl)this.queryService));
        ((KModuleDeploymentService)this.deploymentService).addListener((DeploymentEventListener)((CaseRuntimeDataServiceImpl)this.caseRuntimeDataService));
        ((KModuleDeploymentService)this.deploymentService).addListener((DeploymentEventListener)configurationListener);
        this.migrationService = new ProcessInstanceMigrationServiceImpl();
        this.caseInstanceMigrationService = new CaseInstanceMigrationServiceImpl();
        ((CaseInstanceMigrationServiceImpl)this.caseInstanceMigrationService).setCaseRuntimeDataService(this.caseRuntimeDataService);
        ((CaseInstanceMigrationServiceImpl)this.caseInstanceMigrationService).setCommandService(new TransactionalCommandService(this.emf));
        ((CaseInstanceMigrationServiceImpl)this.caseInstanceMigrationService).setProcessInstanceMigrationService(this.migrationService);
        ((CaseInstanceMigrationServiceImpl)this.caseInstanceMigrationService).setProcessService(this.processService);
    }

    public void close() {
        this.emf.close();
    }

    public DeploymentService getDeploymentService() {
        return this.deploymentService;
    }

    public DefinitionService getBpmn2Service() {
        return this.bpmn2Service;
    }

    public RuntimeDataService getRuntimeDataService() {
        return this.runtimeDataService;
    }

    public ProcessService getProcessService() {
        return this.processService;
    }

    public UserTaskService getUserTaskService() {
        return this.userTaskService;
    }

    public QueryService getQueryService() {
        return this.queryService;
    }

    public CaseRuntimeDataService getCaseRuntimeDataService() {
        return this.caseRuntimeDataService;
    }

    public CaseService getCaseService() {
        return this.caseService;
    }

    public CaseInstanceMigrationService getCaseInstanceMigrationService() {
        return this.caseInstanceMigrationService;
    }

    public ProcessInstanceMigrationService getMigrationService() {
        return this.migrationService;
    }

    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    public CaseIdGenerator getCaseIdGenerator() {
        return this.caseIdGenerator;
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    public DeploymentUnit createDeploymentUnit(String groupId, String artifactid, String version) {
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit(groupId, artifactid, version);
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl();
        descriptor.getBuilder().addEventListener((ObjectModel)new NamedObjectModel("mvel", "processIdentity", "new org.jbpm.kie.services.impl.IdentityProviderAwareProcessListener(ksession)", new Object[0]));
        deploymentUnit.setDeploymentDescriptor((DeploymentDescriptor)descriptor);
        deploymentUnit.setStrategy(RuntimeStrategy.PER_CASE);
        return deploymentUnit;
    }

    public EntityManagerFactory getEmf() {
        return this.emf;
    }
}

