/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.test.listener.process.DefaultCountDownProcessEventListener;
import org.jbpm.test.listener.process.NodeLeftCountDownProcessEventListener;
import org.jbpm.test.listener.process.SLAViolationCountDownProcessEventListener;

public class CountDownListenerFactory {
    private static Map<String, DefaultCountDownProcessEventListener> listeners = new ConcurrentHashMap<String, DefaultCountDownProcessEventListener>();

    public static DefaultCountDownProcessEventListener get(String id, String nodeName, int threads) {
        if (listeners.containsKey(id)) {
            return listeners.get(id);
        }
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener(nodeName, threads);
        listeners.put(id, (DefaultCountDownProcessEventListener)listener);
        return listener;
    }

    public static DefaultCountDownProcessEventListener getSLA(String id, int threads) {
        if (listeners.containsKey(id)) {
            return listeners.get(id);
        }
        SLAViolationCountDownProcessEventListener listener = new SLAViolationCountDownProcessEventListener(threads);
        listeners.put(id, (DefaultCountDownProcessEventListener)listener);
        return listener;
    }

    public static DefaultCountDownProcessEventListener getExisting(String id) {
        return listeners.get(id);
    }

    public static DefaultCountDownProcessEventListener removeExisting(String id) {
        return listeners.remove(id);
    }

    public static void clear() {
        listeners.clear();
    }
}

