/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.casemgmt.api.AdHocFragmentNotFoundException;
import org.jbpm.casemgmt.api.CaseActiveException;
import org.jbpm.casemgmt.api.CaseCommentNotFoundException;
import org.jbpm.casemgmt.api.CaseDefinitionNotFoundException;
import org.jbpm.casemgmt.api.CaseNotFoundException;
import org.jbpm.casemgmt.api.dynamic.TaskSpecification;
import org.jbpm.casemgmt.api.model.AdHocFragment;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.CaseFileItem;
import org.jbpm.casemgmt.api.model.CaseStage;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CaseMilestoneInstance;
import org.jbpm.casemgmt.api.model.instance.CaseStageInstance;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.jbpm.casemgmt.api.model.instance.CommentSortBy;
import org.jbpm.casemgmt.api.model.instance.MilestoneStatus;
import org.jbpm.casemgmt.api.model.instance.StageStatus;
import org.jbpm.casemgmt.impl.model.instance.CaseInstanceImpl;
import org.jbpm.casemgmt.impl.objects.EchoService;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.document.Document;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.process.CaseAssignment;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.QuickTaskSummary;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.query.QueryFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseServiceImplTest
extends AbstractCaseServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(CaseServiceImplTest.class);

    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/EmptyCase.bpmn2");
        processes.add("cases/UserTaskCase.bpmn2");
        processes.add("cases/UserTaskWithStageCase.bpmn2");
        processes.add("cases/UserTaskWithStageCaseAutoStart.bpmn2");
        processes.add("cases/UserStageAdhocCase.bpmn2");
        processes.add("cases/ScriptRoleAssignmentCase.bpmn2");
        processes.add("cases/NoStartNodeAdhocCase.bpmn2");
        processes.add("cases/CaseFileConditionalEvent.bpmn2");
        processes.add("cases/CaseWithRolesDefinition.bpmn2");
        processes.add("cases/CaseWithTwoStagesConditions.bpmn2");
        processes.add("cases/CaseWithExpressionOnCaseFileItem.bpmn2");
        processes.add("cases/UserTaskCaseDataRestrictions.bpmn2");
        processes.add("cases/InclusiveGatewayInDynamicCase.bpmn2");
        processes.add("cases/CaseMultiInstanceStage.bpmn2");
        processes.add("cases/UserTaskCaseData.bpmn2");
        processes.add("processes/DataVerificationProcess.bpmn2");
        return processes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCase() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase");
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseAndDestroy() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase");
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            this.caseService.destroyCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseWithCaseFile() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertNotNull((Object)cInstance.getCaseFile());
            Assert.assertEquals((Object)"my first case", (Object)cInstance.getCaseFile().getData("name"));
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Collection vars = this.runtimeDataService.getVariablesCurrentState(((CaseInstanceImpl)cInstance).getProcessInstanceId().longValue());
            Assert.assertNotNull((Object)vars);
            Assert.assertEquals((long)3L, (long)vars.size());
            Map<String, Object> mappedVars = vars.stream().collect(Collectors.toMap(v -> v.getVariableId(), v -> v.getNewValue()));
            Assert.assertEquals((Object)"my first case", (Object)mappedVars.get("caseFile_name"));
            Assert.assertEquals((Object)"CASE-0000000001", (Object)mappedVars.get("CaseId"));
            Assert.assertEquals((Object)"john", (Object)mappedVars.get("initiator"));
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseWithCaseFileAndDocument() {
        byte[] docContent = "first case document".getBytes();
        DocumentImpl document = new DocumentImpl(UUID.randomUUID().toString(), "test case doc", (long)docContent.length, new Date());
        document.setContent(docContent);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        data.put("document", (String)document);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertNotNull((Object)cInstance.getCaseFile());
            Assert.assertEquals((Object)"my first case", (Object)cInstance.getCaseFile().getData("name"));
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Object doc = cInstance.getCaseFile().getData("document");
            Assert.assertNotNull((Object)doc);
            Assert.assertTrue((boolean)(doc instanceof Document));
            Document caseDoc = (Document)doc;
            Assert.assertEquals((Object)"test case doc", (Object)caseDoc.getName());
            Assert.assertEquals((long)docContent.length, (long)caseDoc.getSize());
            Assert.assertEquals((Object)new String(docContent), (Object)new String(caseDoc.getContent()));
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddUserTaskToEmptyCase() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("variable", "#{name}");
            this.caseService.addDynamicTask("CASE-0000000001", this.caseService.newHumanTaskSpec("First task", "test", "john", null, parameters));
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            TaskSummary task = (TaskSummary)tasks.get(0);
            this.assertTask(task, "john", "First task", Status.Reserved);
            Assert.assertEquals((Object)"test", (Object)task.getDescription());
            Map inputs = this.userTaskService.getTaskInputContentByTaskId(task.getId());
            Assert.assertNotNull((Object)inputs);
            Assert.assertEquals((Object)"my first case", inputs.get("variable"));
            String nameVar = (String)this.processService.getProcessInstanceVariable(task.getProcessInstanceId(), "name");
            Assert.assertNotNull((Object)nameVar);
            Assert.assertEquals((Object)"my first case", (Object)nameVar);
            this.userTaskService.start(task.getId(), "john");
            HashMap<String, String> outcome = new HashMap<String, String>();
            outcome.put("name", "updated by dynamic task");
            this.userTaskService.complete(task.getId(), "john", outcome);
            nameVar = (String)this.processService.getProcessInstanceVariable(task.getProcessInstanceId(), "name");
            Assert.assertNotNull((Object)nameVar);
            Assert.assertEquals((Object)"updated by dynamic task", (Object)nameVar);
            Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)1L, (long)caseProcessInstances.size());
            ProcessInstanceDesc casePI = (ProcessInstanceDesc)caseProcessInstances.iterator().next();
            Assert.assertNotNull((Object)casePI);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)casePI.getCorrelationKey());
            this.caseService.addDynamicTask(casePI.getId(), this.caseService.newHumanTaskSpec("Second task", "another test", "mary", null, parameters));
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            task = (TaskSummary)tasks.get(0);
            this.assertTask(task, "mary", "Second task", Status.Reserved);
            Assert.assertEquals((Object)"another test", (Object)task.getDescription());
            try {
                this.userTaskService.start(task.getId(), "john");
            }
            catch (TaskNotFoundException taskNotFoundException) {
                // empty catch block
            }
            this.userTaskService.start(task.getId(), "mary");
            this.userTaskService.complete(task.getId(), "mary", null);
            Collection nodes = this.runtimeDataService.getProcessInstanceHistoryCompleted(casePI.getId().longValue(), new QueryContext());
            Assert.assertNotNull((Object)nodes);
            Assert.assertEquals((long)4L, (long)nodes.size());
            Map<String, String> nodesByName = nodes.stream().collect(Collectors.toMap(NodeInstanceDesc::getName, NodeInstanceDesc::getNodeType));
            Assert.assertTrue((boolean)nodesByName.containsKey("StartProcess"));
            Assert.assertTrue((boolean)nodesByName.containsKey("EndProcess"));
            Assert.assertTrue((boolean)nodesByName.containsKey("[Dynamic] First task"));
            Assert.assertTrue((boolean)nodesByName.containsKey("[Dynamic] Second task"));
            Assert.assertEquals((Object)"StartNode", (Object)nodesByName.get("StartProcess"));
            Assert.assertEquals((Object)"EndNode", (Object)nodesByName.get("EndProcess"));
            Assert.assertEquals((Object)"Human Task", (Object)nodesByName.get("[Dynamic] First task"));
            Assert.assertEquals((Object)"Human Task", (Object)nodesByName.get("[Dynamic] Second task"));
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddUserTaskToCaseWithStage() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            CaseDefinition caseDef = this.caseRuntimeDataService.getCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCase");
            Assert.assertNotNull((Object)caseDef);
            Assert.assertEquals((long)1L, (long)caseDef.getCaseStages().size());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
            CaseStage stage = (CaseStage)caseDef.getCaseStages().iterator().next();
            HashMap parameters = new HashMap();
            this.caseService.addDynamicTaskToStage("CASE-0000000001", stage.getId(), this.caseService.newHumanTaskSpec("First task", "test", "john", null, parameters));
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            TaskSummary task = (TaskSummary)tasks.get(0);
            this.assertTask(task, "john", "First task", Status.Reserved);
            Assert.assertEquals((Object)"test", (Object)task.getDescription());
            Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)1L, (long)caseProcessInstances.size());
            ProcessInstanceDesc casePI = (ProcessInstanceDesc)caseProcessInstances.iterator().next();
            Assert.assertNotNull((Object)casePI);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)casePI.getCorrelationKey());
            this.caseService.addDynamicTaskToStage(casePI.getId(), stage.getId(), this.caseService.newHumanTaskSpec("Second task", "another test", "mary", null, parameters));
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            task = (TaskSummary)tasks.get(0);
            this.assertTask(task, "mary", "Second task", Status.Reserved);
            Assert.assertEquals((Object)"another test", (Object)task.getDescription());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddServiceTaskToEmptyCase() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)1L, (long)caseProcessInstances.size());
            ProcessInstanceDesc casePI = (ProcessInstanceDesc)caseProcessInstances.iterator().next();
            Assert.assertNotNull((Object)casePI);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)casePI.getCorrelationKey());
            String nameVar = (String)this.processService.getProcessInstanceVariable(casePI.getId(), "name");
            Assert.assertNotNull((Object)nameVar);
            Assert.assertEquals((Object)"my first case", (Object)nameVar);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("Interface", EchoService.class.getName());
            parameters.put("Operation", "echo");
            parameters.put("ParameterType", String.class.getName());
            parameters.put("Parameter", "testing dynamic service task");
            this.caseService.addDynamicTask("CASE-0000000001", this.caseService.newTaskSpec("Service Task", "task 1", parameters));
            nameVar = (String)this.processService.getProcessInstanceVariable(casePI.getId(), "name");
            Assert.assertNotNull((Object)nameVar);
            Assert.assertEquals((Object)"testing dynamic service task echoed by service", (Object)nameVar);
            parameters.put("Parameter", "testing dynamic service task 2");
            this.caseService.addDynamicTask(casePI.getId(), this.caseService.newTaskSpec("Service Task", "task 2", parameters));
            nameVar = (String)this.processService.getProcessInstanceVariable(casePI.getId(), "name");
            Assert.assertNotNull((Object)nameVar);
            Assert.assertEquals((Object)"testing dynamic service task 2 echoed by service", (Object)nameVar);
            Collection nodes = this.runtimeDataService.getProcessInstanceHistoryCompleted(casePI.getId().longValue(), new QueryContext());
            Assert.assertNotNull((Object)nodes);
            Assert.assertEquals((long)4L, (long)nodes.size());
            Map<String, String> nodesByName = nodes.stream().collect(Collectors.toMap(NodeInstanceDesc::getName, NodeInstanceDesc::getNodeType));
            Assert.assertTrue((boolean)nodesByName.containsKey("StartProcess"));
            Assert.assertTrue((boolean)nodesByName.containsKey("EndProcess"));
            Assert.assertTrue((boolean)nodesByName.containsKey("[Dynamic] task 1"));
            Assert.assertTrue((boolean)nodesByName.containsKey("[Dynamic] task 2"));
            Assert.assertEquals((Object)"StartNode", (Object)nodesByName.get("StartProcess"));
            Assert.assertEquals((Object)"EndNode", (Object)nodesByName.get("EndProcess"));
            Assert.assertEquals((Object)"Service Task", (Object)nodesByName.get("[Dynamic] task 1"));
            Assert.assertEquals((Object)"Service Task", (Object)nodesByName.get("[Dynamic] task 2"));
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddSubprocessToEmptyCase() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            HashMap parameters = new HashMap();
            this.caseService.addDynamicSubprocess("CASE-0000000001", "DataVerification", parameters);
            Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)2L, (long)caseProcessInstances.size());
            ProcessInstanceDesc casePI = (ProcessInstanceDesc)caseProcessInstances.iterator().next();
            Assert.assertNotNull((Object)casePI);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)casePI.getCorrelationKey());
            Collection nodes = this.runtimeDataService.getProcessInstanceHistoryCompleted(casePI.getId().longValue(), new QueryContext());
            Assert.assertNotNull((Object)nodes);
            Assert.assertEquals((long)3L, (long)nodes.size());
            Map<String, String> nodesByName = nodes.stream().collect(Collectors.toMap(NodeInstanceDesc::getName, NodeInstanceDesc::getNodeType));
            Assert.assertTrue((boolean)nodesByName.containsKey("StartProcess"));
            Assert.assertTrue((boolean)nodesByName.containsKey("EndProcess"));
            Assert.assertTrue((boolean)nodesByName.containsKey("[Dynamic] Sub Process"));
            Assert.assertEquals((Object)"StartNode", (Object)nodesByName.get("StartProcess"));
            Assert.assertEquals((Object)"EndNode", (Object)nodesByName.get("EndProcess"));
            Assert.assertEquals((Object)"SubProcessNode", (Object)nodesByName.get("[Dynamic] Sub Process"));
            this.caseService.addDynamicSubprocess(casePI.getId(), "DataVerification", parameters);
            caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)3L, (long)caseProcessInstances.size());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddSubprocessToCaseWithStage() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            CaseDefinition caseDef = this.caseRuntimeDataService.getCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCase");
            Assert.assertNotNull((Object)caseDef);
            Assert.assertEquals((long)1L, (long)caseDef.getCaseStages().size());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
            CaseStage stage = (CaseStage)caseDef.getCaseStages().iterator().next();
            HashMap parameters = new HashMap();
            this.caseService.addDynamicSubprocessToStage("CASE-0000000001", stage.getId(), "DataVerification", parameters);
            Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)2L, (long)caseProcessInstances.size());
            ProcessInstanceDesc casePI = (ProcessInstanceDesc)caseProcessInstances.iterator().next();
            Assert.assertNotNull((Object)casePI);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)casePI.getCorrelationKey());
            this.caseService.addDynamicSubprocessToStage(casePI.getId(), stage.getId(), "DataVerification", parameters);
            caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)3L, (long)caseProcessInstances.size());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTriggerTaskAndMilestoneInCase() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "description");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
        CaseDefinition caseDef = this.caseRuntimeDataService.getCase(this.deploymentUnit.getIdentifier(), "UserTaskCase");
        Assert.assertNotNull((Object)caseDef);
        Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
        Assert.assertEquals((long)3L, (long)caseDef.getAdHocFragments().size());
        Map mappedFragments = this.mapAdHocFragments(caseDef.getAdHocFragments());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Hello2"));
        Assert.assertTrue((boolean)mappedFragments.containsKey("Milestone1"));
        Assert.assertTrue((boolean)mappedFragments.containsKey("Milestone2"));
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"HR-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"HR-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            TaskSummary task = (TaskSummary)tasks.get(0);
            Assert.assertNotNull((Object)task);
            Assert.assertEquals((Object)"Hello1", (Object)task.getName());
            Assert.assertEquals((Object)"john", (Object)task.getActualOwnerId());
            Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
            HashMap<String, String> taskData = new HashMap<String, String>();
            taskData.put("test", "value");
            taskData.put("fromVar", "#{s}");
            this.caseService.triggerAdHocFragment("HR-0000000001", "Hello2", taskData);
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)2L, (long)tasks.size());
            task = (TaskSummary)tasks.get(0);
            Assert.assertNotNull((Object)task);
            Assert.assertEquals((Object)"Hello2", (Object)task.getName());
            Assert.assertEquals((Object)"john", (Object)task.getActualOwnerId());
            Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
            Map taskInputs = this.userTaskService.getTaskInputContentByTaskId(task.getId());
            Assert.assertNotNull((Object)taskInputs);
            Assert.assertTrue((boolean)taskInputs.containsKey("test"));
            Assert.assertTrue((boolean)taskInputs.containsKey("fromVar"));
            Assert.assertEquals((Object)"value", taskInputs.get("test"));
            Assert.assertEquals((Object)"description", taskInputs.get("fromVar"));
            task = (TaskSummary)tasks.get(1);
            Assert.assertNotNull((Object)task);
            Assert.assertEquals((Object)"Hello1", (Object)task.getName());
            Assert.assertEquals((Object)"john", (Object)task.getActualOwnerId());
            Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
            Collection milestones = this.caseRuntimeDataService.getCaseInstanceMilestones("HR-0000000001", true, new QueryContext());
            Assert.assertNotNull((Object)milestones);
            Assert.assertEquals((long)0L, (long)milestones.size());
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones("HR-0000000001", false, new QueryContext());
            Assert.assertNotNull((Object)milestones);
            Assert.assertEquals((long)2L, (long)milestones.size());
            List<String> expectedMilestones = Arrays.asList("Milestone1", "Milestone2");
            for (CaseMilestoneInstance mi : milestones) {
                Assert.assertTrue((String)"Expected mile stopne not found", (boolean)expectedMilestones.contains(mi.getName()));
                Assert.assertEquals((String)"Wrong milestone status", (Object)MilestoneStatus.Available, (Object)mi.getStatus());
                Assert.assertFalse((String)"Should not be achieved", (boolean)mi.isAchieved());
                Assert.assertNull((String)"Achieved date should be null", (Object)mi.getAchievedAt());
            }
            this.caseService.triggerAdHocFragment("HR-0000000001", "Milestone1", null);
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones("HR-0000000001", true, new QueryContext());
            Assert.assertNotNull((Object)milestones);
            Assert.assertEquals((long)1L, (long)milestones.size());
            CaseMilestoneInstance msInstance = (CaseMilestoneInstance)milestones.iterator().next();
            Assert.assertNotNull((Object)msInstance);
            Assert.assertEquals((Object)"Milestone1", (Object)msInstance.getName());
            Assert.assertEquals((Object)true, (Object)msInstance.isAchieved());
            Assert.assertNotNull((Object)msInstance.getAchievedAt());
            this.caseService.triggerAdHocFragment("HR-0000000001", "Milestone2", null);
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones("HR-0000000001", true, new QueryContext());
            Assert.assertNotNull((Object)milestones);
            Assert.assertEquals((long)1L, (long)milestones.size());
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones("HR-0000000001", false, new QueryContext());
            Assert.assertNotNull((Object)milestones);
            Assert.assertEquals((long)2L, (long)milestones.size());
            this.caseService.addDataToCaseFile("HR-0000000001", "dataComplete", (Object)true, new String[0]);
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones("HR-0000000001", true, new QueryContext());
            Assert.assertNotNull((Object)milestones);
            Assert.assertEquals((long)2L, (long)milestones.size());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseRolesWithDynamicTask() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "description");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
        CaseDefinition caseDef = this.caseRuntimeDataService.getCase(this.deploymentUnit.getIdentifier(), "UserTaskCase");
        Assert.assertNotNull((Object)caseDef);
        Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
        Assert.assertEquals((long)3L, (long)caseDef.getAdHocFragments().size());
        Map mappedFragments = this.mapAdHocFragments(caseDef.getAdHocFragments());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Hello2"));
        Assert.assertEquals((Object)"HumanTaskNode", (Object)((AdHocFragment)mappedFragments.get("Hello2")).getType());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Milestone1"));
        Assert.assertEquals((Object)"MilestoneNode", (Object)((AdHocFragment)mappedFragments.get("Milestone1")).getType());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Milestone2"));
        Assert.assertEquals((Object)"MilestoneNode", (Object)((AdHocFragment)mappedFragments.get("Milestone2")).getType());
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"HR-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"HR-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            this.caseService.assignToCaseRole("HR-0000000001", "contact", (OrganizationalEntity)new UserImpl("mary"));
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            this.assertTask((TaskSummary)tasks.get(0), "john", "Hello1", Status.Reserved);
            this.caseService.addDynamicTask("HR-0000000001", this.caseService.newHumanTaskSpec("Second task", "another test", "contact", null, new HashMap()));
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            this.assertTask((TaskSummary)tasks.get(0), "mary", "Second task", Status.Reserved);
            this.caseService.assignToCaseRole("HR-0000000001", "contact", (OrganizationalEntity)new UserImpl("john"));
            this.caseService.addDynamicTask("HR-0000000001", this.caseService.newHumanTaskSpec("Third task", "another test", "contact", null, new HashMap()));
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)2L, (long)tasks.size());
            this.assertTask((TaskSummary)tasks.get(0), null, "Third task", Status.Ready);
            this.assertTask((TaskSummary)tasks.get(1), "mary", "Second task", Status.Reserved);
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseWithStageAutoStartNodes() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)2L, (long)tasks.size());
            this.assertTask((TaskSummary)tasks.get(0), "john", "Ask for input", Status.Reserved);
            this.assertTask((TaskSummary)tasks.get(1), "john", "Missing data", Status.Reserved);
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseWithComments() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Collection caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)0L, (long)caseComments.size());
            String commentId = this.caseService.addCaseComment("CASE-0000000001", "poul", "just a tiny comment", new String[0]);
            Assert.assertNotNull((Object)commentId);
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)1L, (long)caseComments.size());
            CommentInstance comment = (CommentInstance)caseComments.iterator().next();
            this.assertComment(comment, "poul", "just a tiny comment");
            Assert.assertEquals((Object)commentId, (Object)comment.getId());
            this.caseService.updateCaseComment("CASE-0000000001", comment.getId(), comment.getAuthor(), "Updated " + comment.getComment(), new String[0]);
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)1L, (long)caseComments.size());
            comment = (CommentInstance)caseComments.iterator().next();
            this.assertComment(comment, "poul", "Updated just a tiny comment");
            this.caseService.addCaseComment("CASE-0000000001", "mary", "another comment", new String[0]);
            this.caseService.addCaseComment("CASE-0000000001", "john", "third comment", new String[0]);
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)3L, (long)caseComments.size());
            Iterator it = caseComments.iterator();
            this.assertComment((CommentInstance)it.next(), "poul", "Updated just a tiny comment");
            this.assertComment((CommentInstance)it.next(), "mary", "another comment");
            this.assertComment((CommentInstance)it.next(), "john", "third comment");
            caseComments = this.caseService.getCaseComments("CASE-0000000001", CommentSortBy.Author, new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)3L, (long)caseComments.size());
            it = caseComments.iterator();
            this.assertComment((CommentInstance)it.next(), "john", "third comment");
            this.assertComment((CommentInstance)it.next(), "mary", "another comment");
            this.assertComment((CommentInstance)it.next(), "poul", "Updated just a tiny comment");
            this.caseService.removeCaseComment("CASE-0000000001", comment.getId());
            caseComments = this.caseService.getCaseComments("CASE-0000000001", CommentSortBy.Author, new QueryContext());
            Assert.assertEquals((long)2L, (long)caseComments.size());
            it = caseComments.iterator();
            this.assertComment((CommentInstance)it.next(), "john", "third comment");
            this.assertComment((CommentInstance)it.next(), "mary", "another comment");
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseWithCommentsPagination() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            for (int i = 0; i < 55; ++i) {
                this.caseService.addCaseComment("CASE-0000000001", "anna", "comment" + i, new String[0]);
            }
            int pageSize = 20;
            int firstPageOffset = 0 * pageSize;
            Collection firstPage = this.caseService.getCaseComments("CASE-0000000001", new QueryContext(Integer.valueOf(firstPageOffset), Integer.valueOf(pageSize)));
            Assert.assertNotNull((Object)firstPage);
            Assert.assertEquals((long)20L, (long)firstPage.size());
            Iterator firstPageIter = firstPage.iterator();
            int i = 0;
            while (firstPageIter.hasNext()) {
                this.assertComment((CommentInstance)firstPageIter.next(), "anna", "comment" + i);
                ++i;
            }
            int secondPageOffset = 1 * pageSize;
            Collection secondPage = this.caseService.getCaseComments("CASE-0000000001", new QueryContext(Integer.valueOf(secondPageOffset), Integer.valueOf(pageSize)));
            Assert.assertNotNull((Object)secondPage);
            Assert.assertEquals((long)20L, (long)secondPage.size());
            Iterator secondPageIter = secondPage.iterator();
            int i2 = 20;
            while (secondPageIter.hasNext()) {
                this.assertComment((CommentInstance)secondPageIter.next(), "anna", "comment" + i2);
                ++i2;
            }
            int thirdPageOffset = 2 * pageSize;
            Collection thirdPage = this.caseService.getCaseComments("CASE-0000000001", new QueryContext(Integer.valueOf(thirdPageOffset), Integer.valueOf(pageSize)));
            Assert.assertNotNull((Object)thirdPage);
            Assert.assertEquals((long)15L, (long)thirdPage.size());
            Iterator thirdPageIter = thirdPage.iterator();
            int i3 = 40;
            while (thirdPageIter.hasNext()) {
                this.assertComment((CommentInstance)thirdPageIter.next(), "anna", "comment" + i3);
                ++i3;
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateNotExistingCaseComment() {
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            this.caseService.updateCaseComment("CASE-0000000001", "not-existing-comment", "poul", "just a tiny comment", new String[0]);
            Assertions.fail((String)"Updating non-existent case comment should throw CaseCommentNotFoundException.");
        }
        catch (CaseCommentNotFoundException caseCommentNotFoundException) {
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveNotExistingCaseComment() {
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            this.caseService.removeCaseComment("CASE-0000000001", "not-existing-comment");
            Assertions.fail((String)"Removing non-existent case comment should throw CaseCommentNotFoundException.");
        }
        catch (CaseCommentNotFoundException caseCommentNotFoundException) {
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseWithStageAndAdHocFragments() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserStageAdhocCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserStageAdhocCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            this.assertCaseInstance(caseId, "my first case");
            Collection availableFragments = this.caseRuntimeDataService.getAdHocFragmentsForCase(caseId);
            Assert.assertEquals((long)2L, (long)availableFragments.size());
            Map mapped = this.mapAdHocFragments(availableFragments);
            Assert.assertEquals((Object)"HumanTaskNode", (Object)((AdHocFragment)mapped.get("Adhoc 1")).getType());
            Assert.assertEquals((Object)"HumanTaskNode", (Object)((AdHocFragment)mapped.get("Adhoc 2")).getType());
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            this.assertTask((TaskSummary)tasks.get(0), "john", "Initial step", Status.Reserved);
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", null);
            availableFragments = this.caseRuntimeDataService.getAdHocFragmentsForCase(caseId);
            Assert.assertEquals((long)4L, (long)availableFragments.size());
            mapped = this.mapAdHocFragments(availableFragments);
            Assert.assertEquals((Object)"HumanTaskNode", (Object)((AdHocFragment)mapped.get("Adhoc 1")).getType());
            Assert.assertEquals((Object)"HumanTaskNode", (Object)((AdHocFragment)mapped.get("Adhoc 2")).getType());
            Assert.assertEquals((Object)"HumanTaskNode", (Object)((AdHocFragment)mapped.get("First")).getType());
            Assert.assertEquals((Object)"HumanTaskNode", (Object)((AdHocFragment)mapped.get("Second")).getType());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartThenReopenEmptyCase() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((Object)"my first case", (Object)cInstance.getCaseDescription());
            long firstCaseProcessInstanceId = ((CaseInstanceImpl)cInstance).getProcessInstanceId();
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            this.caseService.reopenCase(caseId, this.deploymentUnit.getIdentifier(), "EmptyCase");
            cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((Object)"my first case", (Object)cInstance.getCaseDescription());
            long secondCaseProcessInstanceId = ((CaseInstanceImpl)cInstance).getProcessInstanceId();
            Assert.assertTrue((secondCaseProcessInstanceId > firstCaseProcessInstanceId ? 1 : 0) != 0);
            this.caseService.destroyCase(caseId);
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartThenReopenEmptyCaseUpdateDescription() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase");
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((Object)"#{name}", (Object)cInstance.getCaseDescription());
            long firstCaseProcessInstanceId = ((CaseInstanceImpl)cInstance).getProcessInstanceId();
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("name", "my first case");
            this.caseService.reopenCase(caseId, this.deploymentUnit.getIdentifier(), "EmptyCase", data);
            cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((Object)"my first case", (Object)cInstance.getCaseDescription());
            long secondCaseProcessInstanceId = ((CaseInstanceImpl)cInstance).getProcessInstanceId();
            Assert.assertTrue((secondCaseProcessInstanceId > firstCaseProcessInstanceId ? 1 : 0) != 0);
            this.caseService.destroyCase(caseId);
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartThenReopenActiveCase() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((Object)"my first case", (Object)cInstance.getCaseDescription());
            try {
                this.caseService.reopenCase(caseId, this.deploymentUnit.getIdentifier(), "EmptyCase");
                Assertions.fail((String)"Not allowed to reopen active case");
            }
            catch (CaseActiveException caseActiveException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartThenReopenDestroyedCase() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((Object)"my first case", (Object)cInstance.getCaseDescription());
            this.caseService.destroyCase(caseId);
            try {
                this.caseService.reopenCase(caseId, this.deploymentUnit.getIdentifier(), "EmptyCase");
                Assertions.fail((String)"Not allowed to reopen destroyed case");
            }
            catch (CaseNotFoundException caseNotFoundException) {
                // empty catch block
            }
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartThenReopenEmptyCaseUpdateData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((Object)"my first case", (Object)cInstance.getCaseDescription());
            long firstCaseProcessInstanceId = ((CaseInstanceImpl)cInstance).getProcessInstanceId();
            Collection caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertEquals((long)1L, (long)caseFileItems.size());
            CaseFileItem fileItem = (CaseFileItem)caseFileItems.iterator().next();
            Assert.assertNotNull((Object)fileItem);
            Assert.assertEquals((Object)"name", (Object)fileItem.getName());
            Assert.assertEquals((Object)"my first case", (Object)fileItem.getValue());
            Collection vars = this.runtimeDataService.getVariablesCurrentState(((CaseInstanceImpl)cInstance).getProcessInstanceId().longValue());
            Assert.assertNotNull((Object)vars);
            Assert.assertEquals((long)3L, (long)vars.size());
            Map<String, Object> mappedVars = vars.stream().collect(Collectors.toMap(v -> v.getVariableId(), v -> v.getNewValue()));
            Assert.assertEquals((Object)"my first case", (Object)mappedVars.get("caseFile_name"));
            Assert.assertEquals((Object)"CASE-0000000001", (Object)mappedVars.get("CaseId"));
            Assert.assertEquals((Object)"john", (Object)mappedVars.get("initiator"));
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            data = new HashMap();
            data.put("name", "my first case reopened");
            this.caseService.reopenCase(caseId, this.deploymentUnit.getIdentifier(), "EmptyCase", data);
            cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((Object)"my first case reopened", (Object)cInstance.getCaseDescription());
            long secondCaseProcessInstanceId = ((CaseInstanceImpl)cInstance).getProcessInstanceId();
            Assert.assertTrue((secondCaseProcessInstanceId > firstCaseProcessInstanceId ? 1 : 0) != 0);
            caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertEquals((long)1L, (long)caseFileItems.size());
            fileItem = (CaseFileItem)caseFileItems.iterator().next();
            Assert.assertNotNull((Object)fileItem);
            Assert.assertEquals((Object)"name", (Object)fileItem.getName());
            Assert.assertEquals((Object)"my first case reopened", (Object)fileItem.getValue());
            vars = this.runtimeDataService.getVariablesCurrentState(secondCaseProcessInstanceId);
            Assert.assertNotNull((Object)vars);
            Assert.assertEquals((long)3L, (long)vars.size());
            mappedVars = vars.stream().collect(Collectors.toMap(v -> v.getVariableId(), v -> v.getNewValue()));
            Assert.assertEquals((Object)"my first case reopened", (Object)mappedVars.get("caseFile_name"));
            Assert.assertEquals((Object)"CASE-0000000001", (Object)mappedVars.get("CaseId"));
            Assert.assertEquals((Object)"john", (Object)mappedVars.get("initiator"));
            this.caseService.addDataToCaseFile(caseId, "name", (Object)"my first case updated", new String[0]);
            caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertEquals((long)1L, (long)caseFileItems.size());
            fileItem = (CaseFileItem)caseFileItems.iterator().next();
            Assert.assertNotNull((Object)fileItem);
            Assert.assertEquals((Object)"name", (Object)fileItem.getName());
            Assert.assertEquals((Object)"my first case updated", (Object)fileItem.getValue());
            vars = this.runtimeDataService.getVariablesCurrentState(secondCaseProcessInstanceId);
            Assert.assertNotNull((Object)vars);
            Assert.assertEquals((long)3L, (long)vars.size());
            mappedVars = vars.stream().collect(Collectors.toMap(v -> v.getVariableId(), v -> v.getNewValue()));
            Assert.assertEquals((Object)"my first case updated", (Object)mappedVars.get("caseFile_name"));
            Assert.assertEquals((Object)"CASE-0000000001", (Object)mappedVars.get("CaseId"));
            Assert.assertEquals((Object)"john", (Object)mappedVars.get("initiator"));
            this.caseService.destroyCase(caseId);
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartScriptRoleAssignmentCase() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "ScriptRoleAssignmentCase");
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"HR-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            TaskSummary task = (TaskSummary)tasks.get(0);
            Assert.assertEquals((Object)"User Task 1", (Object)task.getName());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseWithoutStartNode() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "NoStartNodeAdhocCase");
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Collection activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(((CaseInstanceImpl)cInstance).getProcessInstanceId().longValue(), new QueryContext());
            Assert.assertNotNull((Object)activeNodes);
            Assert.assertEquals((long)1L, (long)activeNodes.size());
            NodeInstanceDesc active = (NodeInstanceDesc)activeNodes.iterator().next();
            Assert.assertEquals((Object)"Initial step", (Object)active.getName());
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            TaskSummary task = (TaskSummary)tasks.get(0);
            this.userTaskService.completeAutoProgress(task.getId(), "john", new HashMap());
            activeNodes = this.runtimeDataService.getProcessInstanceHistoryActive(((CaseInstanceImpl)cInstance).getProcessInstanceId().longValue(), new QueryContext());
            Assert.assertNotNull((Object)activeNodes);
            Assert.assertEquals((long)1L, (long)activeNodes.size());
            active = (NodeInstanceDesc)activeNodes.iterator().next();
            Assert.assertEquals((Object)"stage", (Object)active.getName());
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseViaProcessService() {
        String caseId = "CASE-0000000001";
        CorrelationKey correlationKey = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey(caseId);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "my case via process service");
        Long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "EmptyCase", correlationKey, params);
        Assert.assertNotNull((Object)processInstanceId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((Object)caseId, (Object)cInstance.getCaseId());
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseViaProcessServiceWithoutCorrelationKey() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "my case via process service");
        Long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "EmptyCase", params);
        Assert.assertNotNull((Object)processInstanceId);
        String caseId = processInstanceId.toString();
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((Object)caseId, (Object)cInstance.getCaseId());
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseViaProcessServiceWithoutCorrelationKeyWithMilestones() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "my case via process service");
        Long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "UserTaskCase", params);
        Assert.assertNotNull((Object)processInstanceId);
        String caseId = processInstanceId.toString();
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((Object)caseId, (Object)cInstance.getCaseId());
            Collection milestones = this.caseRuntimeDataService.getCaseInstanceMilestones(caseId, true, new QueryContext());
            Assert.assertNotNull((Object)milestones);
            Assert.assertEquals((long)0L, (long)milestones.size());
            this.caseService.triggerAdHocFragment(caseId, "Milestone1", null);
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones(caseId, true, new QueryContext());
            Assert.assertNotNull((Object)milestones);
            Assert.assertEquals((long)1L, (long)milestones.size());
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartThenCancelRetrieveCaseFile() {
        try {
            this.caseService.getCaseFileInstance("CASE-0000000001");
            Assertions.fail((String)"There is no case yet started");
        }
        catch (CaseNotFoundException caseNotFoundException) {
            // empty catch block
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((Object)"my first case", (Object)cInstance.getCaseDescription());
            CaseFileInstance caseFileFromCase = this.caseService.getCaseFileInstance("CASE-0000000001");
            Assert.assertNotNull((Object)caseFileFromCase);
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseFileFromCase = this.caseService.getCaseFileInstance("CASE-0000000001");
            Assert.assertNotNull((Object)caseFileFromCase);
            this.caseService.destroyCase(caseId);
            CaseInstance caseInstance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)caseInstance.getStatus()).isIn(new Object[]{CaseStatus.CLOSED.getId(), CaseStatus.CANCELLED.getId()});
            caseId = null;
            try {
                this.caseService.getCaseFileInstance("CASE-0000000001");
                Assertions.fail((String)"There is no case yet started");
            }
            catch (CaseNotFoundException caseNotFoundException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserTaskToCaseWithStageComplete() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            CaseDefinition caseDef = this.caseRuntimeDataService.getCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCase");
            Assert.assertNotNull((Object)caseDef);
            Assert.assertEquals((long)1L, (long)caseDef.getCaseStages().size());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
            Collection activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
            Assert.assertNotNull((Object)activeStages);
            Assert.assertEquals((long)1L, (long)activeStages.size());
            this.caseService.addDataToCaseFile(caseId, "dataComplete", (Object)true, new String[0]);
            activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
            Assert.assertNotNull((Object)activeStages);
            Assert.assertEquals((long)0L, (long)activeStages.size());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseWithConditionalEvent() {
        HashMap data = new HashMap();
        data.put("Documents", new ArrayList());
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "CaseFileConditionalEvent", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "CaseFileConditionalEvent", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseWithConditionalEventCompleteCase() {
        ArrayList<String> docs = new ArrayList<String>();
        docs.add("First doc");
        HashMap<String, ArrayList<String>> data = new HashMap<String, ArrayList<String>>();
        data.put("Documents", docs);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "CaseFileConditionalEvent", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "CaseFileConditionalEvent", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CLOSED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseRolesWithQueries() {
        HashMap<String, Object> roleAssignments = new HashMap<String, Object>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("contact", new GroupImpl("HR"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "description");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"HR-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"HR-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((long)CaseStatus.OPEN.getId(), (long)cInstance.getStatus().intValue());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Collection instances = this.caseRuntimeDataService.getCaseInstancesAnyRole(null, new QueryContext());
            Assert.assertNotNull((Object)instances);
            Assert.assertEquals((long)0L, (long)instances.size());
            List<CaseStatus> status = Arrays.asList(CaseStatus.CANCELLED);
            instances = this.caseRuntimeDataService.getCaseInstancesAnyRole(status, new QueryContext());
            Assert.assertNotNull((Object)instances);
            Assert.assertFalse((String)"Opened case was returned when searching for cancelled case instances.", (boolean)instances.stream().anyMatch(n -> n.getCaseId().equals(caseId)));
            status = Arrays.asList(CaseStatus.OPEN);
            instances = this.caseRuntimeDataService.getCaseInstancesAnyRole(status, new QueryContext());
            Assert.assertNotNull((Object)instances);
            Assert.assertEquals((long)1L, (long)instances.size());
            instances = this.caseRuntimeDataService.getCaseInstancesByRole(null, status, new QueryContext());
            Assert.assertNotNull((Object)instances);
            Assert.assertEquals((long)0L, (long)instances.size());
            instances = this.caseRuntimeDataService.getCaseInstancesByRole("owner", status, new QueryContext());
            Assert.assertNotNull((Object)instances);
            Assert.assertEquals((long)1L, (long)instances.size());
            this.identityProvider.setName("mary");
            instances = this.caseRuntimeDataService.getCaseInstancesByRole("owner", status, new QueryContext());
            Assert.assertNotNull((Object)instances);
            Assert.assertEquals((String)"Mary shouldn't be owner of any opened case instance.", (long)0L, (long)instances.size());
            this.identityProvider.setRoles(Arrays.asList("HR"));
            instances = this.caseRuntimeDataService.getCaseInstancesByRole("contact", status, new QueryContext());
            Assert.assertNotNull((Object)instances);
            Assert.assertEquals((long)1L, (long)instances.size());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            this.identityProvider.setName("john");
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseAuthorization() {
        HashMap<String, Object> roleAssignments = new HashMap<String, Object>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("contact", new GroupImpl("HR"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "description");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"HR-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"HR-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            this.identityProvider.setName("mary");
            try {
                this.caseService.cancelCase(caseId);
                Assertions.fail((String)"Mary is not owner of the case so should not be allowed to cancel the case");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                this.caseService.destroyCase(caseId);
                Assertions.fail((String)"Mary is not owner of the case so should not be allowed to destroy the case");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.identityProvider.setName("john");
            this.caseService.cancelCase(caseId);
            this.identityProvider.setName("mary");
            try {
                this.caseService.reopenCase(caseId, this.deploymentUnit.getIdentifier(), "UserTaskCase");
                Assertions.fail((String)"Mary is not owner of the case so should not be allowed to reopen the case");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.identityProvider.setName("john");
            this.caseService.reopenCase(caseId, this.deploymentUnit.getIdentifier(), "UserTaskCase");
            cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"HR-0000000001", (Object)cInstance.getCaseId());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseAuthorizationImplicitOwner() {
        String expectedCaseId = "UniqueID-0000000001";
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("patient", new UserImpl("john"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "description");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "CaseWithRolesDefinition", data, roleAssignments);
        this.identityProvider.setName("mary");
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "CaseWithRolesDefinition", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)expectedCaseId, (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)expectedCaseId, (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)"mary", (Object)cInstance.getOwner());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            this.identityProvider.setName("john");
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(expectedCaseId, "john", Arrays.asList(Status.Reserved), new QueryContext());
            Assert.assertEquals((long)1L, (long)tasks.size());
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", null);
            this.identityProvider.setName("mary");
            this.caseService.triggerAdHocFragment(expectedCaseId, "task2", null);
            tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(expectedCaseId, "mary", Arrays.asList(Status.Reserved), new QueryContext());
            Assert.assertEquals((long)1L, (long)tasks.size());
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "mary", null);
            this.caseService.triggerAdHocFragment(expectedCaseId, "task3", null);
            tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(expectedCaseId, "mary", Arrays.asList(Status.Ready), new QueryContext());
            Assert.assertEquals((long)1L, (long)tasks.size());
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "mary", null);
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.identityProvider.setName("mary");
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTriggerNotExistingAdHocFragment() {
        String expectedCaseId = "UniqueID-0000000001";
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("patient", new UserImpl("john"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "description");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "CaseWithRolesDefinition", data, roleAssignments);
        this.identityProvider.setName("mary");
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "CaseWithRolesDefinition", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)expectedCaseId, (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)expectedCaseId, (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            this.identityProvider.setName("john");
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(expectedCaseId, "john", Arrays.asList(Status.Reserved), new QueryContext());
            Assert.assertEquals((long)1L, (long)tasks.size());
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", null);
            this.identityProvider.setName("mary");
            try {
                this.caseService.triggerAdHocFragment(expectedCaseId, "not existing", null);
                Assertions.fail((String)"There is no ad hoc fragment with name 'not existing'");
            }
            catch (AdHocFragmentNotFoundException adHocFragmentNotFoundException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.identityProvider.setName("mary");
                this.caseService.cancelCase(caseId);
            }
        }
    }

    @Test
    public void testTriggerAdHocTasksFromCurrentAndNextStage() {
        this.identityProvider.setName("john");
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("customData", "none");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "CaseWithTwoStagesConditions", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "CaseWithTwoStagesConditions", caseFile);
        Assert.assertNotNull((Object)caseId);
        try {
            Collection stages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, false, null);
            ((IterableAssert)Assertions.assertThat((Iterable)stages).isNotNull()).hasSize(2);
            Iterator iterator = stages.iterator();
            CaseStageInstance stage1 = (CaseStageInstance)iterator.next();
            Assertions.assertThat((String)stage1.getName()).isEqualTo((Object)"Stage One");
            Assertions.assertThat((Comparable)stage1.getStatus()).isEqualTo((Object)StageStatus.Active);
            CaseStageInstance stage2 = (CaseStageInstance)iterator.next();
            Assertions.assertThat((String)stage2.getName()).isEqualTo((Object)"Stage Two");
            Assertions.assertThat((Comparable)stage2.getStatus()).isEqualTo((Object)StageStatus.Available);
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            ((ListAssert)Assertions.assertThat((List)tasks).isNotNull()).isEmpty();
            this.caseService.triggerAdHocFragment(caseId, "Task 1", null);
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            ((ListAssert)Assertions.assertThat((List)tasks).isNotNull()).hasSize(1);
            this.assertTask((TaskSummary)tasks.get(0), "john", "Task 1", Status.Reserved);
            this.caseService.triggerAdHocFragment(caseId, "Task 2", null);
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            ((ListAssert)Assertions.assertThat((List)tasks).isNotNull()).hasSize(1);
            this.assertTask((TaskSummary)tasks.get(0), "john", "Task 1", Status.Reserved);
            Map<String, String> params = Collections.singletonMap("myData", "nextStage");
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", params);
            stages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, false, null);
            ((IterableAssert)Assertions.assertThat((Iterable)stages).isNotNull()).hasSize(2);
            iterator = stages.iterator();
            stage1 = (CaseStageInstance)iterator.next();
            Assertions.assertThat((String)stage1.getName()).isEqualTo((Object)"Stage One");
            Assertions.assertThat((Comparable)stage1.getStatus()).isEqualTo((Object)StageStatus.Completed);
            stage2 = (CaseStageInstance)iterator.next();
            Assertions.assertThat((String)stage2.getName()).isEqualTo((Object)"Stage Two");
            Assertions.assertThat((Comparable)stage2.getStatus()).isEqualTo((Object)StageStatus.Active);
            this.caseService.triggerAdHocFragment(caseId, "Task 2", null);
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            ((ListAssert)Assertions.assertThat((List)tasks).isNotNull()).hasSize(1);
            this.assertTask((TaskSummary)tasks.get(0), "john", "Task 2", Status.Reserved);
            this.caseService.triggerAdHocFragment(caseId, "Task 1", null);
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            ((ListAssert)Assertions.assertThat((List)tasks).isNotNull()).hasSize(1);
            this.assertTask((TaskSummary)tasks.get(0), "john", "Task 2", Status.Reserved);
            params = Collections.singletonMap("myData", "none");
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", params);
            CaseInstance caseInstance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)caseInstance.getStatus()).isIn(new Object[]{CaseStatus.CLOSED.getId(), CaseStatus.CANCELLED.getId()});
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            this.caseService.cancelCase(caseId);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTriggerMultipleAdHocTasks() {
        this.identityProvider.setName("john");
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("customData", "none");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "CaseWithTwoStagesConditions", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "CaseWithTwoStagesConditions", caseFile);
        Assertions.assertThat((String)caseId).isNotNull();
        try {
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            ((ListAssert)Assertions.assertThat((List)tasks).isNotNull()).isEmpty();
            this.caseService.triggerAdHocFragment(caseId, "Task 1", null);
            tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            ((ListAssert)Assertions.assertThat((List)tasks).isNotNull()).hasSize(1);
            Assertions.assertThat((List)tasks).extracting(QuickTaskSummary::getName).containsOnly((Object[])new String[]{"Task 1"});
            this.caseService.triggerAdHocFragment(caseId, "Task 1", null);
            tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            ((ListAssert)Assertions.assertThat((List)tasks).isNotNull()).hasSize(2);
            Assertions.assertThat((List)tasks).extracting(QuickTaskSummary::getName).containsOnly((Object[])new String[]{"Task 1"});
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            this.caseService.cancelCase(caseId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseUsingLoggedInOwner() {
        this.identityProvider.setName("mary");
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase");
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"mary", (Object)cInstance.getOwner());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            String initiator = (String)this.processService.getProcessInstanceVariable(((CaseInstanceImpl)cInstance).getProcessInstanceId(), "initiator");
            Assert.assertEquals((Object)"mary", (Object)initiator);
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseChangeOwner() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data, new HashMap());
        this.identityProvider.setName("mary");
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"mary", (Object)cInstance.getOwner());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            String initiator = (String)this.processService.getProcessInstanceVariable(((CaseInstanceImpl)cInstance).getProcessInstanceId(), "initiator");
            Assert.assertEquals((Object)"mary", (Object)initiator);
            this.caseService.removeFromCaseRole(caseId, "owner", (OrganizationalEntity)new UserImpl("mary"));
            this.caseService.assignToCaseRole(caseId, "owner", (OrganizationalEntity)new UserImpl("john"));
            this.identityProvider.setName("john");
            cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"john", (Object)cInstance.getOwner());
            initiator = (String)this.processService.getProcessInstanceVariable(((CaseInstanceImpl)cInstance).getProcessInstanceId(), "initiator");
            Assert.assertEquals((Object)"mary", (Object)initiator);
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseUsingCaseFileOwner() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data, roleAssignments);
        this.identityProvider.setName("mary");
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        this.identityProvider.setName("john");
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"john", (Object)cInstance.getOwner());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            String initiator = (String)this.processService.getProcessInstanceVariable(((CaseInstanceImpl)cInstance).getProcessInstanceId(), "initiator");
            Assert.assertEquals((Object)"mary", (Object)initiator);
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseUsingCaseFileOwnerAsLoggedInUser() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("mary"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data, roleAssignments);
        this.identityProvider.setName("mary");
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"mary", (Object)cInstance.getOwner());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            String initiator = (String)this.processService.getProcessInstanceVariable(((CaseInstanceImpl)cInstance).getProcessInstanceId(), "initiator");
            Assert.assertEquals((Object)"mary", (Object)initiator);
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserTaskToCaseWithStageCompleteCaseDataItem() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Collection caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertEquals((long)0L, (long)caseFileItems.size());
            Collection activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
            Assert.assertNotNull((Object)activeStages);
            Assert.assertEquals((long)1L, (long)activeStages.size());
            this.caseService.addDataToCaseFile(caseId, "dataComplete", (Object)true, new String[0]);
            activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
            Assert.assertNotNull((Object)activeStages);
            Assert.assertEquals((long)0L, (long)activeStages.size());
            caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertEquals((long)1L, (long)caseFileItems.size());
            CaseFileItem dataItem = (CaseFileItem)caseFileItems.iterator().next();
            Assert.assertNotNull((Object)dataItem);
            Assert.assertEquals((Object)caseId, (Object)dataItem.getCaseId());
            Assert.assertEquals((Object)"dataComplete", (Object)dataItem.getName());
            Assert.assertEquals((Object)"true", (Object)dataItem.getValue());
            Assert.assertEquals((Object)Boolean.class.getName(), (Object)dataItem.getType());
            Assert.assertEquals((Object)this.identityProvider.getName(), (Object)dataItem.getLastModifiedBy());
            Assert.assertNotNull((Object)dataItem.getLastModified());
            this.caseService.addDataToCaseFile(caseId, "anotherDataItem", (Object)"first version", new String[0]);
            caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItemsByType(caseId, Collections.singletonList("boolean"), new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertEquals((long)0L, (long)caseFileItems.size());
            caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItemsByType(caseId, Collections.singletonList(Boolean.class.getName()), new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertEquals((long)1L, (long)caseFileItems.size());
            dataItem = (CaseFileItem)caseFileItems.iterator().next();
            Assert.assertNotNull((Object)dataItem);
            Assert.assertEquals((Object)caseId, (Object)dataItem.getCaseId());
            Assert.assertEquals((Object)"dataComplete", (Object)dataItem.getName());
            caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItemsByType(caseId, Collections.singletonList(String.class.getName()), new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertEquals((long)1L, (long)caseFileItems.size());
            dataItem = (CaseFileItem)caseFileItems.iterator().next();
            Assert.assertNotNull((Object)dataItem);
            Assert.assertEquals((Object)caseId, (Object)dataItem.getCaseId());
            Assert.assertEquals((Object)"anotherDataItem", (Object)dataItem.getName());
            caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertEquals((long)2L, (long)caseFileItems.size());
            dataItem = (CaseFileItem)caseFileItems.iterator().next();
            Assert.assertNotNull((Object)dataItem);
            Assert.assertEquals((Object)caseId, (Object)dataItem.getCaseId());
            Assert.assertEquals((Object)"anotherDataItem", (Object)dataItem.getName());
            Assert.assertEquals((Object)"first version", (Object)dataItem.getValue());
            Assert.assertEquals((Object)String.class.getName(), (Object)dataItem.getType());
            Assert.assertEquals((Object)this.identityProvider.getName(), (Object)dataItem.getLastModifiedBy());
            Assert.assertNotNull((Object)dataItem.getLastModified());
            this.caseService.addDataToCaseFile(caseId, "anotherDataItem", (Object)"second version", new String[0]);
            caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItemsByType(caseId, Arrays.asList(Boolean.class.getName(), String.class.getName()), new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertEquals((long)2L, (long)caseFileItems.size());
            caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItemsByName(caseId, Arrays.asList("anotherDataItem", "dataComplete"), new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertEquals((long)2L, (long)caseFileItems.size());
            Iterator it = caseFileItems.iterator();
            dataItem = (CaseFileItem)it.next();
            Assert.assertNotNull((Object)dataItem);
            Assert.assertEquals((Object)caseId, (Object)dataItem.getCaseId());
            Assert.assertEquals((Object)"anotherDataItem", (Object)dataItem.getName());
            dataItem = (CaseFileItem)it.next();
            Assert.assertNotNull((Object)dataItem);
            Assert.assertEquals((Object)caseId, (Object)dataItem.getCaseId());
            Assert.assertEquals((Object)"dataComplete", (Object)dataItem.getName());
            caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertEquals((long)2L, (long)caseFileItems.size());
            dataItem = (CaseFileItem)caseFileItems.iterator().next();
            Assert.assertNotNull((Object)dataItem);
            Assert.assertEquals((Object)caseId, (Object)dataItem.getCaseId());
            Assert.assertEquals((Object)"anotherDataItem", (Object)dataItem.getName());
            Assert.assertEquals((Object)"second version", (Object)dataItem.getValue());
            Assert.assertEquals((Object)String.class.getName(), (Object)dataItem.getType());
            Assert.assertEquals((Object)this.identityProvider.getName(), (Object)dataItem.getLastModifiedBy());
            Assert.assertNotNull((Object)dataItem.getLastModified());
            this.caseService.removeDataFromCaseFile(caseId, "anotherDataItem");
            caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertEquals((long)1L, (long)caseFileItems.size());
            caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItemsByName(caseId, Collections.singletonList("anotherDataItem"), new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertTrue((boolean)caseFileItems.isEmpty());
            caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItemsByType(caseId, Collections.singletonList(String.class.getName()), new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertTrue((boolean)caseFileItems.isEmpty());
            this.identityProvider.setName("mary");
            caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertEquals((long)0L, (long)caseFileItems.size());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            this.identityProvider.setName("john");
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserTaskToCaseSearchByCaseFileData() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            this.caseService.addDataToCaseFile(caseId, "dataComplete", (Object)true, new String[0]);
            Collection byCaseData = this.caseRuntimeDataService.getCaseInstancesByDataItem("dataComplete", Arrays.asList(CaseStatus.OPEN), new QueryContext());
            Assert.assertNotNull((Object)byCaseData);
            Assert.assertEquals((long)1L, (long)byCaseData.size());
            byCaseData = this.caseRuntimeDataService.getCaseInstancesByDataItemAndValue("dataComplete", "false", Arrays.asList(CaseStatus.OPEN), new QueryContext());
            Assert.assertNotNull((Object)byCaseData);
            Assert.assertEquals((long)0L, (long)byCaseData.size());
            byCaseData = this.caseRuntimeDataService.getCaseInstancesByDataItemAndValue("dataComplete", "true", Arrays.asList(CaseStatus.OPEN), new QueryContext());
            Assert.assertNotNull((Object)byCaseData);
            Assert.assertEquals((long)1L, (long)byCaseData.size());
            this.identityProvider.setName("mary");
            byCaseData = this.caseRuntimeDataService.getCaseInstancesByDataItem("dataComplete", Arrays.asList(CaseStatus.OPEN), new QueryContext());
            Assert.assertNotNull((Object)byCaseData);
            Assert.assertEquals((long)0L, (long)byCaseData.size());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            this.identityProvider.setName("john");
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserTaskCaseSearchByInitialCaseFileData() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("dataComplete", true);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Collection byCaseData = this.caseRuntimeDataService.getCaseInstancesByDataItem("dataComplete", Arrays.asList(CaseStatus.OPEN), new QueryContext());
            Assert.assertNotNull((Object)byCaseData);
            Assert.assertEquals((long)1L, (long)byCaseData.size());
            byCaseData = this.caseRuntimeDataService.getCaseInstancesByDataItemAndValue("dataComplete", "false", Arrays.asList(CaseStatus.OPEN), new QueryContext());
            Assert.assertNotNull((Object)byCaseData);
            Assert.assertEquals((long)0L, (long)byCaseData.size());
            byCaseData = this.caseRuntimeDataService.getCaseInstancesByDataItemAndValue("dataComplete", "true", Arrays.asList(CaseStatus.OPEN), new QueryContext());
            Assert.assertNotNull((Object)byCaseData);
            Assert.assertEquals((long)1L, (long)byCaseData.size());
            this.identityProvider.setName("mary");
            byCaseData = this.caseRuntimeDataService.getCaseInstancesByDataItem("dataComplete", Arrays.asList(CaseStatus.OPEN), new QueryContext());
            Assert.assertNotNull((Object)byCaseData);
            Assert.assertEquals((long)0L, (long)byCaseData.size());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            this.identityProvider.setName("john");
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseRolesCardinality() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "description");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskCase", caseFile);
        try {
            this.caseService.assignToCaseRole(caseId, "contact", (OrganizationalEntity)new UserImpl("mary"));
            this.caseService.assignToCaseRole(caseId, "contact", (OrganizationalEntity)new UserImpl("steve"));
            Throwable error = Assertions.catchThrowable(() -> this.caseService.assignToCaseRole(caseId, "contact", (OrganizationalEntity)new UserImpl("jack")));
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot add more users for role contact, maximum cardinality 2 already reached");
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    @Test
    public void testStartEmptyCaseAndClose() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase");
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            this.caseService.closeCase(caseId, "not needed any more");
            cInstance = this.caseRuntimeDataService.getCaseInstanceById(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((Object)"not needed any more", (Object)cInstance.getCompletionMessage());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddSubprocessToEmptyCaseAndClose() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            HashMap parameters = new HashMap();
            this.caseService.addDynamicSubprocess("CASE-0000000001", "DataVerification", parameters);
            Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)2L, (long)caseProcessInstances.size());
            this.caseService.closeCase(caseId, "not needed any more");
            cInstance = this.caseRuntimeDataService.getCaseInstanceById(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Assert.assertEquals((Object)"not needed any more", (Object)cInstance.getCompletionMessage());
            caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, Arrays.asList(2), new QueryContext());
            Assert.assertNotNull((Object)caseProcessInstances);
            Assert.assertEquals((long)2L, (long)caseProcessInstances.size());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartExpressionCaseWithCaseFile() {
        HashMap<String, Person> data = new HashMap<String, Person>();
        data.put("person", new Person("john"));
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "ExpressionWithCaseFileItem", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "ExpressionWithCaseFileItem", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertNotNull((Object)cInstance.getCaseFile());
            Assert.assertEquals((Object)"john", (Object)((Person)cInstance.getCaseFile().getData("person")).getName());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            Map taskInputs = this.userTaskService.getTaskInputContentByTaskId(((TaskSummary)tasks.get(0)).getId());
            Object personName = taskInputs.get("personName");
            Assert.assertEquals((Object)"john", personName);
            this.caseService.cancelCase(caseId);
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseWithCommentsWithRestrictions() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("participant", new UserImpl("mary"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Collection caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)0L, (long)caseComments.size());
            this.caseService.addCaseComment("CASE-0000000001", "poul", "just a tiny comment", new String[]{"owner"});
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)1L, (long)caseComments.size());
            CommentInstance comment = (CommentInstance)caseComments.iterator().next();
            this.assertComment(comment, "poul", "just a tiny comment");
            this.identityProvider.setName("mary");
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)0L, (long)caseComments.size());
            try {
                this.caseService.updateCaseComment("CASE-0000000001", comment.getId(), comment.getAuthor(), "Updated " + comment.getComment(), new String[]{"participant", "owner"});
                Assertions.fail((String)"mary should not be able to update comment that she has no access to");
            }
            catch (SecurityException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("User mary does not have access to comment"));
            }
            this.identityProvider.setName("john");
            this.caseService.updateCaseComment("CASE-0000000001", comment.getId(), comment.getAuthor(), "Updated " + comment.getComment(), new String[]{"participant", "owner"});
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)1L, (long)caseComments.size());
            comment = (CommentInstance)caseComments.iterator().next();
            this.assertComment(comment, "poul", "Updated just a tiny comment");
            this.identityProvider.setName("mary");
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)1L, (long)caseComments.size());
            this.identityProvider.setName("john");
            this.caseService.addCaseComment("CASE-0000000001", "mary", "another comment", new String[0]);
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)2L, (long)caseComments.size());
            Iterator it = caseComments.iterator();
            this.assertComment((CommentInstance)it.next(), "poul", "Updated just a tiny comment");
            this.assertComment((CommentInstance)it.next(), "mary", "another comment");
            this.identityProvider.setName("mary");
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)2L, (long)caseComments.size());
            this.identityProvider.setName("john");
            this.caseService.addCaseComment("CASE-0000000001", "john", "private comment", new String[]{"owner"});
            caseComments = this.caseService.getCaseComments("CASE-0000000001", CommentSortBy.Author, new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)3L, (long)caseComments.size());
            comment = (CommentInstance)caseComments.iterator().next();
            this.assertComment(comment, "john", "private comment");
            this.identityProvider.setName("mary");
            try {
                this.caseService.removeCaseComment("CASE-0000000001", comment.getId());
                Assertions.fail((String)"mary should not be able to remove comment that she has no access to");
            }
            catch (SecurityException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("User mary does not have access to comment"));
            }
            caseComments = this.caseService.getCaseComments("CASE-0000000001", CommentSortBy.Author, new QueryContext());
            Assert.assertEquals((long)2L, (long)caseComments.size());
            this.identityProvider.setName("john");
            caseComments = this.caseService.getCaseComments("CASE-0000000001", CommentSortBy.Author, new QueryContext());
            Assert.assertEquals((long)3L, (long)caseComments.size());
            this.caseService.removeCaseComment("CASE-0000000001", comment.getId());
            caseComments = this.caseService.getCaseComments("CASE-0000000001", CommentSortBy.Author, new QueryContext());
            Assert.assertEquals((long)2L, (long)caseComments.size());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserTaskCaseDataItemWithRestrictions() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("participant", new UserImpl("mary"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("contactInfo", "main street 10, NYC");
        HashMap<String, List<String>> accessRestrictions = new HashMap<String, List<String>>();
        accessRestrictions.put("contactInfo", Arrays.asList("owner"));
        CaseFileInstance caseFile = this.caseService.newCaseFileInstanceWithRestrictions(this.deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments, accessRestrictions);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Map caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)1L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            this.identityProvider.setName("mary");
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)0L, (long)caseData.size());
            this.identityProvider.setName("john");
            Collection activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
            Assert.assertNotNull((Object)activeStages);
            Assert.assertEquals((long)1L, (long)activeStages.size());
            this.caseService.addDataToCaseFile(caseId, "dataComplete", (Object)true, new String[]{"owner", "participant"});
            activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
            Assert.assertNotNull((Object)activeStages);
            Assert.assertEquals((long)0L, (long)activeStages.size());
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)2L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            Assert.assertEquals((Object)true, caseData.get("dataComplete"));
            this.identityProvider.setName("mary");
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)1L, (long)caseData.size());
            Assert.assertEquals((Object)true, caseData.get("dataComplete"));
            this.identityProvider.setName("john");
            this.caseService.addDataToCaseFile(caseId, "anotherDataItem", (Object)"first version", new String[0]);
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)3L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            Assert.assertEquals((Object)true, caseData.get("dataComplete"));
            Assert.assertEquals((Object)"first version", caseData.get("anotherDataItem"));
            this.identityProvider.setName("mary");
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)2L, (long)caseData.size());
            Assert.assertEquals((Object)true, caseData.get("dataComplete"));
            Assert.assertEquals((Object)"first version", caseData.get("anotherDataItem"));
            try {
                this.caseService.removeDataFromCaseFile(caseId, "contactInfo");
                Assertions.fail((String)"mary should not be able to remove data that she has not access to");
            }
            catch (SecurityException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("User mary does not have access to data"));
            }
            this.identityProvider.setName("john");
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)3L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            Assert.assertEquals((Object)true, caseData.get("dataComplete"));
            Assert.assertEquals((Object)"first version", caseData.get("anotherDataItem"));
            this.caseService.removeDataFromCaseFile(caseId, "contactInfo");
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)2L, (long)caseData.size());
            Assert.assertEquals((Object)true, caseData.get("dataComplete"));
            Assert.assertEquals((Object)"first version", caseData.get("anotherDataItem"));
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            this.identityProvider.setName("john");
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseWithDefinedDataRestrictions() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("participant", new UserImpl("mary"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("contactInfo", "main street 10, NYC");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCaseDataRestrictions", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskCaseDataRestrictions", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Map caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)1L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            this.identityProvider.setName("mary");
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)0L, (long)caseData.size());
            this.identityProvider.setName("john");
            this.caseService.addDataToCaseFile(caseId, "request", (Object)"does it actually work?", new String[0]);
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)2L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            Assert.assertEquals((Object)"does it actually work?", caseData.get("request"));
            this.identityProvider.setName("mary");
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)1L, (long)caseData.size());
            Assert.assertEquals((Object)"does it actually work?", caseData.get("request"));
            this.identityProvider.setName("john");
            try {
                this.caseService.addDataToCaseFile(caseId, "reply", (Object)"does it actually work?", new String[0]);
                Assertions.fail((String)"john does not have access to reply data so cannot add it");
            }
            catch (SecurityException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("User john does not have access to data item named reply"));
            }
            this.identityProvider.setName("mary");
            this.caseService.addDataToCaseFile(caseId, "reply", (Object)"oh yes, it does!", new String[0]);
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)2L, (long)caseData.size());
            Assert.assertEquals((Object)"oh yes, it does!", caseData.get("reply"));
            Assert.assertEquals((Object)"does it actually work?", caseData.get("request"));
            this.identityProvider.setName("john");
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)2L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            Assert.assertEquals((Object)"does it actually work?", caseData.get("request"));
            this.identityProvider.setName("mary");
            this.caseService.addDataToCaseFile(caseId, "reply", (Object)"oh yes, it does! make it visible to all", new String[]{"_public_"});
            this.identityProvider.setName("john");
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)3L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            Assert.assertEquals((Object)"does it actually work?", caseData.get("request"));
            Assert.assertEquals((Object)"oh yes, it does! make it visible to all", caseData.get("reply"));
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.identityProvider.setName("john");
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseWithDefinedDataRestrictionsSetViaUserTask() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("participant", new UserImpl("mary"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("contactInfo", "main street 10, NYC");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCaseDataRestrictions", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskCaseDataRestrictions", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Map caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)1L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("reply_", "John sets the reply via process");
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", params);
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)1L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            this.identityProvider.setName("mary");
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)1L, (long)caseData.size());
            Assert.assertEquals((Object)"John sets the reply via process", caseData.get("reply"));
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.identityProvider.setName("john");
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInclusiveGatewayWithDynamicActivity() {
        HashMap<String, Object> roleAssignments = new HashMap<String, Object>();
        roleAssignments.put("actorRole", new UserImpl("john"));
        roleAssignments.put("groupRole", new GroupImpl("managers"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "InclusiveGatewayCase", data, roleAssignments);
        ((CaseAssignment)caseFile).assignUser("generalRole", "john");
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "InclusiveGatewayCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            Assertions.assertThat((List)tasks).hasSize(2);
            this.caseService.addDynamicTask(caseId, this.caseService.newHumanTaskSpec("First task", "another test", "actorRole", null, new HashMap()));
            List allTasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            Assertions.assertThat((List)allTasks).hasSize(3);
            for (TaskSummary task : tasks) {
                this.userTaskService.completeAutoProgress(task.getId(), "john", null);
            }
            allTasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            Assertions.assertThat((List)allTasks).hasSize(1);
            cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSystemUserCaseAuthorization() {
        HashMap<String, Object> roleAssignments = new HashMap<String, Object>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("contact", new GroupImpl("HR"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("s", "description");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"HR-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"HR-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            this.identityProvider.setName("mary");
            try {
                this.caseService.getCaseInstance(caseId);
                Assertions.fail((String)"Mary is not owner of the case so should not be allowed to retrieve its CaseInstance object");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.identityProvider.setName("unknown");
            this.caseService.getCaseInstance(caseId);
            this.identityProvider.setName("mary");
            try {
                this.caseService.cancelCase(caseId);
                Assertions.fail((String)"Mary is not owner of the case so should not be allowed to cancel the case");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.identityProvider.setName("unknown");
            this.caseService.cancelCase(caseId);
            this.identityProvider.setName("mary");
            try {
                this.caseService.reopenCase(caseId, this.deploymentUnit.getIdentifier(), "UserTaskCase");
                Assertions.fail((String)"Mary is not owner of the case so should not be allowed to reopen the case");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.identityProvider.setName("unknown");
            this.caseService.reopenCase(caseId, this.deploymentUnit.getIdentifier(), "UserTaskCase");
            cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"HR-0000000001", (Object)cInstance.getCaseId());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.identityProvider.setName("john");
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSystemUserCaseDataAuthorization() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("participant", new UserImpl("mary"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("contactInfo", "main street 10, NYC");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCaseDataRestrictions", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskCaseDataRestrictions", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Map caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)1L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            this.identityProvider.setName("mary");
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)0L, (long)caseData.size());
            this.identityProvider.setName("unknown");
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)1L, (long)caseData.size());
            this.caseService.addDataToCaseFile(caseId, "request", (Object)"does it actually work?", new String[0]);
            this.caseService.addDataToCaseFile(caseId, "reply", (Object)"oh yes, it does!", new String[0]);
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)3L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            Assert.assertEquals((Object)"does it actually work?", caseData.get("request"));
            Assert.assertEquals((Object)"oh yes, it does!", caseData.get("reply"));
            this.identityProvider.setName("john");
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)2L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            Assert.assertEquals((Object)"does it actually work?", caseData.get("request"));
            this.identityProvider.setName("mary");
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)2L, (long)caseData.size());
            Assert.assertEquals((Object)"does it actually work?", caseData.get("request"));
            Assert.assertEquals((Object)"oh yes, it does!", caseData.get("reply"));
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.identityProvider.setName("john");
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSystemUserCaseCommentsAuthorization() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("participant", new UserImpl("mary"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Collection caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)0L, (long)caseComments.size());
            this.caseService.addCaseComment("CASE-0000000001", "poul", "just a tiny comment", new String[]{"owner"});
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)1L, (long)caseComments.size());
            CommentInstance comment = (CommentInstance)caseComments.iterator().next();
            this.assertComment(comment, "poul", "just a tiny comment");
            this.identityProvider.setName("mary");
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)0L, (long)caseComments.size());
            try {
                this.caseService.updateCaseComment("CASE-0000000001", comment.getId(), comment.getAuthor(), "Updated " + comment.getComment(), new String[]{"participant", "owner"});
                Assertions.fail((String)"mary should not be able to update comment that she has no access to");
            }
            catch (SecurityException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("User mary does not have access to comment"));
            }
            this.identityProvider.setName("unknown");
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)1L, (long)caseComments.size());
            comment = (CommentInstance)caseComments.iterator().next();
            this.assertComment(comment, "poul", "just a tiny comment");
            this.caseService.updateCaseComment("CASE-0000000001", comment.getId(), comment.getAuthor(), "System User unknown Updated " + comment.getComment(), new String[]{"owner"});
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)1L, (long)caseComments.size());
            comment = (CommentInstance)caseComments.iterator().next();
            this.assertComment(comment, "poul", "System User unknown Updated just a tiny comment");
            this.identityProvider.setName("john");
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)1L, (long)caseComments.size());
            comment = (CommentInstance)caseComments.iterator().next();
            this.assertComment(comment, "poul", "System User unknown Updated just a tiny comment");
            this.identityProvider.setName("mary");
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)0L, (long)caseComments.size());
            try {
                this.caseService.removeCaseComment("CASE-0000000001", comment.getId());
                Assertions.fail((String)"mary should not be able to remove comment that she has no access to");
            }
            catch (SecurityException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("User mary does not have access to comment"));
            }
            this.identityProvider.setName("john");
            caseComments = this.caseService.getCaseComments("CASE-0000000001", CommentSortBy.Author, new QueryContext());
            Assert.assertEquals((long)1L, (long)caseComments.size());
            this.identityProvider.setName("unknown");
            this.caseService.removeCaseComment("CASE-0000000001", comment.getId());
            caseComments = this.caseService.getCaseComments("CASE-0000000001", CommentSortBy.Author, new QueryContext());
            Assert.assertEquals((long)0L, (long)caseComments.size());
            this.identityProvider.setName("john");
            caseComments = this.caseService.getCaseComments("CASE-0000000001", CommentSortBy.Author, new QueryContext());
            Assert.assertEquals((long)0L, (long)caseComments.size());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.identityProvider.setName("john");
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddAndRemoveMultipleDataFromCaseFile() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        try {
            data = new HashMap();
            data.put("person", "john");
            data.put("car", "my first car");
            this.caseService.addDataToCaseFile(caseId, data, new String[0]);
            Collection caseInstanceDataItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            Map<String, String> caseFileVariables = caseInstanceDataItems.stream().collect(Collectors.toMap(CaseFileItem::getName, CaseFileItem::getValue));
            Assertions.assertThat(caseFileVariables).containsOnly(new Map.Entry[]{Assertions.entry((Object)"person", (Object)"john"), Assertions.entry((Object)"car", (Object)"my first car"), Assertions.entry((Object)"name", (Object)"my first case")});
            data = new HashMap();
            data.put("name", "my updated case");
            data.put("car", "my second car");
            this.caseService.addDataToCaseFile(caseId, data, new String[0]);
            caseInstanceDataItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            caseFileVariables = caseInstanceDataItems.stream().collect(Collectors.toMap(CaseFileItem::getName, CaseFileItem::getValue));
            Assertions.assertThat(caseFileVariables).containsOnly(new Map.Entry[]{Assertions.entry((Object)"person", (Object)"john"), Assertions.entry((Object)"car", (Object)"my second car"), Assertions.entry((Object)"name", (Object)"my updated case")});
            this.caseService.removeDataFromCaseFile(caseId, "nonexisting");
            caseInstanceDataItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            Assertions.assertThat((Iterable)caseInstanceDataItems).hasSize(3);
            this.caseService.removeDataFromCaseFile(caseId, Arrays.asList("name", "car", "nonexisting"));
            caseInstanceDataItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            caseFileVariables = caseInstanceDataItems.stream().collect(Collectors.toMap(CaseFileItem::getName, CaseFileItem::getValue));
            Assertions.assertThat(caseFileVariables).containsOnly(new Map.Entry[]{Assertions.entry((Object)"person", (Object)"john")});
            this.caseService.removeDataFromCaseFile(caseId, "person");
            caseInstanceDataItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            Assertions.assertThat((Iterable)caseInstanceDataItems).isEmpty();
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    @Test
    public void testCreateCaseFileInstanceForNotExistingCase() {
        Assertions.assertThatExceptionOfType(CaseDefinitionNotFoundException.class).isThrownBy(() -> this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "nonexisting", Collections.emptyMap()));
        Assertions.assertThatExceptionOfType(CaseDefinitionNotFoundException.class).isThrownBy(() -> this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "nonexisting", Collections.emptyMap(), Collections.emptyMap()));
    }

    @Test
    public void testGetCaseFileInstanceForNotExistingCase() {
        Assertions.assertThatExceptionOfType(CaseNotFoundException.class).isThrownBy(() -> this.caseService.getCaseFileInstance("nonexisting"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseForMultiInstanceStagesTriggerAdHocFragment() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "multiplestages");
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("type", "basic");
            this.caseService.triggerAdHocFragment(caseId, "Stage #{type}", data);
            Collection stages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
            Assertions.assertThat((Iterable)stages).hasSize(1);
            Assertions.assertThat((String)((CaseStageInstance)stages.iterator().next()).getName()).isEqualTo((Object)"Stage basic");
            data = new HashMap();
            data.put("type", "advanced");
            this.caseService.triggerAdHocFragment(caseId, "Stage #{type}", data);
            stages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
            Assertions.assertThat((Iterable)stages).hasSize(2);
            Iterator it = stages.iterator();
            Assertions.assertThat((String)((CaseStageInstance)it.next()).getName()).isEqualTo((Object)"Stage basic");
            Assertions.assertThat((String)((CaseStageInstance)it.next()).getName()).isEqualTo((Object)"Stage advanced");
            this.caseService.triggerAdHocFragment(caseId, "Stage basic", "Simple task", data);
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseForMultiInstanceStagesAddDynamicNodes() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "multiplestages");
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("type", "basic");
            this.caseService.triggerAdHocFragment(caseId, "Stage #{type}", data);
            Collection stages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
            Assertions.assertThat((Iterable)stages).hasSize(1);
            Assertions.assertThat((String)((CaseStageInstance)stages.iterator().next()).getName()).isEqualTo((Object)"Stage basic");
            TaskSpecification taskSpec = this.caseService.newHumanTaskSpec("Basic", "just a task", "john", null, null);
            this.caseService.addDynamicTaskToStage(caseId, "Stage basic", taskSpec);
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            Assertions.assertThat((String)((TaskSummary)tasks.get(0)).getName()).isEqualTo((Object)"Basic");
            Assertions.assertThat((String)((TaskSummary)tasks.get(0)).getDescription()).isEqualTo((Object)"just a task");
            HashMap parameters = new HashMap();
            this.caseService.addDynamicSubprocessToStage(caseId, "Stage basic", "DataVerification", parameters);
            Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
            Assertions.assertThat((Iterable)caseProcessInstances).hasSize(2);
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartEmptyCaseWithCaseFileValueTooLong() {
        System.setProperty("org.jbpm.cases.var.log.length", "10");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case data bit too long");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertNotNull((Object)cInstance.getCaseFile());
            Assert.assertEquals((Object)"my first case data bit too long", (Object)cInstance.getCaseFile().getData("name"));
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Collection vars = this.runtimeDataService.getVariablesCurrentState(((CaseInstanceImpl)cInstance).getProcessInstanceId().longValue());
            Assert.assertNotNull((Object)vars);
            Assert.assertEquals((long)3L, (long)vars.size());
            Map<String, Object> mappedVars = vars.stream().collect(Collectors.toMap(v -> v.getVariableId(), v -> v.getNewValue()));
            Assert.assertEquals((Object)"my first case data bit too long", (Object)mappedVars.get("caseFile_name"));
            Assert.assertEquals((Object)"CASE-0000000001", (Object)mappedVars.get("CaseId"));
            Assert.assertEquals((Object)"john", (Object)mappedVars.get("initiator"));
            Collection caseFileItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            Assert.assertNotNull((Object)caseFileItems);
            Assert.assertEquals((long)1L, (long)caseFileItems.size());
            mappedVars = caseFileItems.stream().collect(Collectors.toMap(cs -> cs.getName(), cs -> cs.getValue()));
            Assert.assertEquals((Object)"my first c", (Object)mappedVars.get("name"));
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
            System.clearProperty("org.jbpm.cases.var.log.length");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseWithIndexedFromVariableUpdates() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("participant", new UserImpl("mary"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("contactInfo", "main street 10, NYC");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCaseData", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskCaseData", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Map caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)1L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            Collection dataItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            ((IterableAssert)Assertions.assertThat((Iterable)dataItems).isNotNull()).hasSize(1);
            Map<String, CaseFileItem> mappedDataItems = dataItems.stream().collect(Collectors.toMap(CaseFileItem::getName, t -> t));
            Assertions.assertThat(mappedDataItems).containsKeys((Object[])new String[]{"contactInfo"});
            this.identityProvider.setName("john");
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            ((ListAssert)Assertions.assertThat((List)tasks).isNotNull()).hasSize(1);
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("reply_", "here is my reply");
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", results);
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)2L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            Assert.assertEquals((Object)"here is my reply", caseData.get("reply"));
            dataItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            ((IterableAssert)Assertions.assertThat((Iterable)dataItems).isNotNull()).hasSize(2);
            mappedDataItems = dataItems.stream().collect(Collectors.toMap(CaseFileItem::getName, t -> t));
            Assertions.assertThat(mappedDataItems).containsKeys((Object[])new String[]{"contactInfo", "reply"});
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.identityProvider.setName("john");
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseWithIndexedFromVariableUpdatesResetVariable() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("participant", new UserImpl("mary"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("contactInfo", "main street 10, NYC");
        data.put("reply", "here is my reply");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCaseData", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskCaseData", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Map caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)2L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            Assert.assertEquals((Object)"here is my reply", caseData.get("reply"));
            Collection dataItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            ((IterableAssert)Assertions.assertThat((Iterable)dataItems).isNotNull()).hasSize(2);
            Map<String, CaseFileItem> mappedDataItems = dataItems.stream().collect(Collectors.toMap(CaseFileItem::getName, t -> t));
            Assertions.assertThat(mappedDataItems).containsKeys((Object[])new String[]{"contactInfo", "reply"});
            this.identityProvider.setName("john");
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            ((ListAssert)Assertions.assertThat((List)tasks).isNotNull()).hasSize(1);
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put("reply_", null);
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", results);
            cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            caseData = cInstance.getCaseFile().getData();
            Assert.assertNotNull((Object)caseData);
            Assert.assertEquals((long)1L, (long)caseData.size());
            Assert.assertEquals((Object)"main street 10, NYC", caseData.get("contactInfo"));
            dataItems = this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, new QueryContext());
            ((IterableAssert)Assertions.assertThat((Iterable)dataItems).isNotNull()).hasSize(1);
            mappedDataItems = dataItems.stream().collect(Collectors.toMap(CaseFileItem::getName, t -> t));
            Assertions.assertThat(mappedDataItems).containsKeys((Object[])new String[]{"contactInfo"});
            Assertions.assertThat(mappedDataItems).doesNotContainKeys((Object[])new String[]{"reply"});
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.identityProvider.setName("john");
                this.caseService.cancelCase(caseId);
            }
        }
    }
}

