/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.casemgmt.impl.event.CommentNotificationEventListener;

public class CommentNotificationEventListenerFactory {
    private static Map<String, CommentNotificationEventListener> listeners = new ConcurrentHashMap<String, CommentNotificationEventListener>();

    public static synchronized CommentNotificationEventListener get(String id) {
        if (listeners.containsKey(id)) {
            return listeners.get(id);
        }
        CommentNotificationEventListener listener = new CommentNotificationEventListener();
        listeners.put(id, listener);
        return listener;
    }

    public static synchronized CommentNotificationEventListener create(String id, String sender, String template, String subject) {
        if (listeners.containsKey(id)) {
            return listeners.get(id);
        }
        CommentNotificationEventListener listener = new CommentNotificationEventListener(sender, template, subject);
        listeners.put(id, listener);
        return listener;
    }

    public static CommentNotificationEventListener getExisting(String id) {
        return listeners.get(id);
    }

    public static CommentNotificationEventListener removeExisting(String id) {
        return listeners.remove(id);
    }

    public static void clear() {
        listeners.clear();
    }
}

