/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.jbpm.casemgmt.api.CaseNotFoundException;
import org.jbpm.casemgmt.api.StageNotFoundException;
import org.jbpm.casemgmt.api.dynamic.TaskSpecification;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.CaseStage;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CaseStageInstance;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.services.api.ProcessDefinitionNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.junit.Test;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;

public class CaseDynamicNodesTest
extends AbstractCaseServicesBaseTest {
    private static final String NOT_EXISTING_STAGE = "NotExistingStage";
    private static final String EMPTY_CASE_STAGE = "EmptyCaseStage";
    private static final String DYNAMIC_TASK = "DynamicUserTask";
    private static final String SUBPROCESS_TASK = "Hello";
    private static final String SUBPROCESS = "UserTask";
    private static final String NOT_EXISTING_SUBPROCESS = "NotExistingSubprocess";

    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/EmptyCase.bpmn2");
        processes.add("cases/EmptyCaseStage.bpmn2");
        processes.add("cases/CaseWithTwoStages.bpmn2");
        processes.add("processes/UserTaskProcess.bpmn2");
        return processes;
    }

    @Test
    public void testAddDynamicTaskToNotExistingCase() {
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicTask("CASE-0000000001", this.createUserTask())).isInstanceOf(CaseNotFoundException.class);
    }

    @Test
    public void testAddDynamicTaskToNotExistingCaseByProcessInstanceId() {
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicTask(Long.valueOf(Long.MAX_VALUE), this.createUserTask())).isInstanceOf(ProcessInstanceNotFoundException.class);
    }

    @Test
    public void testAddDynamicTaskToStageNotExistingCase() {
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicTaskToStage("CASE-0000000001", NOT_EXISTING_STAGE, this.createUserTask())).isInstanceOf(CaseNotFoundException.class);
    }

    @Test
    public void testAddDynamicTaskToNotExistingStage() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicTaskToStage(caseId, NOT_EXISTING_STAGE, this.createUserTask())).isInstanceOf(StageNotFoundException.class);
    }

    @Test
    public void testAddDynamicTaskToStageNotExistingCaseByProcessInstanceId() {
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicTaskToStage(Long.valueOf(Long.MAX_VALUE), NOT_EXISTING_STAGE, this.createUserTask())).isInstanceOf(ProcessInstanceNotFoundException.class);
    }

    @Test
    public void testAddDynamicTaskToNotExistingStageByProcessInstanceId() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
        ((IterableAssert)Assertions.assertThat((Iterable)caseProcessInstances).isNotNull()).hasSize(1);
        ProcessInstanceDesc processInstance = (ProcessInstanceDesc)caseProcessInstances.iterator().next();
        Assertions.assertThat((Object)processInstance).isNotNull();
        Assertions.assertThat((String)processInstance.getCorrelationKey()).isEqualTo((Object)"CASE-0000000001");
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicTaskToStage(processInstance.getId(), NOT_EXISTING_STAGE, this.createUserTask())).isInstanceOf(StageNotFoundException.class);
    }

    @Test
    public void testAddDynamicUserTaskToEmptyStage() {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("continue", false);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), EMPTY_CASE_STAGE, data, Collections.emptyMap());
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), EMPTY_CASE_STAGE, caseFile);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        CaseInstance caseInstance = this.caseService.getCaseInstance(caseId, false, false, false, true);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        Assertions.assertThat((Iterable)caseInstance.getCaseStages()).hasSize(1);
        String stageId = ((CaseStageInstance)caseInstance.getCaseStages().iterator().next()).getId();
        this.caseService.addDynamicTaskToStage(caseId, stageId, this.createUserTask());
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary insideTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)insideTask.getName()).isEqualTo((Object)DYNAMIC_TASK);
        this.userTaskService.completeAutoProgress(insideTask.getId(), "john", null);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).isEmpty();
    }

    @Test
    public void testAddMultipleDynamicTasksToStage() {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("continue", false);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), EMPTY_CASE_STAGE, data, Collections.emptyMap());
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), EMPTY_CASE_STAGE, caseFile);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        CaseInstance caseInstance = this.caseService.getCaseInstance(caseId, false, false, false, true);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        Assertions.assertThat((Iterable)caseInstance.getCaseStages()).hasSize(1);
        String stageId = ((CaseStageInstance)caseInstance.getCaseStages().iterator().next()).getId();
        this.caseService.addDynamicTaskToStage(caseId, stageId, this.createUserTask());
        this.caseService.addDynamicTaskToStage(caseId, stageId, this.createUserTask());
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(2);
        TaskSummary userTask1 = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)userTask1.getName()).isEqualTo((Object)DYNAMIC_TASK);
        this.userTaskService.completeAutoProgress(userTask1.getId(), "john", null);
        TaskSummary userTask2 = (TaskSummary)tasks.get(1);
        Assertions.assertThat((String)userTask2.getName()).isEqualTo((Object)DYNAMIC_TASK);
        this.userTaskService.completeAutoProgress(userTask2.getId(), "john", null);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).isEmpty();
    }

    @Test
    public void testAddDynamicTaskToNotActiveStage() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "CaseWithTwoStages");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        CaseDefinition caseDefinition = this.caseRuntimeDataService.getCase(this.deploymentUnit.getIdentifier(), "CaseWithTwoStages");
        Assertions.assertThat((Object)caseDefinition).isNotNull();
        Assertions.assertThat((Iterable)caseDefinition.getCaseStages()).hasSize(2);
        Iterator caseStageIterator = caseDefinition.getCaseStages().iterator();
        caseStageIterator.next();
        String stageId = ((CaseStage)caseStageIterator.next()).getId();
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicTaskToStage(caseId, stageId, this.createUserTask())).isInstanceOf(StageNotFoundException.class);
    }

    @Test
    public void testAddDynamicSubprocessToNotExistingCase() {
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicSubprocess("CASE-0000000001", SUBPROCESS, Collections.emptyMap())).isInstanceOf(CaseNotFoundException.class);
    }

    @Test
    public void testAddDynamicSubprocessToNotExistingCaseByProcessInstanceId() {
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicSubprocess(Long.valueOf(Long.MAX_VALUE), SUBPROCESS, Collections.emptyMap())).isInstanceOf(ProcessInstanceNotFoundException.class);
    }

    @Test
    public void testAddDynamicSubprocessToStageNotExistingCase() {
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicSubprocessToStage("CASE-0000000001", NOT_EXISTING_STAGE, SUBPROCESS, Collections.emptyMap())).isInstanceOf(CaseNotFoundException.class);
    }

    @Test
    public void testAddDynamicSubprocessToNotExistingStage() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicSubprocessToStage(caseId, NOT_EXISTING_STAGE, SUBPROCESS, Collections.emptyMap())).isInstanceOf(StageNotFoundException.class);
    }

    @Test
    public void testAddDynamicSubprocessToStageNotExistingCaseByProcessInstanceId() {
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicSubprocessToStage(Long.valueOf(Long.MAX_VALUE), NOT_EXISTING_STAGE, SUBPROCESS, Collections.emptyMap())).isInstanceOf(ProcessInstanceNotFoundException.class);
    }

    @Test
    public void testAddDynamicSubprocessToNotExistingStageByProcessInstanceId() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
        ((IterableAssert)Assertions.assertThat((Iterable)caseProcessInstances).isNotNull()).hasSize(1);
        ProcessInstanceDesc processInstance = (ProcessInstanceDesc)caseProcessInstances.iterator().next();
        Assertions.assertThat((Object)processInstance).isNotNull();
        Assertions.assertThat((String)processInstance.getCorrelationKey()).isEqualTo((Object)"CASE-0000000001");
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicSubprocessToStage(processInstance.getId(), NOT_EXISTING_STAGE, SUBPROCESS, Collections.emptyMap())).isInstanceOf(StageNotFoundException.class);
    }

    @Test
    public void testAddDynamicSubprocessWithNotExistingProcessId() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        CaseInstance caseInstance = this.caseService.getCaseInstance(caseId, false, false, false, true);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        CaseStatus initialStatus = CaseStatus.fromId((int)caseInstance.getStatus());
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicSubprocess(caseId, NOT_EXISTING_SUBPROCESS, Collections.emptyMap())).isInstanceOf(ProcessDefinitionNotFoundException.class);
        caseInstance = this.caseService.getCaseInstance(caseId, false, false, false, true);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        CaseStatus afterStatus = CaseStatus.fromId((int)caseInstance.getStatus());
        Assertions.assertThat((Comparable)initialStatus).isEqualTo((Object)afterStatus);
    }

    @Test
    public void testAddDynamicSubprocessToStageWithNotExistingProcessId() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), EMPTY_CASE_STAGE);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        CaseInstance caseInstance = this.caseService.getCaseInstance(caseId, false, false, false, true);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        Assertions.assertThat((Iterable)caseInstance.getCaseStages()).hasSize(1);
        CaseStatus initialStatus = CaseStatus.fromId((int)caseInstance.getStatus());
        String stageId = ((CaseStageInstance)caseInstance.getCaseStages().iterator().next()).getId();
        Assertions.assertThat((String)stageId).isNotNull();
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicSubprocessToStage(caseId, stageId, NOT_EXISTING_SUBPROCESS, Collections.emptyMap())).isInstanceOf(ProcessDefinitionNotFoundException.class);
        caseInstance = this.caseService.getCaseInstance(caseId, false, false, false, true);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        CaseStatus afterStatus = CaseStatus.fromId((int)caseInstance.getStatus());
        Assertions.assertThat((Comparable)initialStatus).isEqualTo((Object)afterStatus);
    }

    @Test
    public void testAddDynamicSubprocessToCaseByProcessInstanceId() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
        ((IterableAssert)Assertions.assertThat((Iterable)caseProcessInstances).isNotNull()).hasSize(1);
        ProcessInstanceDesc processInstance = (ProcessInstanceDesc)caseProcessInstances.iterator().next();
        Assertions.assertThat((Object)processInstance).isNotNull();
        Assertions.assertThat((String)processInstance.getCorrelationKey()).isEqualTo((Object)"CASE-0000000001");
        Long subprocessId = this.caseService.addDynamicSubprocess(processInstance.getId(), SUBPROCESS, Collections.emptyMap());
        ProcessInstanceDesc subprocessInstance = this.runtimeDataService.getProcessInstanceById(subprocessId.longValue());
        Assertions.assertThat((Object)subprocessInstance).isNotNull();
        Assertions.assertThat((Integer)subprocessInstance.getState()).isEqualTo(1);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary userTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)userTask.getName()).isEqualTo((Object)SUBPROCESS_TASK);
        this.userTaskService.completeAutoProgress(userTask.getId(), "john", null);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).isEmpty();
        subprocessInstance = this.runtimeDataService.getProcessInstanceById(subprocessId.longValue());
        Assertions.assertThat((Object)subprocessInstance).isNotNull();
        Assertions.assertThat((Integer)subprocessInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testAddDynamicSubprocessToStageByProcessInstanceId() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), EMPTY_CASE_STAGE);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        Collection caseProcessInstances = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, new QueryContext());
        ((IterableAssert)Assertions.assertThat((Iterable)caseProcessInstances).isNotNull()).hasSize(1);
        ProcessInstanceDesc processInstance = (ProcessInstanceDesc)caseProcessInstances.iterator().next();
        Assertions.assertThat((Object)processInstance).isNotNull();
        Assertions.assertThat((String)processInstance.getCorrelationKey()).isEqualTo((Object)"CASE-0000000001");
        CaseInstance caseInstance = this.caseService.getCaseInstance(caseId, false, false, false, true);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        Assertions.assertThat((Iterable)caseInstance.getCaseStages()).hasSize(1);
        String stageId = ((CaseStageInstance)caseInstance.getCaseStages().iterator().next()).getId();
        Assertions.assertThat((String)stageId).isNotNull();
        Long subprocessId = this.caseService.addDynamicSubprocessToStage(processInstance.getId(), stageId, SUBPROCESS, Collections.emptyMap());
        ProcessInstanceDesc subprocessInstance = this.runtimeDataService.getProcessInstanceById(subprocessId.longValue());
        Assertions.assertThat((Object)subprocessInstance).isNotNull();
        Assertions.assertThat((Integer)subprocessInstance.getState()).isEqualTo(1);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary userTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)userTask.getName()).isEqualTo((Object)SUBPROCESS_TASK);
        this.userTaskService.completeAutoProgress(userTask.getId(), "john", null);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).isEmpty();
        subprocessInstance = this.runtimeDataService.getProcessInstanceById(subprocessId.longValue());
        Assertions.assertThat((Object)subprocessInstance).isNotNull();
        Assertions.assertThat((Integer)subprocessInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testAddMultipleDynamicSubprocessesToCase() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        Long subprocessId1 = this.caseService.addDynamicSubprocess(caseId, SUBPROCESS, Collections.emptyMap());
        ProcessInstanceDesc subprocessInstance1 = this.runtimeDataService.getProcessInstanceById(subprocessId1.longValue());
        Assertions.assertThat((Object)subprocessInstance1).isNotNull();
        Assertions.assertThat((Integer)subprocessInstance1.getState()).isEqualTo(1);
        Long subprocessId2 = this.caseService.addDynamicSubprocess(caseId, SUBPROCESS, Collections.emptyMap());
        ProcessInstanceDesc subprocessInstance2 = this.runtimeDataService.getProcessInstanceById(subprocessId2.longValue());
        Assertions.assertThat((Object)subprocessInstance2).isNotNull();
        Assertions.assertThat((Integer)subprocessInstance2.getState()).isEqualTo(1);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(2);
        TaskSummary userTask1 = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)userTask1.getName()).isEqualTo((Object)SUBPROCESS_TASK);
        this.userTaskService.completeAutoProgress(userTask1.getId(), "john", null);
        TaskSummary userTask2 = (TaskSummary)tasks.get(1);
        Assertions.assertThat((String)userTask2.getName()).isEqualTo((Object)SUBPROCESS_TASK);
        this.userTaskService.completeAutoProgress(userTask2.getId(), "john", null);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).isEmpty();
        subprocessInstance1 = this.runtimeDataService.getProcessInstanceById(subprocessId1.longValue());
        Assertions.assertThat((Object)subprocessInstance1).isNotNull();
        Assertions.assertThat((Integer)subprocessInstance1.getState()).isEqualTo(2);
        subprocessInstance2 = this.runtimeDataService.getProcessInstanceById(subprocessId2.longValue());
        Assertions.assertThat((Object)subprocessInstance2).isNotNull();
        Assertions.assertThat((Integer)subprocessInstance2.getState()).isEqualTo(2);
    }

    @Test
    public void testAddMultipleDynamicSubprocessesToStage() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), EMPTY_CASE_STAGE);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        CaseInstance caseInstance = this.caseService.getCaseInstance(caseId, false, false, false, true);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        Assertions.assertThat((Iterable)caseInstance.getCaseStages()).hasSize(1);
        String stageId = ((CaseStageInstance)caseInstance.getCaseStages().iterator().next()).getId();
        Assertions.assertThat((String)stageId).isNotNull();
        Long subprocessId1 = this.caseService.addDynamicSubprocessToStage(caseId, stageId, SUBPROCESS, Collections.emptyMap());
        ProcessInstanceDesc subprocessInstance1 = this.runtimeDataService.getProcessInstanceById(subprocessId1.longValue());
        Assertions.assertThat((Object)subprocessInstance1).isNotNull();
        Assertions.assertThat((Integer)subprocessInstance1.getState()).isEqualTo(1);
        Long subprocessId2 = this.caseService.addDynamicSubprocessToStage(caseId, stageId, SUBPROCESS, Collections.emptyMap());
        ProcessInstanceDesc subprocessInstance2 = this.runtimeDataService.getProcessInstanceById(subprocessId2.longValue());
        Assertions.assertThat((Object)subprocessInstance2).isNotNull();
        Assertions.assertThat((Integer)subprocessInstance2.getState()).isEqualTo(1);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(2);
        TaskSummary userTask1 = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)userTask1.getName()).isEqualTo((Object)SUBPROCESS_TASK);
        this.userTaskService.completeAutoProgress(userTask1.getId(), "john", null);
        TaskSummary userTask2 = (TaskSummary)tasks.get(1);
        Assertions.assertThat((String)userTask2.getName()).isEqualTo((Object)SUBPROCESS_TASK);
        this.userTaskService.completeAutoProgress(userTask2.getId(), "john", null);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).isEmpty();
        subprocessInstance1 = this.runtimeDataService.getProcessInstanceById(subprocessId1.longValue());
        Assertions.assertThat((Object)subprocessInstance1).isNotNull();
        Assertions.assertThat((Integer)subprocessInstance1.getState()).isEqualTo(2);
        subprocessInstance2 = this.runtimeDataService.getProcessInstanceById(subprocessId2.longValue());
        Assertions.assertThat((Object)subprocessInstance2).isNotNull();
        Assertions.assertThat((Integer)subprocessInstance2.getState()).isEqualTo(2);
    }

    @Test
    public void testAddDynamicSubprocessToNotActiveStage() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "CaseWithTwoStages");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        CaseDefinition caseDefinition = this.caseRuntimeDataService.getCase(this.deploymentUnit.getIdentifier(), "CaseWithTwoStages");
        Assertions.assertThat((Object)caseDefinition).isNotNull();
        Assertions.assertThat((Iterable)caseDefinition.getCaseStages()).hasSize(2);
        Iterator caseStageIterator = caseDefinition.getCaseStages().iterator();
        caseStageIterator.next();
        String stageId = ((CaseStage)caseStageIterator.next()).getId();
        Assertions.assertThatThrownBy(() -> this.caseService.addDynamicSubprocessToStage(caseId, stageId, SUBPROCESS, Collections.emptyMap())).isInstanceOf(StageNotFoundException.class);
    }

    private TaskSpecification createUserTask() {
        return this.caseService.newHumanTaskSpec(DYNAMIC_TASK, "", "john", null, Collections.emptyMap());
    }
}

