/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jbpm.casemgmt.api.model.AdHocFragment;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.CaseMilestone;
import org.jbpm.casemgmt.api.model.CaseRole;
import org.jbpm.casemgmt.api.model.CaseStage;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.query.QueryContext;

public class CaseRuntimeDataServiceDefinitionImplTest
extends AbstractCaseServicesBaseTest {
    public static final String SORT_BY_CASE_DEFINITION_NAME = "CaseName";

    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/EmptyCase.bpmn2");
        processes.add("cases/UserTaskCase.bpmn2");
        processes.add("cases/UserTaskCaseBoundary.bpmn2");
        processes.add("cases/UserTaskWithStageCase.bpmn2");
        processes.add("cases/CaseWithTwoStages.bpmn2");
        processes.add("processes/DataVerificationProcess.bpmn2");
        processes.add("processes/UserTaskProcess.bpmn2");
        return processes;
    }

    @Test
    public void testGetCaseDefinitions() {
        Collection cases = this.caseRuntimeDataService.getCases(new QueryContext());
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)5L, (long)cases.size());
        Map mappedCases = this.mapCases(cases);
        Assert.assertTrue((boolean)mappedCases.containsKey("EmptyCase"));
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskCase"));
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskCaseBoundary"));
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskWithStageCase"));
        CaseDefinition caseDef = (CaseDefinition)mappedCases.get("EmptyCase");
        Assert.assertNotNull((Object)caseDef);
        Assert.assertEquals((Object)"EmptyCase", (Object)caseDef.getId());
        Assert.assertEquals((Object)"New Case", (Object)caseDef.getName());
        Assert.assertEquals((Object)"", (Object)caseDef.getVersion());
        Assert.assertEquals((Object)"CASE", (Object)caseDef.getIdentifierPrefix());
        Assert.assertNotNull((Object)caseDef.getCaseMilestones());
        Assert.assertTrue((boolean)caseDef.getCaseMilestones().isEmpty());
        Assert.assertNotNull((Object)caseDef.getCaseStages());
        Assert.assertTrue((boolean)caseDef.getCaseStages().isEmpty());
        Assert.assertNotNull((Object)caseDef.getCaseRoles());
        Assert.assertTrue((boolean)caseDef.getCaseRoles().isEmpty());
        Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
        caseDef = (CaseDefinition)mappedCases.get("UserTaskCase");
        Assert.assertNotNull((Object)caseDef);
        Assert.assertEquals((Object)"UserTaskCase", (Object)caseDef.getId());
        Assert.assertEquals((Object)"Simple Case with User Tasks", (Object)caseDef.getName());
        Assert.assertEquals((Object)"1.0", (Object)caseDef.getVersion());
        Assert.assertEquals((Object)"HR", (Object)caseDef.getIdentifierPrefix());
        Assert.assertNotNull((Object)caseDef.getCaseMilestones());
        Assert.assertEquals((long)2L, (long)caseDef.getCaseMilestones().size());
        Map mappedMilestones = this.mapMilestones(caseDef.getCaseMilestones());
        Assert.assertTrue((boolean)mappedMilestones.containsKey("Milestone1"));
        Assert.assertTrue((boolean)mappedMilestones.containsKey("Milestone2"));
        CaseMilestone milestone = (CaseMilestone)mappedMilestones.get("Milestone1");
        Assert.assertEquals((Object)"_SomeID4", (Object)milestone.getId());
        Assert.assertEquals((Object)"Milestone1", (Object)milestone.getName());
        Assert.assertEquals((Object)"", (Object)milestone.getAchievementCondition());
        Assert.assertEquals((Object)false, (Object)milestone.isMandatory());
        milestone = (CaseMilestone)mappedMilestones.get("Milestone2");
        Assert.assertEquals((Object)"_5", (Object)milestone.getId());
        Assert.assertEquals((Object)"Milestone2", (Object)milestone.getName());
        Assert.assertEquals((Object)"CaseData(data.get(\"dataComplete\") == true)", (Object)milestone.getAchievementCondition());
        Assert.assertEquals((Object)false, (Object)milestone.isMandatory());
        Assert.assertNotNull((Object)caseDef.getCaseStages());
        Assert.assertEquals((long)0L, (long)caseDef.getCaseStages().size());
        Assert.assertNotNull((Object)caseDef.getCaseRoles());
        Assert.assertEquals((long)3L, (long)caseDef.getCaseRoles().size());
        Map mappedRoles = this.mapRoles(caseDef.getCaseRoles());
        Assert.assertTrue((boolean)mappedRoles.containsKey("owner"));
        Assert.assertTrue((boolean)mappedRoles.containsKey("contact"));
        Assert.assertTrue((boolean)mappedRoles.containsKey("participant"));
        Assert.assertEquals((long)1L, (long)((CaseRole)mappedRoles.get("owner")).getCardinality().intValue());
        Assert.assertEquals((long)2L, (long)((CaseRole)mappedRoles.get("contact")).getCardinality().intValue());
        Assert.assertEquals((long)-1L, (long)((CaseRole)mappedRoles.get("participant")).getCardinality().intValue());
        caseDef = (CaseDefinition)mappedCases.get("UserTaskWithStageCase");
        Assert.assertNotNull((Object)caseDef);
        Assert.assertEquals((Object)"UserTaskWithStageCase", (Object)caseDef.getId());
        Assert.assertEquals((Object)"UserTaskWithStageCase", (Object)caseDef.getName());
        Assert.assertEquals((Object)"1.0", (Object)caseDef.getVersion());
        Assert.assertEquals((Object)"CASE", (Object)caseDef.getIdentifierPrefix());
        Assert.assertNotNull((Object)caseDef.getCaseMilestones());
        Assert.assertEquals((long)0L, (long)caseDef.getCaseMilestones().size());
        Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
        Assert.assertNotNull((Object)caseDef.getCaseStages());
        Assert.assertEquals((long)1L, (long)caseDef.getCaseStages().size());
        Map mappedStages = this.mapStages(caseDef.getCaseStages());
        Assert.assertTrue((boolean)mappedStages.containsKey("Collect input"));
        CaseStage caseStage = (CaseStage)mappedStages.get("Collect input");
        Assert.assertNotNull((Object)caseStage);
        Assert.assertEquals((Object)"Collect input", (Object)caseStage.getName());
        Assert.assertEquals((long)2L, (long)caseStage.getAdHocFragments().size());
        Map mappedFragments = this.mapAdHocFragments(caseStage.getAdHocFragments());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Missing data"));
        Assert.assertEquals((Object)"HumanTaskNode", (Object)((AdHocFragment)mappedFragments.get("Missing data")).getType());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Verification of data"));
        Assert.assertEquals((Object)"SubProcessNode", (Object)((AdHocFragment)mappedFragments.get("Verification of data")).getType());
        Assert.assertNotNull((Object)caseDef.getCaseRoles());
        Assert.assertEquals((long)3L, (long)caseDef.getCaseRoles().size());
        mappedRoles = this.mapRoles(caseDef.getCaseRoles());
        Assert.assertTrue((boolean)mappedRoles.containsKey("owner"));
        Assert.assertTrue((boolean)mappedRoles.containsKey("contact"));
        Assert.assertTrue((boolean)mappedRoles.containsKey("participant"));
        Assert.assertEquals((long)1L, (long)((CaseRole)mappedRoles.get("owner")).getCardinality().intValue());
        Assert.assertEquals((long)2L, (long)((CaseRole)mappedRoles.get("contact")).getCardinality().intValue());
        Assert.assertEquals((long)-1L, (long)((CaseRole)mappedRoles.get("participant")).getCardinality().intValue());
    }

    @Test
    public void testGetCaseDefinitionsSorted() {
        Collection cases = this.caseRuntimeDataService.getCases(new QueryContext(Integer.valueOf(0), Integer.valueOf(1), SORT_BY_CASE_DEFINITION_NAME, true));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Assert.assertEquals((Object)"CaseWithTwoStages", (Object)((CaseDefinition)cases.iterator().next()).getId());
        cases = this.caseRuntimeDataService.getCases(new QueryContext(Integer.valueOf(1), Integer.valueOf(1), SORT_BY_CASE_DEFINITION_NAME, true));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Assert.assertEquals((Object)"EmptyCase", (Object)((CaseDefinition)cases.iterator().next()).getId());
        cases = this.caseRuntimeDataService.getCases(new QueryContext(Integer.valueOf(2), Integer.valueOf(1), SORT_BY_CASE_DEFINITION_NAME, true));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Assert.assertEquals((Object)"UserTaskCase", (Object)((CaseDefinition)cases.iterator().next()).getId());
        cases = this.caseRuntimeDataService.getCases(new QueryContext(SORT_BY_CASE_DEFINITION_NAME, false));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)5L, (long)cases.size());
        ArrayList sortedCases = new ArrayList(cases);
        Assert.assertEquals((Object)"UserTaskWithStageCase", (Object)((CaseDefinition)sortedCases.get(0)).getId());
        Assert.assertEquals((Object)"UserTaskCaseBoundary", (Object)((CaseDefinition)sortedCases.get(1)).getId());
        Assert.assertEquals((Object)"UserTaskCase", (Object)((CaseDefinition)sortedCases.get(2)).getId());
        Assert.assertEquals((Object)"EmptyCase", (Object)((CaseDefinition)sortedCases.get(3)).getId());
    }

    @Test
    public void testGetCaseDefinitionsByDeploymentId() {
        Collection cases = this.caseRuntimeDataService.getCasesByDeployment(this.deploymentUnit.getIdentifier(), new QueryContext());
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)5L, (long)cases.size());
        Map mappedCases = this.mapCases(cases);
        Assert.assertTrue((boolean)mappedCases.containsKey("EmptyCase"));
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskCase"));
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskCaseBoundary"));
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskWithStageCase"));
        cases = this.caseRuntimeDataService.getCasesByDeployment("not-existing", new QueryContext());
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)0L, (long)cases.size());
    }

    @Test
    public void testGetCaseDefinitionsByDeploymentIdSorted() {
        Collection cases = this.caseRuntimeDataService.getCasesByDeployment(this.deploymentUnit.getIdentifier(), new QueryContext(Integer.valueOf(0), Integer.valueOf(1), SORT_BY_CASE_DEFINITION_NAME, true));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Assert.assertEquals((Object)"CaseWithTwoStages", (Object)((CaseDefinition)cases.iterator().next()).getId());
        cases = this.caseRuntimeDataService.getCasesByDeployment(this.deploymentUnit.getIdentifier(), new QueryContext(Integer.valueOf(1), Integer.valueOf(1), SORT_BY_CASE_DEFINITION_NAME, true));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Assert.assertEquals((Object)"EmptyCase", (Object)((CaseDefinition)cases.iterator().next()).getId());
        cases = this.caseRuntimeDataService.getCasesByDeployment(this.deploymentUnit.getIdentifier(), new QueryContext(Integer.valueOf(2), Integer.valueOf(1), SORT_BY_CASE_DEFINITION_NAME, true));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Assert.assertEquals((Object)"UserTaskCase", (Object)((CaseDefinition)cases.iterator().next()).getId());
        cases = this.caseRuntimeDataService.getCasesByDeployment(this.deploymentUnit.getIdentifier(), new QueryContext(SORT_BY_CASE_DEFINITION_NAME, false));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)5L, (long)cases.size());
        ArrayList sortedCases = new ArrayList(cases);
        Assert.assertEquals((Object)"UserTaskWithStageCase", (Object)((CaseDefinition)sortedCases.get(0)).getId());
        Assert.assertEquals((Object)"UserTaskCaseBoundary", (Object)((CaseDefinition)sortedCases.get(1)).getId());
        Assert.assertEquals((Object)"UserTaskCase", (Object)((CaseDefinition)sortedCases.get(2)).getId());
        Assert.assertEquals((Object)"EmptyCase", (Object)((CaseDefinition)sortedCases.get(3)).getId());
    }

    @Test
    public void testGetCaseDefinitionsByFilter() {
        Collection cases = this.caseRuntimeDataService.getCases("empty", new QueryContext());
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Map mappedCases = this.mapCases(cases);
        Assert.assertTrue((boolean)mappedCases.containsKey("EmptyCase"));
        cases = this.caseRuntimeDataService.getCases("User", new QueryContext());
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)3L, (long)cases.size());
        mappedCases = this.mapCases(cases);
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskCase"));
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskCaseBoundary"));
        Assert.assertTrue((boolean)mappedCases.containsKey("UserTaskWithStageCase"));
        cases = this.caseRuntimeDataService.getCases("nomatch", new QueryContext());
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)0L, (long)cases.size());
    }

    @Test
    public void testGetCaseDefinitionsByFilterSorted() {
        Collection cases = this.caseRuntimeDataService.getCases("User", new QueryContext(Integer.valueOf(0), Integer.valueOf(1), SORT_BY_CASE_DEFINITION_NAME, true));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Assert.assertEquals((Object)"UserTaskCase", (Object)((CaseDefinition)cases.iterator().next()).getId());
        cases = this.caseRuntimeDataService.getCases("User", new QueryContext(Integer.valueOf(1), Integer.valueOf(1), SORT_BY_CASE_DEFINITION_NAME, true));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)1L, (long)cases.size());
        Assert.assertEquals((Object)"UserTaskCaseBoundary", (Object)((CaseDefinition)cases.iterator().next()).getId());
        cases = this.caseRuntimeDataService.getCases("User", new QueryContext(SORT_BY_CASE_DEFINITION_NAME, false));
        Assert.assertNotNull((Object)cases);
        Assert.assertEquals((long)3L, (long)cases.size());
        ArrayList sortedCases = new ArrayList(cases);
        Assert.assertEquals((Object)"UserTaskWithStageCase", (Object)((CaseDefinition)sortedCases.get(0)).getId());
        Assert.assertEquals((Object)"UserTaskCaseBoundary", (Object)((CaseDefinition)sortedCases.get(1)).getId());
        Assert.assertEquals((Object)"UserTaskCase", (Object)((CaseDefinition)sortedCases.get(2)).getId());
    }

    @Test
    public void testGetCaseDefinitionById() {
        CaseDefinition caseDef = this.caseRuntimeDataService.getCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCase");
        Assert.assertNotNull((Object)caseDef);
        Assert.assertEquals((Object)"UserTaskWithStageCase", (Object)caseDef.getId());
        Assert.assertEquals((Object)"UserTaskWithStageCase", (Object)caseDef.getName());
        Assert.assertEquals((Object)"1.0", (Object)caseDef.getVersion());
        Assert.assertEquals((Object)"CASE", (Object)caseDef.getIdentifierPrefix());
        Assert.assertNotNull((Object)caseDef.getCaseMilestones());
        Assert.assertEquals((long)0L, (long)caseDef.getCaseMilestones().size());
        Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
        Assert.assertNotNull((Object)caseDef.getCaseStages());
        Assert.assertEquals((long)1L, (long)caseDef.getCaseStages().size());
        Map mappedStages = this.mapStages(caseDef.getCaseStages());
        Assert.assertTrue((boolean)mappedStages.containsKey("Collect input"));
        CaseStage caseStage = (CaseStage)mappedStages.get("Collect input");
        Assert.assertNotNull((Object)caseStage);
        Assert.assertEquals((Object)"Collect input", (Object)caseStage.getName());
        Assert.assertEquals((long)2L, (long)caseStage.getAdHocFragments().size());
        Map mappedFragments = this.mapAdHocFragments(caseStage.getAdHocFragments());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Missing data"));
        Assert.assertEquals((Object)"HumanTaskNode", (Object)((AdHocFragment)mappedFragments.get("Missing data")).getType());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Verification of data"));
        Assert.assertEquals((Object)"SubProcessNode", (Object)((AdHocFragment)mappedFragments.get("Verification of data")).getType());
        Assert.assertNotNull((Object)caseDef.getCaseRoles());
        Assert.assertEquals((long)3L, (long)caseDef.getCaseRoles().size());
        Map mappedRoles = this.mapRoles(caseDef.getCaseRoles());
        Assert.assertTrue((boolean)mappedRoles.containsKey("owner"));
        Assert.assertTrue((boolean)mappedRoles.containsKey("contact"));
        Assert.assertTrue((boolean)mappedRoles.containsKey("participant"));
        Assert.assertEquals((long)1L, (long)((CaseRole)mappedRoles.get("owner")).getCardinality().intValue());
        Assert.assertEquals((long)2L, (long)((CaseRole)mappedRoles.get("contact")).getCardinality().intValue());
        Assert.assertEquals((long)-1L, (long)((CaseRole)mappedRoles.get("participant")).getCardinality().intValue());
    }

    @Test
    public void testGetCaseDefinitionByIdWithBoundaryEvent() {
        CaseDefinition caseDef = this.caseRuntimeDataService.getCase(this.deploymentUnit.getIdentifier(), "UserTaskCaseBoundary");
        Assert.assertNotNull((Object)caseDef);
        Assert.assertEquals((Object)"UserTaskCaseBoundary", (Object)caseDef.getId());
        Assert.assertEquals((Object)"Simple Case with User Tasks and Boundary", (Object)caseDef.getName());
        Assert.assertEquals((Object)"1.0", (Object)caseDef.getVersion());
        Assert.assertEquals((Object)"HR", (Object)caseDef.getIdentifierPrefix());
        Assert.assertEquals((long)2L, (long)caseDef.getCaseMilestones().size());
        Assert.assertEquals((long)0L, (long)caseDef.getCaseStages().size());
        Assert.assertEquals((long)3L, (long)caseDef.getAdHocFragments().size());
        Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)caseDef.getDeploymentId());
        Map mappedMilestones = this.mapMilestones(caseDef.getCaseMilestones());
        Assert.assertTrue((boolean)mappedMilestones.containsKey("Milestone1"));
        Assert.assertTrue((boolean)mappedMilestones.containsKey("Milestone2"));
        Map mappedFragments = this.mapAdHocFragments(caseDef.getAdHocFragments());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Hello2"));
        Assert.assertEquals((Object)"HumanTaskNode", (Object)((AdHocFragment)mappedFragments.get("Hello2")).getType());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Milestone1"));
        Assert.assertEquals((Object)"MilestoneNode", (Object)((AdHocFragment)mappedFragments.get("Milestone1")).getType());
        Assert.assertTrue((boolean)mappedFragments.containsKey("Milestone2"));
        Assert.assertEquals((Object)"MilestoneNode", (Object)((AdHocFragment)mappedFragments.get("Milestone2")).getType());
        Assert.assertNotNull((Object)caseDef.getCaseRoles());
        Assert.assertEquals((long)3L, (long)caseDef.getCaseRoles().size());
        Map mappedRoles = this.mapRoles(caseDef.getCaseRoles());
        Assert.assertTrue((boolean)mappedRoles.containsKey("owner"));
        Assert.assertTrue((boolean)mappedRoles.containsKey("contact"));
        Assert.assertTrue((boolean)mappedRoles.containsKey("participant"));
        Assert.assertEquals((long)1L, (long)((CaseRole)mappedRoles.get("owner")).getCardinality().intValue());
        Assert.assertEquals((long)2L, (long)((CaseRole)mappedRoles.get("contact")).getCardinality().intValue());
        Assert.assertEquals((long)-1L, (long)((CaseRole)mappedRoles.get("participant")).getCardinality().intValue());
    }
}

