/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.api.AdHocFragmentNotFoundException;
import org.jbpm.casemgmt.api.StageNotFoundException;
import org.jbpm.casemgmt.api.dynamic.TaskSpecification;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.CaseStage;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CaseStageInstance;
import org.jbpm.casemgmt.impl.model.instance.CaseInstanceImpl;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.junit.Test;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;

public class StageCompletionConditionTest
extends AbstractCaseServicesBaseTest {
    private static final String STAGE_WITH_TASK_AUTOCOMPLETE = "StageWithTaskAutocomplete";
    private static final String STAGE_WITH_TASK_COUNT = "StageWithTaskCount";
    private static final String STAGE_WITH_TASK_NO_AUTOSTART = "StageWithTaskNoAutoStart";
    private static final String STAGE_WITH_TASK_PROCESS_VARIABLE = "StageWithTaskProcessVariable";
    private static final String STAGE_WITH_TASK_CASE_FILE_VARIABLE = "StageWithTaskCaseFileVariable";
    private static final String STAGE_WITH_TASK_CASE_FILE_VARIABLE_NO_PREFIX = "StageWithTaskCaseFileVariableNoPrefix";
    private static final String STAGE_WITH_TASK_CASE_DATA_BOOLEAN = "StageWithTaskCaseDataBoolean";
    private static final String STAGE_WITH_TASK_CASE_DATA_INTEGER = "StageWithTaskCaseDataInteger";
    private static final String STAGE_WITH_TASK_CASE_DATA_STRING = "StageWithTaskCaseDataString";
    private static final String STAGE_WITH_TASK_CASE_FILE_AND_PROCESS_VARIABLE = "StageWithTaskCaseFileAndProcessVariable";
    private static final String USER_TASK_PROCESS = "UserTask";
    private static final String INSIDE_TASK = "InsideTask";
    private static final String DYNAMIC_TASK = "DynamicTask";
    private static final String HELLO_TASK = "Hello";

    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/stage/completion/StageWithTaskAutocomplete.bpmn2");
        processes.add("cases/stage/completion/StageWithTaskCount.bpmn2");
        processes.add("cases/stage/completion/StageWithTaskNoAutoStart.bpmn2");
        processes.add("cases/stage/completion/StageWithTaskProcessVariable.bpmn2");
        processes.add("cases/stage/completion/StageWithTaskCaseFileVariable.bpmn2");
        processes.add("cases/stage/completion/StageWithTaskCaseFileVariableNoPrefix.bpmn2");
        processes.add("cases/stage/completion/StageWithTaskCaseDataBoolean.bpmn2");
        processes.add("cases/stage/completion/StageWithTaskCaseDataInteger.bpmn2");
        processes.add("cases/stage/completion/StageWithTaskCaseDataString.bpmn2");
        processes.add("cases/stage/completion/StageWithTaskCaseFileAndProcessVariable.bpmn2");
        processes.add("processes/UserTaskProcess.bpmn2");
        return processes;
    }

    @Test
    public void testAutoComplete() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_AUTOCOMPLETE);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", null);
        this.assertCaseInstanceNotActive(caseId);
    }

    @Test
    public void testAutoCompleteNoAutoStartTask() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_NO_AUTOSTART);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).isEmpty();
        this.caseService.triggerAdHocFragment(caseId, INSIDE_TASK, null);
        this.assertCaseInstanceActive(caseId);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary insideTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)insideTask.getName()).isEqualTo((Object)INSIDE_TASK);
        this.userTaskService.completeAutoProgress(insideTask.getId(), "john", null);
        this.assertCaseInstanceNotActive(caseId);
    }

    @Test
    public void testAutoCompleteDynamicTask() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_AUTOCOMPLETE);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary insideTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)insideTask.getName()).isEqualTo((Object)INSIDE_TASK);
        CaseInstance caseInstance = this.caseService.getCaseInstance(caseId, false, false, false, true);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        Assertions.assertThat((Iterable)caseInstance.getCaseStages()).hasSize(1);
        String stageId = ((CaseStageInstance)caseInstance.getCaseStages().iterator().next()).getId();
        TaskSpecification dynamicTaskSpecification = this.caseService.newHumanTaskSpec(DYNAMIC_TASK, "", "john", null, Collections.emptyMap());
        this.caseService.addDynamicTaskToStage(caseId, stageId, dynamicTaskSpecification);
        this.userTaskService.completeAutoProgress(insideTask.getId(), "john", null);
        this.assertCaseInstanceActive(caseId);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary dynamicTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)dynamicTask.getName()).isEqualTo((Object)DYNAMIC_TASK);
        this.userTaskService.completeAutoProgress(dynamicTask.getId(), "john", null);
        this.assertCaseInstanceNotActive(caseId);
    }

    @Test
    public void testAutoCompleteDynamicSubProcess() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_AUTOCOMPLETE);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary insideTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)insideTask.getName()).isEqualTo((Object)INSIDE_TASK);
        CaseInstance caseInstance = this.caseService.getCaseInstance(caseId, false, false, false, true);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        Assertions.assertThat((Iterable)caseInstance.getCaseStages()).hasSize(1);
        String stageId = ((CaseStageInstance)caseInstance.getCaseStages().iterator().next()).getId();
        this.caseService.addDynamicSubprocessToStage(caseId, stageId, USER_TASK_PROCESS, Collections.emptyMap());
        this.userTaskService.completeAutoProgress(insideTask.getId(), "john", null);
        this.assertCaseInstanceActive(caseId);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary dynamicTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)dynamicTask.getName()).isEqualTo((Object)HELLO_TASK);
        this.userTaskService.completeAutoProgress(dynamicTask.getId(), "john", null);
        this.assertCaseInstanceNotActive(caseId);
    }

    @Test
    public void testNoActiveTasksCondition() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_COUNT);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        CaseInstance caseInstance = this.caseService.getCaseInstance(caseId);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        Long processInstanceId = ((CaseInstanceImpl)caseInstance).getProcessInstanceId();
        this.processService.setProcessVariable(processInstanceId, "taskCount", (Object)0);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", null);
        this.assertCaseInstanceNotActive(caseId);
    }

    @Test
    public void testProcessVariable() {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("continue", false);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_PROCESS_VARIABLE, data, Collections.emptyMap());
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_PROCESS_VARIABLE, caseFile);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        CaseInstance caseInstance = this.caseService.getCaseInstance(caseId);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        Long processInstanceId = ((CaseInstanceImpl)caseInstance).getProcessInstanceId();
        this.processService.setProcessVariable(processInstanceId, "continue", (Object)false);
        this.caseService.addDataToCaseFile(caseId, "continue", (Object)true, new String[0]);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary insideTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)insideTask.getName()).isEqualTo((Object)INSIDE_TASK);
        this.userTaskService.completeAutoProgress(insideTask.getId(), "john", null);
        this.assertCaseInstanceActive(caseId);
        this.processService.setProcessVariable(processInstanceId, "continue", (Object)true);
        caseInstance = this.caseService.getCaseInstance(caseId, false, false, false, true);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        Assertions.assertThat((Iterable)caseInstance.getCaseStages()).hasSize(1);
        String stageId = ((CaseStageInstance)caseInstance.getCaseStages().iterator().next()).getId();
        TaskSpecification dynamicTaskSpecification = this.caseService.newHumanTaskSpec(DYNAMIC_TASK, "", "john", null, Collections.emptyMap());
        this.caseService.addDynamicTaskToStage(caseId, stageId, dynamicTaskSpecification);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary dynamicTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)dynamicTask.getName()).isEqualTo((Object)DYNAMIC_TASK);
        this.userTaskService.completeAutoProgress(dynamicTask.getId(), "john", null);
        this.assertCaseInstanceNotActive(caseId);
    }

    @Test
    public void testCaseFileVariable() {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("continue", false);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_CASE_FILE_VARIABLE, data, Collections.emptyMap());
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_CASE_FILE_VARIABLE, caseFile);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary insideTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)insideTask.getName()).isEqualTo((Object)INSIDE_TASK);
        this.userTaskService.completeAutoProgress(insideTask.getId(), "john", null);
        this.assertCaseInstanceActive(caseId);
        this.caseService.addDataToCaseFile(caseId, "continue", (Object)true, new String[0]);
        this.assertCaseInstanceActive(caseId);
        CaseInstance caseInstance = this.caseService.getCaseInstance(caseId, false, false, false, true);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        Assertions.assertThat((Iterable)caseInstance.getCaseStages()).hasSize(1);
        String stageId = ((CaseStageInstance)caseInstance.getCaseStages().iterator().next()).getId();
        TaskSpecification dynamicTaskSpecification = this.caseService.newHumanTaskSpec(DYNAMIC_TASK, "", "john", null, Collections.emptyMap());
        this.caseService.addDynamicTaskToStage(caseId, stageId, dynamicTaskSpecification);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary dynamicTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)dynamicTask.getName()).isEqualTo((Object)DYNAMIC_TASK);
        this.userTaskService.completeAutoProgress(dynamicTask.getId(), "john", null);
        this.assertCaseInstanceNotActive(caseId);
    }

    @Test
    public void testCaseFileVariableWithoutPrefix() {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("continue", false);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_CASE_FILE_VARIABLE_NO_PREFIX, data, Collections.emptyMap());
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_CASE_FILE_VARIABLE_NO_PREFIX, caseFile);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        this.caseService.addDataToCaseFile(caseId, "continue", (Object)true, new String[0]);
        this.assertCaseInstanceActive(caseId);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary insideTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)insideTask.getName()).isEqualTo((Object)INSIDE_TASK);
        this.userTaskService.completeAutoProgress(insideTask.getId(), "john", null);
        this.assertCaseInstanceNotActive(caseId);
    }

    @Test
    public void testCaseFileVariableWithProcessVariable() {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("continue", false);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_CASE_FILE_AND_PROCESS_VARIABLE, data, Collections.emptyMap());
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_CASE_FILE_AND_PROCESS_VARIABLE, caseFile);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        CaseInstance caseInstance = this.caseService.getCaseInstance(caseId);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        Long processInstanceId = ((CaseInstanceImpl)caseInstance).getProcessInstanceId();
        this.processService.setProcessVariable(processInstanceId, "continue", (Object)true);
        this.assertCaseInstanceActive(caseId);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary insideTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)insideTask.getName()).isEqualTo((Object)INSIDE_TASK);
        this.userTaskService.completeAutoProgress(insideTask.getId(), "john", null);
        this.assertCaseInstanceActive(caseId);
        this.caseService.addDataToCaseFile(caseId, "continue", (Object)true, new String[0]);
        this.assertCaseInstanceActive(caseId);
        caseInstance = this.caseService.getCaseInstance(caseId, false, false, false, true);
        Assertions.assertThat((Object)caseInstance).isNotNull();
        Assertions.assertThat((Iterable)caseInstance.getCaseStages()).hasSize(1);
        String stageId = ((CaseStageInstance)caseInstance.getCaseStages().iterator().next()).getId();
        TaskSpecification dynamicTaskSpecification = this.caseService.newHumanTaskSpec(DYNAMIC_TASK, "", "john", null, Collections.emptyMap());
        this.caseService.addDynamicTaskToStage(caseId, stageId, dynamicTaskSpecification);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary dynamicTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)dynamicTask.getName()).isEqualTo((Object)DYNAMIC_TASK);
        this.userTaskService.completeAutoProgress(dynamicTask.getId(), "john", null);
        this.assertCaseInstanceNotActive(caseId);
    }

    @Test
    public void testCaseDataVariableBoolean() {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("continue", false);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_CASE_DATA_BOOLEAN, data, Collections.emptyMap());
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_CASE_DATA_BOOLEAN, caseFile);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        this.caseService.addDataToCaseFile(caseId, "continue", (Object)true, new String[0]);
        this.assertCaseInstanceNotActive(caseId);
    }

    @Test
    public void testCaseDataVariableInteger() {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("continue", 0);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_CASE_DATA_INTEGER, data, Collections.emptyMap());
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_CASE_DATA_INTEGER, caseFile);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        this.caseService.addDataToCaseFile(caseId, "continue", (Object)1, new String[0]);
        this.assertCaseInstanceNotActive(caseId);
    }

    @Test
    public void testCaseDataVariableString() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("continue", "wait");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_CASE_DATA_STRING, data, Collections.emptyMap());
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_CASE_DATA_STRING, caseFile);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        this.caseService.addDataToCaseFile(caseId, "continue", (Object)"continue", new String[0]);
        this.assertCaseInstanceNotActive(caseId);
    }

    @Test
    public void testCaseDataVariableCompleteTask() {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("continue", false);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_CASE_DATA_BOOLEAN, data, Collections.emptyMap());
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_CASE_DATA_BOOLEAN, caseFile);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary insideTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)insideTask.getName()).isEqualTo((Object)INSIDE_TASK);
        this.userTaskService.completeAutoProgress(insideTask.getId(), "john", null);
        this.assertCaseInstanceActive(caseId);
        this.caseService.addDataToCaseFile(caseId, "continue", (Object)true, new String[0]);
        this.assertCaseInstanceNotActive(caseId);
    }

    @Test
    public void testAutoCompleteNoAutoStartTaskAdHocInStage() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_NO_AUTOSTART);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).isEmpty();
        CaseDefinition caseDef = this.caseRuntimeDataService.getCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_NO_AUTOSTART);
        Collection stages = caseDef.getCaseStages();
        Assertions.assertThat((Iterable)stages).hasSize(1);
        String stageId = ((CaseStage)stages.iterator().next()).getId();
        this.caseService.triggerAdHocFragment(caseId, stageId, INSIDE_TASK, null);
        this.assertCaseInstanceActive(caseId);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary insideTask = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)insideTask.getName()).isEqualTo((Object)INSIDE_TASK);
        this.userTaskService.completeAutoProgress(insideTask.getId(), "john", null);
        this.assertCaseInstanceNotActive(caseId);
    }

    @Test
    public void testAutoCompleteNoAutoStartTaskAdHocInNotExistingStage() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_NO_AUTOSTART);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).isEmpty();
        String stageId = "not existing";
        Assertions.assertThatExceptionOfType(StageNotFoundException.class).isThrownBy(() -> this.caseService.triggerAdHocFragment(caseId, stageId, INSIDE_TASK, null)).withMessageContaining("No stage found with id " + stageId);
        this.assertCaseInstanceActive(caseId);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(0);
        this.caseService.cancelCase(caseId);
        this.assertCaseInstanceNotActive(caseId);
    }

    @Test
    public void testAutoCompleteNoAutoStartTaskNotExistingAdHocInStage() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_NO_AUTOSTART);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).isEmpty();
        CaseDefinition caseDef = this.caseRuntimeDataService.getCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_TASK_NO_AUTOSTART);
        Collection stages = caseDef.getCaseStages();
        Assertions.assertThat((Iterable)stages).hasSize(1);
        String stageId = ((CaseStage)stages.iterator().next()).getId();
        Assertions.assertThatExceptionOfType(AdHocFragmentNotFoundException.class).isThrownBy(() -> this.caseService.triggerAdHocFragment(caseId, stageId, "not existing", null)).withMessageContaining("AdHoc fragment 'not existing' not found in case " + caseId + " and stage " + stageId);
        this.assertCaseInstanceActive(caseId);
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assertions.assertThat((List)tasks).hasSize(0);
        this.caseService.cancelCase(caseId);
        this.assertCaseInstanceNotActive(caseId);
    }
}

