/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.services.api.model.ProcessInstanceWithVarsDesc;
import org.jbpm.services.api.model.UserTaskInstanceWithPotOwnerDesc;
import org.jbpm.services.api.query.model.QueryParam;
import org.jbpm.services.task.impl.model.UserImpl;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.query.QueryContext;

public class AdvanceCaseRuntimeDataServiceImplTest
extends AbstractCaseServicesBaseTest {
    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/EmptyCase.bpmn2");
        processes.add("cases/UserTaskCase.bpmn2");
        return processes;
    }

    @Test
    public void testSearchByVariable() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        List vars = QueryParam.list((QueryParam[])new QueryParam[]{QueryParam.equalsTo((String)"name", (Comparable[])new Comparable[]{"my first case"})});
        List process = this.advanceCaseRuntimeDataService.queryCaseByVariables(Collections.emptyList(), vars, new QueryContext());
        Assert.assertEquals((long)1L, (long)process.size());
        Assert.assertEquals((Object)"my first case", ((ProcessInstanceWithVarsDesc)process.get(0)).getExtraData().get("name"));
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        this.caseService.cancelCase(caseId);
    }

    @Test
    public void testSearchUserByVariable() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "my first case");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskCase", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskCase", caseFile);
        List process = this.advanceCaseRuntimeDataService.queryUserTasksByVariables(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), new QueryContext());
        Assert.assertEquals((long)1L, (long)process.size());
        Assert.assertEquals((Object)"my first case", ((UserTaskInstanceWithPotOwnerDesc)process.get(0)).getExtraData().get("name"));
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"HR-0000000001", (Object)caseId);
        this.caseService.cancelCase(caseId);
    }
}

