/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.event;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.core.event.AbstractEventSupport;
import org.jbpm.casemgmt.api.event.CaseEventListener;
import org.jbpm.casemgmt.impl.audit.CaseInstanceAuditLoggerFactory;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.casemgmt.impl.wih.NotifyParentCaseEventListener;
import org.jbpm.runtime.manager.impl.PerCaseRuntimeManager;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.runtime.Cacheable;
import org.kie.internal.runtime.Closeable;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.ObjectModelResolver;
import org.kie.internal.runtime.conf.ObjectModelResolverProvider;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseConfigurationDeploymentListener
implements DeploymentEventListener {
    private static final Logger logger = LoggerFactory.getLogger(CaseConfigurationDeploymentListener.class);
    private IdentityProvider identityProvider;
    private TransactionalCommandService transactionalCommandService;

    public CaseConfigurationDeploymentListener(IdentityProvider identityProvider) {
        this(identityProvider, null);
    }

    public CaseConfigurationDeploymentListener(IdentityProvider identityProvider, TransactionalCommandService transactionalCommandService) {
        this.identityProvider = identityProvider;
        this.transactionalCommandService = transactionalCommandService;
    }

    public void onDeploy(DeploymentEvent event) {
        InternalRuntimeManager runtimeManager = (InternalRuntimeManager)event.getDeployedUnit().getRuntimeManager();
        if (runtimeManager instanceof PerCaseRuntimeManager) {
            List<CaseEventListener> caseEventListeners = this.getEventListenerFromDescriptor(runtimeManager);
            logger.debug("Adding following case event listeners {} for deployment {}", caseEventListeners, (Object)event.getDeploymentId());
            TransactionalCommandService commandService = this.transactionalCommandService;
            if (commandService == null) {
                commandService = new TransactionalCommandService(((SimpleRuntimeEnvironment)runtimeManager.getEnvironment()).getEmf());
            }
            CaseEventListener auditEventListener = this.getCaseAuditEventListener(runtimeManager, commandService);
            caseEventListeners.add(auditEventListener);
            caseEventListeners.add(new NotifyParentCaseEventListener(this.identityProvider, (RuntimeManager)runtimeManager));
            CaseEventSupport caseEventSupport = new CaseEventSupport(this.identityProvider, caseEventListeners);
            ((PerCaseRuntimeManager)runtimeManager).setCaseEventSupport((AbstractEventSupport)caseEventSupport);
            logger.debug("CaseEventSupport configured for deployment {}", (Object)event.getDeploymentId());
        }
    }

    public void onUnDeploy(DeploymentEvent event) {
        CaseEventSupport caseEventSupport;
        InternalRuntimeManager runtimeManager = (InternalRuntimeManager)event.getDeployedUnit().getRuntimeManager();
        if (runtimeManager instanceof PerCaseRuntimeManager && (caseEventSupport = (CaseEventSupport)((PerCaseRuntimeManager)runtimeManager).getCaseEventSupport()) != null) {
            caseEventSupport.reset();
            logger.debug("CaseEventSupport disposed for deployment {}", (Object)event.getDeploymentId());
        }
    }

    public void onActivate(DeploymentEvent event) {
    }

    public void onDeactivate(DeploymentEvent event) {
    }

    protected List<CaseEventListener> getEventListenerFromDescriptor(InternalRuntimeManager runtimeManager) {
        ArrayList<CaseEventListener> listeners = new ArrayList<CaseEventListener>();
        DeploymentDescriptor descriptor = runtimeManager.getDeploymentDescriptor();
        if (descriptor != null) {
            Map<String, Object> params = this.getParametersMap(runtimeManager);
            for (ObjectModel model : descriptor.getEventListeners()) {
                ObjectModelResolver resolver = ObjectModelResolverProvider.get((String)model.getResolver());
                if (resolver == null) {
                    logger.warn("Unable to find ObjectModelResolver for {}", (Object)model.getResolver());
                    continue;
                }
                try {
                    Object listenerInstance = resolver.getInstance(model, runtimeManager.getEnvironment().getClassLoader(), params);
                    if (listenerInstance != null && CaseEventListener.class.isAssignableFrom(listenerInstance.getClass())) {
                        listeners.add((CaseEventListener)listenerInstance);
                        continue;
                    }
                    if (!(listenerInstance instanceof Closeable) || listenerInstance instanceof Cacheable) continue;
                    ((Closeable)listenerInstance).close();
                }
                catch (Exception e) {
                    logger.debug("Unable to build listener {}", (Object)model);
                }
            }
        }
        return listeners;
    }

    protected Map<String, Object> getParametersMap(InternalRuntimeManager runtimeManager) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("runtimeManager", runtimeManager);
        parameters.put("classLoader", runtimeManager.getEnvironment().getClassLoader());
        parameters.put("entityManagerFactory", ((SimpleRuntimeEnvironment)runtimeManager.getEnvironment()).getEmf());
        parameters.put("kieContainer", runtimeManager.getKieContainer());
        parameters.put("identityProvider", ((SimpleRuntimeEnvironment)runtimeManager.getEnvironment()).getEnvironmentTemplate().get("org.kie.internal.identity.IdentityProvider"));
        return parameters;
    }

    protected CaseEventListener getCaseAuditEventListener(InternalRuntimeManager manager, TransactionalCommandService commandService) {
        DeploymentDescriptor descriptor = manager.getDeploymentDescriptor();
        if (descriptor == null) {
            return CaseInstanceAuditLoggerFactory.newJPAInstance(commandService);
        }
        if (descriptor.getAuditMode() == AuditMode.JPA) {
            if (descriptor.getPersistenceUnit().equals(descriptor.getAuditPersistenceUnit())) {
                return CaseInstanceAuditLoggerFactory.newJPAInstance(commandService);
            }
            return CaseInstanceAuditLoggerFactory.newJPAInstance(EntityManagerFactoryManager.get().getOrCreate(descriptor.getAuditPersistenceUnit()));
        }
        if (descriptor.getAuditMode() == AuditMode.JMS) {
            try {
                Properties properties = new Properties();
                InputStream input = manager.getEnvironment().getClassLoader().getResourceAsStream("/jbpm.audit.jms.properties");
                if (input == null) {
                    input = manager.getEnvironment().getClassLoader().getResourceAsStream("jbpm.audit.jms.properties");
                }
                properties.load(input);
                return CaseInstanceAuditLoggerFactory.newJMSInstance(properties);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create JMS audit logger", e);
            }
        }
        logger.warn("Audit mode {} is not supported for CaseInstance audit logs", (Object)descriptor.getAuditMode());
        return CaseInstanceAuditLoggerFactory.newJPAInstance(commandService);
    }
}

