/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.model.instance;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.jbpm.casemgmt.api.model.instance.CaseRoleInstance;
import org.kie.api.task.model.OrganizationalEntity;

public class CaseRoleInstanceImpl
implements CaseRoleInstance,
Serializable {
    private static final long serialVersionUID = 6062519787106306778L;
    private String roleName;
    private Integer cardinality;
    private Collection<OrganizationalEntity> roleAssignments;

    public CaseRoleInstanceImpl(String roleName, Integer cardinality) {
        this.roleName = roleName;
        this.cardinality = cardinality;
        this.roleAssignments = new ArrayList<OrganizationalEntity>();
    }

    public CaseRoleInstanceImpl(String roleName, Collection<OrganizationalEntity> roleAssignments) {
        this.roleName = roleName;
        this.roleAssignments = roleAssignments;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public Collection<OrganizationalEntity> getRoleAssignments() {
        return this.roleAssignments;
    }

    public void addRoleAssignment(OrganizationalEntity entity) {
        if (this.cardinality != null && this.cardinality > 0 && this.cardinality < this.roleAssignments.size() + 1) {
            throw new IllegalArgumentException("Cannot add more users for role " + this.roleName + ", maximum cardinality " + this.cardinality + " already reached");
        }
        this.roleAssignments.add(entity);
    }

    public void removeRoleAssignment(OrganizationalEntity entity) {
        this.roleAssignments.remove(entity);
    }

    public String toString() {
        return "CaseRoleInstanceImpl [roleName=" + this.roleName + ", cardinality=" + this.cardinality + ",roleAssignments=" + this.roleAssignments + "]";
    }
}

