/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.jbpm.casemgmt.impl.event.CommentNotificationEventListener;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.casemgmt.impl.util.CommentNotificationEventListenerFactory;
import org.jbpm.casemgmt.impl.util.TestNotificationPublisher;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.task.impl.model.UserImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.internal.utils.NotificationPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseCommentNotificationTest
extends AbstractCaseServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(CaseCommentNotificationTest.class);

    @After
    public void reset() {
        CommentNotificationEventListenerFactory.removeExisting("test");
    }

    @Override
    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/UserTaskWithStageCaseAutoStart.bpmn2");
        return processes;
    }

    @Override
    protected DeploymentUnit prepareDeploymentUnit() {
        Assertions.assertThat((Object)this.deploymentService).isNotNull();
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.cases", "case-module", "1.0.0-SNAPSHOT");
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl();
        descriptor.getBuilder().addEventListener(new ObjectModel("mvel", "new org.jbpm.kie.services.impl.IdentityProviderAwareProcessListener(ksession)", new Object[0])).addEventListener(new ObjectModel("mvel", "org.jbpm.casemgmt.impl.util.CommentNotificationEventListenerFactory.get(\"test\")", new Object[0]));
        deploymentUnit.setDeploymentDescriptor((DeploymentDescriptor)descriptor);
        deploymentUnit.setStrategy(RuntimeStrategy.PER_CASE);
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        return deploymentUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommentsNotificationWithoutTemplate() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        TestNotificationPublisher publisher = new TestNotificationPublisher(true);
        CommentNotificationEventListener listener = CommentNotificationEventListenerFactory.get("test");
        listener.addPublisher((NotificationPublisher)publisher);
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Collection caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)0L, (long)caseComments.size());
            this.caseService.addCaseComment("CASE-0000000001", "poul", "just a tiny comment refering to @owner", new String[0]);
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)1L, (long)caseComments.size());
            CommentInstance comment = (CommentInstance)caseComments.iterator().next();
            this.assertComment(comment, "poul", "just a tiny comment refering to @owner");
            String expectedNotification = "Publishing notification from cases@jbpm.org, with subject You have been mentioned in case (CASE-0000000001) comment to [[UserImpl:'john']] with body just a tiny comment refering to john";
            List<String> published = publisher.get();
            Assertions.assertThat(published).hasSize(1);
            Assertions.assertThat((String)published.get(0)).isEqualTo((Object)expectedNotification);
            this.caseService.updateCaseComment("CASE-0000000001", comment.getId(), comment.getAuthor(), "Updated " + comment.getComment(), new String[0]);
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)1L, (long)caseComments.size());
            comment = (CommentInstance)caseComments.iterator().next();
            this.assertComment(comment, "poul", "Updated just a tiny comment refering to @owner");
            expectedNotification = "Publishing notification from cases@jbpm.org, with subject You have been mentioned in case (CASE-0000000001) comment to [[UserImpl:'john']] with body Updated just a tiny comment refering to john";
            published = publisher.get();
            Assertions.assertThat(published).hasSize(1);
            Assertions.assertThat((String)published.get(0)).isEqualTo((Object)expectedNotification);
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommentsNotificationWithTemplate() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        TestNotificationPublisher publisher = new TestNotificationPublisher(false);
        CommentNotificationEventListener listener = CommentNotificationEventListenerFactory.get("test");
        listener.addPublisher((NotificationPublisher)publisher);
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "UserTaskWithStageCaseAutoStart", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Collection caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)0L, (long)caseComments.size());
            this.caseService.addCaseComment("CASE-0000000001", "poul", "just a tiny comment refering to @owner", new String[0]);
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)1L, (long)caseComments.size());
            CommentInstance comment = (CommentInstance)caseComments.iterator().next();
            this.assertComment(comment, "poul", "just a tiny comment refering to @owner");
            String expectedNotification = "Publishing notification from cases@jbpm.org, with subject You have been mentioned in case (CASE-0000000001) comment to [[UserImpl:'john']] with template mentioned-in-comment";
            List<String> published = publisher.get();
            Assertions.assertThat(published).hasSize(1);
            Assertions.assertThat((String)published.get(0)).isEqualTo((Object)expectedNotification);
            this.caseService.updateCaseComment("CASE-0000000001", comment.getId(), comment.getAuthor(), "Updated " + comment.getComment(), new String[0]);
            caseComments = this.caseService.getCaseComments("CASE-0000000001", new QueryContext());
            Assert.assertNotNull((Object)caseComments);
            Assert.assertEquals((long)1L, (long)caseComments.size());
            comment = (CommentInstance)caseComments.iterator().next();
            this.assertComment(comment, "poul", "Updated just a tiny comment refering to @owner");
            expectedNotification = "Publishing notification from cases@jbpm.org, with subject You have been mentioned in case (CASE-0000000001) comment to [[UserImpl:'john']] with template mentioned-in-comment";
            published = publisher.get();
            Assertions.assertThat(published).hasSize(1);
            Assertions.assertThat((String)published.get(0)).isEqualTo((Object)expectedNotification);
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }
}

