/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.junit.Test;
import org.kie.api.runtime.query.QueryContext;

public class StageActivationConditionTest
extends AbstractCaseServicesBaseTest {
    private static final String STAGE_WITH_ACTIVATION_COND = "NoStartNodeAdhocCaseWithActivationCondition";

    @Override
    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/stage/activation/NoStartNodeAdhocCaseWithActivationCondition.bpmn2");
        return processes;
    }

    @Test
    public void testAutoComplete() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), STAGE_WITH_ACTIVATION_COND);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)caseId).isNotNull()).isEqualTo((Object)"CASE-0000000001");
        this.assertCaseInstanceActive(caseId);
        Collection activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
        Assertions.assertThat((Iterable)activeStages).hasSize(0);
        this.caseService.addDataToCaseFile(caseId, "readyToActivate", (Object)true, new String[0]);
        activeStages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
        Assertions.assertThat((Iterable)activeStages).hasSize(1);
        this.caseService.addDataToCaseFile(caseId, "readyToComplete", (Object)true, new String[0]);
        this.assertCaseInstanceNotActive(caseId);
    }
}

