/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.api.dynamic.TaskSpecification;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.task.impl.model.UserImpl;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubCaseServiceImplTest
extends AbstractCaseServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(SubCaseServiceImplTest.class);
    protected static final String BASIC_SUB_CASE_P_ID = "CaseWithSubCase";
    protected static final String SUB_CASE_ID = "SUB-0000000001";
    protected static final String PROCESS_TO_CASE_P_ID = "process2case";

    @Override
    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/CaseWithSubCase.bpmn2");
        processes.add("cases/UserTaskCase.bpmn2");
        processes.add("cases/EmptyCase.bpmn2");
        processes.add("processes/DataVerificationProcess.bpmn2");
        processes.add("processes/Process2Case.bpmn2");
        return processes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseWithSubCaseDestroySubCase() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("manager", new UserImpl("mary"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "John Doe");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), BASIC_SUB_CASE_P_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), BASIC_SUB_CASE_P_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)SUB_CASE_ID, (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            this.caseService.triggerAdHocFragment(caseId, "Sub Case", null);
            Collection caseInstances = this.caseRuntimeDataService.getCaseInstances(new QueryContext());
            Assert.assertNotNull((Object)caseInstances);
            Assert.assertEquals((long)2L, (long)caseInstances.size());
            Map<String, CaseInstance> byCaseId = caseInstances.stream().collect(Collectors.toMap(CaseInstance::getCaseId, c -> c));
            Assert.assertTrue((boolean)byCaseId.containsKey(SUB_CASE_ID));
            Assert.assertTrue((boolean)byCaseId.containsKey("HR-0000000001"));
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner("HR-0000000001", "john", null, new QueryContext());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            Assert.assertEquals((Object)"Hello1", (Object)((TaskSummary)tasks.get(0)).getName());
            CaseFileInstance mainCaseFile = this.caseService.getCaseFileInstance(caseId);
            Assert.assertNotNull((Object)mainCaseFile);
            Assert.assertNull((Object)mainCaseFile.getData("subCaseId"));
            this.caseService.destroyCase("HR-0000000001");
            mainCaseFile = this.caseService.getCaseFileInstance(caseId);
            Assert.assertNotNull((Object)mainCaseFile);
            Assert.assertEquals((Object)"HR-0000000001", (Object)mainCaseFile.getData("subCaseId"));
            Assert.assertEquals((Object)"John Doe", (Object)mainCaseFile.getData("outcome"));
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartProcessWithSubCaseDestroySubCase() {
        Long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), PROCESS_TO_CASE_P_ID);
        Assert.assertNotNull((Object)processInstanceId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance("HR-0000000001");
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Map processVariables = this.processService.getProcessInstanceVariables(processInstanceId);
            Assert.assertNull(processVariables.get("CaseId"));
            Assert.assertNull(processVariables.get("outcome"));
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner("HR-0000000001", "john", null, new QueryContext());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            Assert.assertEquals((Object)"Hello1", (Object)((TaskSummary)tasks.get(0)).getName());
            this.caseService.destroyCase("HR-0000000001");
            processVariables = this.processService.getProcessInstanceVariables(processInstanceId);
            Assert.assertEquals((Object)"HR-0000000001", processVariables.get("CaseId"));
            Assert.assertEquals((Object)PROCESS_TO_CASE_P_ID, processVariables.get("outcome"));
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            Assert.assertEquals((Object)"Verify case results", (Object)((TaskSummary)tasks.get(0)).getName());
            Map taskInputs = this.userTaskService.getTaskInputContentByTaskId(((TaskSummary)tasks.get(0)).getId());
            Assert.assertEquals((Object)"HR-0000000001", taskInputs.get("CaseId"));
            Assert.assertEquals((Object)PROCESS_TO_CASE_P_ID, taskInputs.get("outcome"));
            this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", null);
            ProcessInstanceDesc piLog = this.runtimeDataService.getProcessInstanceById(processInstanceId.longValue());
            Assert.assertNotNull((Object)piLog);
            Assert.assertEquals((long)2L, (long)piLog.getState().intValue());
            processInstanceId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (processInstanceId != null) {
                this.processService.abortProcessInstance(processInstanceId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseWithDynamicSubCaseAbortMainCase() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "John Doe");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("CaseDefinitionId", "UserTaskCase");
            parameters.put("DeploymentId", this.deploymentUnit.getIdentifier());
            parameters.put("UserRole_owner", "john");
            parameters.put("Data_s", "#{name}");
            parameters.put("Independent", "false");
            TaskSpecification taskSpecification = this.caseService.newTaskSpec("StartCaseInstance", "Sub Case", parameters);
            this.caseService.addDynamicTask(caseId, taskSpecification);
            Collection caseInstances = this.caseRuntimeDataService.getCaseInstances(new QueryContext());
            Assert.assertNotNull((Object)caseInstances);
            Assert.assertEquals((long)2L, (long)caseInstances.size());
            Map<String, CaseInstance> byCaseId = caseInstances.stream().collect(Collectors.toMap(CaseInstance::getCaseId, c -> c));
            Assert.assertTrue((boolean)byCaseId.containsKey("CASE-0000000001"));
            Assert.assertTrue((boolean)byCaseId.containsKey("HR-0000000001"));
            this.caseService.cancelCase(caseId);
            caseId = null;
            caseInstances = this.caseRuntimeDataService.getCaseInstances(new QueryContext());
            Assert.assertNotNull((Object)caseInstances);
            Assert.assertEquals((long)0L, (long)caseInstances.size());
            caseInstances = this.caseRuntimeDataService.getCaseInstances(Arrays.asList(CaseStatus.CANCELLED), new QueryContext());
            Assert.assertNotNull((Object)caseInstances);
            Assert.assertEquals((long)2L, (long)caseInstances.size());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseWithIndependentDynamicSubCaseAbortMainCase() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "John Doe");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("CaseDefinitionId", "UserTaskCase");
            parameters.put("DeploymentId", this.deploymentUnit.getIdentifier());
            parameters.put("UserRole_owner", "john");
            parameters.put("Data_s", "#{name}");
            parameters.put("Independent", "true");
            TaskSpecification taskSpecification = this.caseService.newTaskSpec("StartCaseInstance", "Sub Case", parameters);
            this.caseService.addDynamicTask(caseId, taskSpecification);
            Collection caseInstances = this.caseRuntimeDataService.getCaseInstances(new QueryContext());
            Assert.assertNotNull((Object)caseInstances);
            Assert.assertEquals((long)2L, (long)caseInstances.size());
            Map<String, CaseInstance> byCaseId = caseInstances.stream().collect(Collectors.toMap(CaseInstance::getCaseId, c -> c));
            Assert.assertTrue((boolean)byCaseId.containsKey("CASE-0000000001"));
            Assert.assertTrue((boolean)byCaseId.containsKey("HR-0000000001"));
            this.caseService.cancelCase(caseId);
            caseId = "HR-0000000001";
            caseInstances = this.caseRuntimeDataService.getCaseInstances(new QueryContext());
            Assert.assertNotNull((Object)caseInstances);
            Assert.assertEquals((long)1L, (long)caseInstances.size());
            caseInstances = this.caseRuntimeDataService.getCaseInstances(Arrays.asList(CaseStatus.CANCELLED), new QueryContext());
            Assert.assertNotNull((Object)caseInstances);
            Assert.assertEquals((long)1L, (long)caseInstances.size());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    @Test
    public void testStartCaseWithDynamicSubCaseDestroySubCase() {
        this.testStartCaseWithDynamicSubCase("false", s -> this.caseService.destroyCase("HR-0000000001"));
    }

    @Test
    public void testStartCaseWithDynamicSubCaseCancelSubCase() {
        this.testStartCaseWithDynamicSubCase("false", s -> this.caseService.cancelCase("HR-0000000001"));
    }

    @Test
    public void testStartCaseWithDynamicSubCaseCloseSubCase() {
        this.testStartCaseWithDynamicSubCase("false", s -> this.caseService.closeCase("HR-0000000001", "I am done"));
    }

    @Test
    public void testStartCaseWithIndependentDynamicSubCaseDestroySubCase() {
        this.testStartCaseWithIndependentDynamicSubCase("true", s -> this.caseService.destroyCase("HR-0000000001"));
    }

    @Test
    public void testStartCaseWithIndependentDynamicSubCaseCancelSubCase() {
        this.testStartCaseWithIndependentDynamicSubCase("true", s -> this.caseService.cancelCase("HR-0000000001"));
    }

    @Test
    public void testStartCaseWithIndependentDynamicSubCaseCloseSubCase() {
        this.testStartCaseWithIndependentDynamicSubCase("true", s -> this.caseService.closeCase("HR-0000000001", "I am done"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStartCaseWithIndependentDynamicSubCase(String idependent, Consumer<String> finishCase) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "John Doe");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("CaseDefinitionId", "UserTaskCase");
            parameters.put("DeploymentId", this.deploymentUnit.getIdentifier());
            parameters.put("UserRole_owner", "john");
            parameters.put("Data_s", "#{name}");
            parameters.put("Independent", idependent);
            TaskSpecification taskSpecification = this.caseService.newTaskSpec("StartCaseInstance", "Sub Case", parameters);
            this.caseService.addDynamicTask(caseId, taskSpecification);
            Collection caseInstances = this.caseRuntimeDataService.getCaseInstances(new QueryContext());
            Assert.assertNotNull((Object)caseInstances);
            Assert.assertEquals((long)2L, (long)caseInstances.size());
            Map<String, CaseInstance> byCaseId = caseInstances.stream().collect(Collectors.toMap(CaseInstance::getCaseId, c -> c));
            Assert.assertTrue((boolean)byCaseId.containsKey("CASE-0000000001"));
            Assert.assertTrue((boolean)byCaseId.containsKey("HR-0000000001"));
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner("HR-0000000001", "john", null, new QueryContext());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            Assert.assertEquals((Object)"Hello1", (Object)((TaskSummary)tasks.get(0)).getName());
            CaseFileInstance mainCaseFile = this.caseService.getCaseFileInstance(caseId);
            Assert.assertNotNull((Object)mainCaseFile);
            Assert.assertEquals((Object)"HR-0000000001", (Object)mainCaseFile.getData("CaseId"));
            Assert.assertEquals((Object)"John Doe", (Object)mainCaseFile.getData("s"));
            finishCase.accept("HR-0000000001");
            mainCaseFile = this.caseService.getCaseFileInstance(caseId);
            Assert.assertNotNull((Object)mainCaseFile);
            Assert.assertEquals((Object)"HR-0000000001", (Object)mainCaseFile.getData("CaseId"));
            Assert.assertEquals((Object)"John Doe", (Object)mainCaseFile.getData("s"));
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStartCaseWithDynamicSubCase(String idependent, Consumer<String> finishCase) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "John Doe");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), "EmptyCase", data);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase", caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("CaseDefinitionId", "UserTaskCase");
            parameters.put("DeploymentId", this.deploymentUnit.getIdentifier());
            parameters.put("UserRole_owner", "john");
            parameters.put("Data_s", "#{name}");
            parameters.put("Independent", idependent);
            TaskSpecification taskSpecification = this.caseService.newTaskSpec("StartCaseInstance", "Sub Case", parameters);
            this.caseService.addDynamicTask(caseId, taskSpecification);
            Collection caseInstances = this.caseRuntimeDataService.getCaseInstances(new QueryContext());
            Assert.assertNotNull((Object)caseInstances);
            Assert.assertEquals((long)2L, (long)caseInstances.size());
            Map<String, CaseInstance> byCaseId = caseInstances.stream().collect(Collectors.toMap(CaseInstance::getCaseId, c -> c));
            Assert.assertTrue((boolean)byCaseId.containsKey("CASE-0000000001"));
            Assert.assertTrue((boolean)byCaseId.containsKey("HR-0000000001"));
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner("HR-0000000001", "john", null, new QueryContext());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            Assert.assertEquals((Object)"Hello1", (Object)((TaskSummary)tasks.get(0)).getName());
            CaseFileInstance mainCaseFile = this.caseService.getCaseFileInstance(caseId);
            Assert.assertNotNull((Object)mainCaseFile);
            Assert.assertNull((Object)mainCaseFile.getData("CaseId"));
            Assert.assertNull((Object)mainCaseFile.getData("s"));
            finishCase.accept("HR-0000000001");
            mainCaseFile = this.caseService.getCaseFileInstance(caseId);
            Assert.assertNotNull((Object)mainCaseFile);
            Assert.assertEquals((Object)"HR-0000000001", (Object)mainCaseFile.getData("CaseId"));
            Assert.assertEquals((Object)"John Doe", (Object)mainCaseFile.getData("s"));
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartCaseWithSubCaseAbortProcessInstanceOfSubCase() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("manager", new UserImpl("mary"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "John Doe");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), BASIC_SUB_CASE_P_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), BASIC_SUB_CASE_P_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)SUB_CASE_ID, (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            this.caseService.triggerAdHocFragment(caseId, "Sub Case", null);
            Collection caseInstances = this.caseRuntimeDataService.getCaseInstances(new QueryContext());
            Assert.assertNotNull((Object)caseInstances);
            Assert.assertEquals((long)2L, (long)caseInstances.size());
            Map<String, CaseInstance> byCaseId = caseInstances.stream().collect(Collectors.toMap(CaseInstance::getCaseId, c -> c));
            Assert.assertTrue((boolean)byCaseId.containsKey(SUB_CASE_ID));
            Assert.assertTrue((boolean)byCaseId.containsKey("HR-0000000001"));
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner("HR-0000000001", "john", null, new QueryContext());
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            Assert.assertEquals((Object)"Hello1", (Object)((TaskSummary)tasks.get(0)).getName());
            CaseFileInstance mainCaseFile = this.caseService.getCaseFileInstance(caseId);
            Assert.assertNotNull((Object)mainCaseFile);
            Assert.assertNull((Object)mainCaseFile.getData("subCaseId"));
            this.processService.abortProcessInstance(((TaskSummary)tasks.get(0)).getProcessInstanceId());
            mainCaseFile = this.caseService.getCaseFileInstance(caseId);
            Assert.assertNotNull((Object)mainCaseFile);
            Assert.assertEquals((Object)"HR-0000000001", (Object)mainCaseFile.getData("subCaseId"));
            Assert.assertEquals((Object)"John Doe", (Object)mainCaseFile.getData("outcome"));
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }
}

