/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.api.event.CaseCommentEvent;
import org.jbpm.casemgmt.api.event.CaseEvent;
import org.jbpm.casemgmt.api.event.CaseStartEvent;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.casemgmt.impl.util.RecordingCaseEventListener;
import org.jbpm.casemgmt.impl.util.RecordingCaseEventListenerFactory;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.query.QueryContext;

public class CaseEventEmittingTest
extends AbstractCaseServicesBaseTest {
    private List<String> caseIds = new ArrayList<String>();
    private RecordingCaseEventListener caseEventListener = RecordingCaseEventListenerFactory.get(this.getClass().getSimpleName());

    @Override
    protected List<String> getProcessDefinitionFiles() {
        return Arrays.asList("cases/EmptyCase.bpmn2");
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.registerListenerMvelDefinition("org.jbpm.casemgmt.impl.util.RecordingCaseEventListenerFactory.get(\"" + this.getClass().getSimpleName() + "\")");
        super.setUp();
    }

    @Test
    public void testCaseCommentEventsEmitting() {
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), "EmptyCase");
        this.caseIds.add(caseId);
        this.assertNextEvent(RecordingCaseEventListener.CaseEventInfo.EventFired.BEFORE, CaseStartEvent.class);
        this.assertNextEvent(RecordingCaseEventListener.CaseEventInfo.EventFired.AFTER, CaseStartEvent.class);
        this.caseService.addCaseComment(caseId, "no one", "My little comment", new String[0]);
        String commentId = this.getFirstCommentId(caseId);
        this.assertNextEvent(RecordingCaseEventListener.CaseEventInfo.EventFired.BEFORE, CaseCommentEvent.class);
        this.assertNextEvent(RecordingCaseEventListener.CaseEventInfo.EventFired.AFTER, CaseCommentEvent.class);
        this.caseService.updateCaseComment(caseId, commentId, "no one", "My new comment text", new String[0]);
        this.assertNextEvent(RecordingCaseEventListener.CaseEventInfo.EventFired.BEFORE, CaseCommentEvent.class);
        this.assertNextEvent(RecordingCaseEventListener.CaseEventInfo.EventFired.AFTER, CaseCommentEvent.class);
        this.caseService.removeCaseComment(caseId, commentId);
        this.assertNextEvent(RecordingCaseEventListener.CaseEventInfo.EventFired.BEFORE, CaseCommentEvent.class);
        this.assertNextEvent(RecordingCaseEventListener.CaseEventInfo.EventFired.AFTER, CaseCommentEvent.class);
    }

    private String getFirstCommentId(String caseId) {
        return this.caseService.getCaseComments(caseId, new QueryContext()).stream().findFirst().map(CommentInstance::getId).orElseThrow(() -> new IllegalArgumentException("Single comment expected to be retrieved"));
    }

    private void assertNextEvent(RecordingCaseEventListener.CaseEventInfo.EventFired expectedToBeFired, Class<? extends CaseEvent> eventType) {
        RecordingCaseEventListener.CaseEventInfo caseEventInfo = this.caseEventListener.getEvents().remove();
        Assertions.assertThat((Comparable)((Object)caseEventInfo.fired)).isEqualTo((Object)expectedToBeFired);
        Assertions.assertThat((Object)caseEventInfo.caseEvent).isInstanceOf(eventType);
    }
}

