/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.api.model.instance.CaseStageInstance;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.casemgmt.impl.util.CountDownListenerFactory;
import org.jbpm.services.task.impl.model.UserImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMMNCaseTest
extends AbstractCaseServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(CMMNCaseTest.class);
    protected static final String CMMN_CASE_MILESTONE_ID = "CMMN-HumanTaskMilestoneSentries";
    protected static final String CMMN_CASE_STAGE_ID = "CMMN-StageWithHumanTaskCase";
    protected static final String CMMN_CASE_DATA_ID = "CMMN-DataInputsAndOutputsCase";
    protected static final String CMMN_CASE_RULE_SENTRY_ID = "CMMN-HumanTaskMilestoneRuleSentries";
    protected static final String CMMN_CASE_RULE_HT_ID = "CMMN-StageWithActivationByTaskCase";
    protected static final String CMMN_CASE_DMN_DECISION_ID = "CMMN-DecisionTaskWithDMNCase";
    protected static final String CMMN_CASE_DMN_DECISION_APPROVAL_ID = "CMMN-DecisionTaskWithDMNApprovalCase";
    @Rule
    public TestName name = new TestName();

    @Override
    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/cmmn/CMMN-HumanTaskMilestoneSentries.cmmn");
        processes.add("cases/cmmn/CMMN-StageWithHumanTaskCase.cmmn");
        processes.add("cases/cmmn/CMMN-DataInputsAndOutputsCase.cmmn");
        processes.add("cases/cmmn/CMMN-HumanTaskMilestoneRuleSentries.cmmn");
        processes.add("cases/cmmn/CMMN-StageWithActivationByTaskCase.cmmn");
        processes.add("cases/cmmn/CMMN-DecisionTaskWithDMNCase.cmmn");
        processes.add("cases/cmmn/CMMN-DecisionTaskWithDMNApprovalCase.cmmn");
        processes.add("dmn/0020-vacation-days.dmn");
        return processes;
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        CountDownListenerFactory.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartMilestoneAndHumanTaskCase() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("manager", new UserImpl("mary"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), CMMN_CASE_MILESTONE_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), CMMN_CASE_MILESTONE_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            TaskSummary task = (TaskSummary)tasks.get(0);
            Assertions.assertThat((Object)task).isNotNull();
            Assertions.assertThat((String)task.getName()).isEqualTo((Object)"First task");
            this.userTaskService.start(task.getId(), "john");
            Collection milestones = this.caseRuntimeDataService.getCaseInstanceMilestones(caseId, false, new QueryContext());
            Assertions.assertThat((Iterable)milestones).hasSize(1);
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones(caseId, true, new QueryContext());
            Assertions.assertThat((Iterable)milestones).hasSize(0);
            this.caseService.addDataToCaseFile(caseId, "shipped", (Object)true, new String[0]);
            milestones = this.caseRuntimeDataService.getCaseInstanceMilestones(caseId, true, new QueryContext());
            Assertions.assertThat((Iterable)milestones).hasSize(1);
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartStageAndHumanTaskCase() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("manager", new UserImpl("mary"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), CMMN_CASE_STAGE_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), CMMN_CASE_STAGE_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            TaskSummary task = (TaskSummary)tasks.get(0);
            Assertions.assertThat((Object)task).isNotNull();
            Assertions.assertThat((String)task.getName()).isEqualTo((Object)"First task");
            this.userTaskService.start(task.getId(), "john");
            Collection stages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
            Assertions.assertThat((Iterable)stages).hasSize(0);
            this.caseService.addDataToCaseFile(caseId, "ordered", (Object)true, new String[0]);
            stages = this.caseRuntimeDataService.getCaseInstanceStages(caseId, true, new QueryContext());
            Assertions.assertThat((Iterable)stages).hasSize(1);
            this.caseService.triggerAdHocFragment(caseId, ((CaseStageInstance)stages.iterator().next()).getId(), "Stage task", null);
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            task = (TaskSummary)tasks.get(0);
            Assertions.assertThat((Object)task).isNotNull();
            Assertions.assertThat((String)task.getName()).isEqualTo((Object)"Stage task");
            this.userTaskService.start(task.getId(), "mary");
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartDataMappingHumanTaskCase() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("manager", new UserImpl("mary"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("invoice", "text invoice");
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), CMMN_CASE_DATA_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), CMMN_CASE_DATA_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            TaskSummary task = (TaskSummary)tasks.get(0);
            Assertions.assertThat((Object)task).isNotNull();
            Assertions.assertThat((String)task.getName()).isEqualTo((Object)"First task");
            Map taskInputs = this.userTaskService.getTaskInputContentByTaskId(task.getId());
            Assertions.assertThat((Map)taskInputs).isNotNull();
            Assertions.assertThat((Map)taskInputs).containsEntry((Object)"invoice", (Object)"text invoice");
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("approval", true);
            this.userTaskService.completeAutoProgress(task.getId(), "john", params);
            Object shipped = this.caseService.getCaseFileInstance(caseId).getData("shipped");
            Assertions.assertThat((Object)shipped).isNotNull();
            Assertions.assertThat((Object)shipped).isEqualTo((Object)true);
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartHumanTaskRuleSentryCase() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("manager", new UserImpl("mary"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), CMMN_CASE_RULE_SENTRY_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), CMMN_CASE_RULE_SENTRY_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(0);
            this.caseService.addDataToCaseFile(caseId, "ordered", (Object)true, new String[0]);
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            TaskSummary task = (TaskSummary)tasks.get(0);
            Assertions.assertThat((Object)task).isNotNull();
            Assertions.assertThat((String)task.getName()).isEqualTo((Object)"First task");
            this.userTaskService.start(task.getId(), "john");
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartHumanTaskByCompletingAnotherOneCase() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        roleAssignments.put("manager", new UserImpl("mary"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), CMMN_CASE_RULE_HT_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), CMMN_CASE_RULE_HT_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            TaskSummary task = (TaskSummary)tasks.get(0);
            Assertions.assertThat((Object)task).isNotNull();
            Assertions.assertThat((String)task.getName()).isEqualTo((Object)"Complete to activate");
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("ordered_", true);
            this.userTaskService.completeAutoProgress(task.getId(), "john", params);
            tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("mary", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            task = (TaskSummary)tasks.get(0);
            Assertions.assertThat((Object)task).isNotNull();
            Assertions.assertThat((String)task.getName()).isEqualTo((Object)"Activated");
            this.userTaskService.start(task.getId(), "mary");
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartDMNDecisionTaskCase() {
        HashMap roleAssignments = new HashMap();
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("age", 16);
        data.put("yearsOfService", 1);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), CMMN_CASE_DMN_DECISION_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), CMMN_CASE_DMN_DECISION_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Object vacationDays = cInstance.getCaseFile().getData("vacationDays");
            Assertions.assertThat((Object)vacationDays).isNotNull();
            Assertions.assertThat((Object)vacationDays).isInstanceOf(BigDecimal.class);
            Assertions.assertThat((Object)vacationDays).isEqualTo((Object)BigDecimal.valueOf(5L));
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartDMNDecisionTaskCaseApprovalRequired() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("age", 16);
        data.put("yearsOfService", 1);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), CMMN_CASE_DMN_DECISION_APPROVAL_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), CMMN_CASE_DMN_DECISION_APPROVAL_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Object vacationDays = cInstance.getCaseFile().getData("vacationDays");
            Assertions.assertThat((Object)vacationDays).isNotNull();
            Assertions.assertThat((Object)vacationDays).isInstanceOf(BigDecimal.class);
            Assertions.assertThat((Object)vacationDays).isEqualTo((Object)BigDecimal.valueOf(27L));
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            TaskSummary task = (TaskSummary)tasks.get(0);
            Assertions.assertThat((Object)task).isNotNull();
            Assertions.assertThat((String)task.getName()).isEqualTo((Object)"More than 25 days requires approval");
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartDMNDecisionTaskCaseNoApprovalRequired() {
        HashMap<String, UserImpl> roleAssignments = new HashMap<String, UserImpl>();
        roleAssignments.put("owner", new UserImpl("john"));
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("age", 44);
        data.put("yearsOfService", 20);
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), CMMN_CASE_DMN_DECISION_APPROVAL_ID, data, roleAssignments);
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), CMMN_CASE_DMN_DECISION_APPROVAL_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId, true, false, false, false);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            Object vacationDays = cInstance.getCaseFile().getData("vacationDays");
            Assertions.assertThat((Object)vacationDays).isNotNull();
            Assertions.assertThat((Object)vacationDays).isInstanceOf(BigDecimal.class);
            Assertions.assertThat((Object)vacationDays).isEqualTo((Object)BigDecimal.valueOf(24L));
            List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
            Assertions.assertThat((List)tasks).hasSize(1);
            TaskSummary task = (TaskSummary)tasks.get(0);
            Assertions.assertThat((Object)task).isNotNull();
            Assertions.assertThat((String)task.getName()).isEqualTo((Object)"Less than 25 days you're good to go");
            this.caseService.cancelCase(caseId);
            CaseInstance instance = this.caseService.getCaseInstance(caseId);
            Assertions.assertThat((Integer)instance.getStatus()).isEqualTo(CaseStatus.CANCELLED.getId());
            caseId = null;
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }
}

