/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseInstance;
import org.jbpm.casemgmt.impl.util.AbstractCaseServicesBaseTest;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.process.CaseAssignment;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.TaskSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseAssignmentServiceImplTest
extends AbstractCaseServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(CaseAssignmentServiceImplTest.class);
    private static final String CASE_X_P_ID = "testCaseProject.caseDef_X";
    private static final String CASE_Y_P_ID = "testCaseProject.caseDef_Y";

    @Override
    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("cases/caseDef_X.bpmn2");
        processes.add("cases/caseDef_Y.bpmn2");
        return processes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProperRoleAssignedAutoStart() {
        HashMap<String, Object> roleAssignments = new HashMap<String, Object>();
        roleAssignments.put("actorRole", new UserImpl("john"));
        roleAssignments.put("groupRole", new GroupImpl("managers"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), CASE_X_P_ID, data, roleAssignments);
        ((CaseAssignment)caseFile).assignGroup("generalRole", "managers");
        ((CaseAssignment)caseFile).assignUser("generalRole", "john");
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), CASE_X_P_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    @Test
    public void testRoleAssignedMissingUserAutoStart() {
        HashMap<String, Object> roleAssignments = new HashMap<String, Object>();
        roleAssignments.put("actorRole", new UserImpl("john"));
        roleAssignments.put("groupRole", new GroupImpl("managers"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), CASE_X_P_ID, data, roleAssignments);
        ((CaseAssignment)caseFile).assignUser("generalRole", "john");
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.caseService.startCase(this.deploymentUnit.getIdentifier(), CASE_X_P_ID, caseFile)).withMessageContaining("Case role 'generalRole' has no matching assignments");
    }

    @Test
    public void testRoleAssignedMissingGroupAutoStart() {
        HashMap<String, Object> roleAssignments = new HashMap<String, Object>();
        roleAssignments.put("actorRole", new UserImpl("john"));
        roleAssignments.put("groupRole", new GroupImpl("managers"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), CASE_X_P_ID, data, roleAssignments);
        ((CaseAssignment)caseFile).assignGroup("generalRole", "managers");
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.caseService.startCase(this.deploymentUnit.getIdentifier(), CASE_X_P_ID, caseFile)).withMessageContaining("Case role 'generalRole' has no matching assignments");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProperRoleAssigned() {
        HashMap<String, Object> roleAssignments = new HashMap<String, Object>();
        roleAssignments.put("actorRole", new UserImpl("mary"));
        roleAssignments.put("groupRole", new GroupImpl("managers"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), CASE_Y_P_ID, data, roleAssignments);
        ((CaseAssignment)caseFile).assignGroup("generalRole", "managers");
        ((CaseAssignment)caseFile).assignUser("generalRole", "john");
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), CASE_Y_P_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "mary", null, new QueryContext());
            Assert.assertEquals((long)5L, (long)tasks.size());
            TaskSummary foundTask = tasks.stream().filter(task -> task.getName().equals("Task E")).findFirst().get();
            this.userTaskService.completeAutoProgress(foundTask.getId(), "mary", new HashMap());
            tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "john", null, new QueryContext());
            Assert.assertEquals((long)1L, (long)tasks.size());
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRoleAssignedMissingUser() {
        HashMap<String, Object> roleAssignments = new HashMap<String, Object>();
        roleAssignments.put("actorRole", new UserImpl("mary"));
        roleAssignments.put("groupRole", new GroupImpl("managers"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), CASE_Y_P_ID, data, roleAssignments);
        ((CaseAssignment)caseFile).assignUser("generalRole", "john");
        String caseId = this.caseService.startCase(this.deploymentUnit.getIdentifier(), CASE_Y_P_ID, caseFile);
        Assert.assertNotNull((Object)caseId);
        Assert.assertEquals((Object)"CASE-0000000001", (Object)caseId);
        try {
            CaseInstance cInstance = this.caseService.getCaseInstance(caseId);
            Assert.assertNotNull((Object)cInstance);
            Assert.assertEquals((Object)"CASE-0000000001", (Object)cInstance.getCaseId());
            Assert.assertEquals((Object)this.deploymentUnit.getIdentifier(), (Object)cInstance.getDeploymentId());
            List tasks = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, "mary", null, new QueryContext());
            Assert.assertEquals((long)5L, (long)tasks.size());
            TaskSummary foundTask = tasks.stream().filter(task -> task.getName().equals("Task E")).findFirst().get();
            Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.userTaskService.completeAutoProgress(foundTask.getId(), "mary", new HashMap())).withMessageContaining("Case role 'generalRole' has no matching assignments");
        }
        catch (Exception e) {
            logger.error("Unexpected error {}", (Object)e.getMessage(), (Object)e);
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        finally {
            if (caseId != null) {
                this.caseService.cancelCase(caseId);
            }
        }
    }

    @Test
    public void testRoleAssignedMissingRole() {
        HashMap<String, GroupImpl> roleAssignments = new HashMap<String, GroupImpl>();
        roleAssignments.put("groupRole", new GroupImpl("managers"));
        HashMap data = new HashMap();
        CaseFileInstance caseFile = this.caseService.newCaseFileInstance(this.deploymentUnit.getIdentifier(), CASE_Y_P_ID, data, roleAssignments);
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.caseService.startCase(this.deploymentUnit.getIdentifier(), CASE_Y_P_ID, caseFile)).withMessageContaining("Case role 'actorRole' has no matching assignments");
    }
}

