/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.command.impl.GenericCommand;
import org.jbpm.casemgmt.CaseMgmtService;
import org.jbpm.casemgmt.role.Role;
import org.jbpm.casemgmt.role.RoleInstance;
import org.jbpm.casemgmt.role.impl.RoleImpl;
import org.jbpm.casemgmt.role.impl.RoleInstanceImpl;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.DynamicUtils;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.command.Command;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.manager.audit.NodeInstanceLog;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Task;
import org.kie.internal.command.Context;

public class CaseMgmtUtil
implements CaseMgmtService {
    private KieSession ksession;
    private AuditService auditService;
    private TaskService taskService;

    public CaseMgmtUtil(RuntimeEngine engine) {
        this.auditService = engine.getAuditService();
        this.ksession = engine.getKieSession();
        this.taskService = engine.getTaskService();
    }

    public CaseMgmtUtil(ProcessContext kcontext) {
        this.ksession = (KieSession)kcontext.getKieRuntime();
    }

    @Override
    public String getProcessInstanceDescription(long processInstanceId) {
        return ((ProcessInstanceImpl)this.getProcessInstance(processInstanceId)).getDescription();
    }

    @Override
    public Map<String, Role> getCaseRoles(String processId) {
        String[] roleStrings;
        Process process = this.ksession.getKieBase().getProcess(processId);
        String roles = (String)process.getMetaData().get("customCaseRoles");
        if (roles == null) {
            return null;
        }
        HashMap<String, Role> result = new HashMap<String, Role>();
        for (String roleString : roleStrings = roles.split(",")) {
            String[] ss = roleString.split(":");
            RoleImpl role = new RoleImpl(ss[0]);
            result.put(role.getName(), role);
            if (ss.length <= 1) continue;
            role.setCardinality(Integer.parseInt(ss[1]));
        }
        return result;
    }

    @Override
    public String[] getCaseRoleNames(String processId) {
        ArrayList<String> result = new ArrayList<String>();
        for (Role role : this.getCaseRoles(processId).values()) {
            result.add(role.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public Map<String, RoleInstance> getCaseRoleInstances(long processInstanceId) {
        ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
        return (Map)((WorkflowProcessInstance)processInstance).getVariable("CaseRoles");
    }

    @Override
    public Map<String, String[]> getCaseRoleInstanceNames(long processInstanceId) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
        for (String role : this.getCaseRoleNames(processInstance.getProcessId())) {
            result.put(role, null);
        }
        Map<String, RoleInstance> roleInstances = this.getCaseRoleInstances(processInstanceId);
        if (roleInstances != null) {
            for (RoleInstance roleInstance : roleInstances.values()) {
                result.put(roleInstance.getRoleName(), ((RoleInstanceImpl)roleInstance).getRoleAssignmentNames());
            }
        }
        return result;
    }

    private ProcessInstance getProcessInstance(long processInstanceId) {
        ProcessInstance processInstance = this.ksession.getProcessInstance(processInstanceId);
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance " + processInstanceId);
        }
        return processInstance;
    }

    @Override
    public void addUserToRole(final long processInstanceId, final String roleName, final String userId) {
        this.ksession.execute((Command)new GenericCommand<Void>(){
            private static final long serialVersionUID = 630L;

            public Void execute(Context context) {
                RoleInstance roleInstance;
                Map<String, RoleInstance> roleInstances = CaseMgmtUtil.this.getCaseRoleInstances(processInstanceId);
                if (roleInstances == null) {
                    roleInstances = new HashMap<String, RoleInstance>();
                    ((WorkflowProcessInstance)CaseMgmtUtil.this.getProcessInstance(processInstanceId)).setVariable("CaseRoles", roleInstances);
                }
                if ((roleInstance = roleInstances.get(roleName)) == null) {
                    roleInstance = new RoleInstanceImpl(roleName);
                    roleInstances.put(roleName, roleInstance);
                } else {
                    Integer cardinality;
                    Role role = CaseMgmtUtil.this.getCaseRoles(CaseMgmtUtil.this.getProcessInstance(processInstanceId).getProcessId()).get(roleName);
                    if (role != null && (cardinality = role.getCardinality()) != null && cardinality > 0 && cardinality < roleInstance.getRoleAssignments().size() + 1) {
                        throw new IllegalArgumentException("Cannot add more users for role " + roleName + ", maximum cardinality " + cardinality + " already reached");
                    }
                }
                roleInstance.addRoleAssignment(userId);
                return null;
            }
        });
    }

    @Override
    public void setCaseRoleInstance(final long processInstanceId, final String roleName, final String[] userIds) {
        this.ksession.execute((Command)new GenericCommand<Void>(){
            private static final long serialVersionUID = 630L;

            public Void execute(Context context) {
                Map<String, RoleInstance> roleInstances = CaseMgmtUtil.this.getCaseRoleInstances(processInstanceId);
                if (roleInstances == null) {
                    roleInstances = new HashMap<String, RoleInstance>();
                    ((WorkflowProcessInstance)CaseMgmtUtil.this.getProcessInstance(processInstanceId)).setVariable("CaseRoles", roleInstances);
                }
                RoleInstanceImpl roleInstance = new RoleInstanceImpl(roleName);
                roleInstances.put(roleName, roleInstance);
                for (String userId : userIds) {
                    roleInstance.addRoleAssignment(userId);
                }
                return null;
            }
        });
    }

    public static void addUserToRole(ProcessContext kcontext, String roleName, String userId) {
        new CaseMgmtUtil(kcontext).addUserToRole(kcontext.getProcessInstance().getId(), roleName, userId);
    }

    public static String[] getRoleNames(ProcessContext kcontext, String roleName, String userId) {
        return new CaseMgmtUtil(kcontext).getCaseRoleInstanceNames(kcontext.getProcessInstance().getId()).get(roleName);
    }

    public static String getRoleName(ProcessContext kcontext, String roleName, String userId) {
        String[] roles = CaseMgmtUtil.getRoleNames(kcontext, roleName, userId);
        if (roles.length == 1) {
            return roles[0];
        }
        return null;
    }

    @Override
    public ProcessInstance startNewCase(String name) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (name != null) {
            params.put("name", name);
        }
        return this.ksession.startProcess("EmptyCase", params);
    }

    @Override
    public Process[] getAvailableProcesses() {
        Collection processes = this.ksession.getKieBase().getProcesses();
        return processes.toArray(new Process[processes.size()]);
    }

    @Override
    public Process[] getAvailableCases() {
        Collection processes = this.ksession.getKieBase().getProcesses();
        ArrayList<Process> result = new ArrayList<Process>();
        for (Process process : processes) {
            if (!((WorkflowProcessImpl)process).isDynamic()) continue;
            result.add(process);
        }
        return processes.toArray(new Process[processes.size()]);
    }

    @Override
    public Map<String, Object> getCaseData(long processInstanceId) {
        return ((WorkflowProcessInstanceImpl)this.getProcessInstance(processInstanceId)).getVariables();
    }

    @Override
    public void setCaseData(final long processInstanceId, final String name, final Object data) {
        this.ksession.execute((Command)new GenericCommand<Void>(){
            private static final long serialVersionUID = 630L;

            public Void execute(Context context) {
                ((WorkflowProcessInstance)CaseMgmtUtil.this.getProcessInstance(processInstanceId)).setVariable(name, data);
                return null;
            }
        });
    }

    @Override
    public String[] getAdHocFragmentNames(final long processInstanceId) {
        final ArrayList result = new ArrayList();
        this.ksession.execute((Command)new GenericCommand<Void>(){
            private static final long serialVersionUID = 630L;

            public Void execute(Context context) {
                WorkflowProcessInstance processInstance = (WorkflowProcessInstance)CaseMgmtUtil.this.getProcessInstance(processInstanceId);
                WorkflowProcess process = (WorkflowProcess)processInstance.getProcess();
                if (process.isDynamic()) {
                    CaseMgmtUtil.this.checkAdHoc((NodeContainer)process, result);
                }
                CaseMgmtUtil.this.checkNodeInstances((NodeInstanceContainer)processInstance, result);
                return null;
            }
        });
        return result.toArray(new String[result.size()]);
    }

    private void checkAdHoc(NodeContainer nodeContainer, List<String> result) {
        for (Node node : nodeContainer.getNodes()) {
            if (node instanceof StartNode || !node.getIncomingConnections().isEmpty()) continue;
            result.add(node.getName());
        }
    }

    private void checkNodeInstances(NodeInstanceContainer nodeInstanceContainer, List<String> result) {
        for (NodeInstance nodeInstance : nodeInstanceContainer.getNodeInstances()) {
            if (!(nodeInstance instanceof DynamicNodeInstance)) continue;
            this.checkAdHoc((NodeContainer)((DynamicNode)nodeInstance.getNode()), result);
            this.checkNodeInstances((NodeInstanceContainer)((DynamicNodeInstance)nodeInstance), result);
        }
    }

    @Override
    public void triggerAdHocFragment(long processInstanceId, String name) {
        this.ksession.signalEvent(name, null, processInstanceId);
    }

    @Override
    public void createDynamicProcess(long processInstanceId, String processId, Map<String, Object> parameters) {
        DynamicUtils.addDynamicSubProcess((ProcessInstance)this.getProcessInstance(processInstanceId), (KieRuntime)this.ksession, (String)processId, parameters);
    }

    @Override
    public void createDynamicHumanTask(long processInstanceId, String taskName, String actorIds, String groupIds, String comment, Map<String, Object> parameters) {
        HashMap<String, Object> workParams = new HashMap<String, Object>();
        if (parameters != null) {
            workParams.putAll(parameters);
        }
        workParams.put("NodeName", taskName);
        workParams.put("TaskName", taskName);
        workParams.put("ActorId", actorIds);
        workParams.put("GroupId", groupIds);
        workParams.put("Comment", comment);
        DynamicUtils.addDynamicWorkItem((ProcessInstance)this.getProcessInstance(processInstanceId), (KieRuntime)this.ksession, (String)"Human Task", workParams);
    }

    @Override
    public void createDynamicWorkTask(long processInstanceId, String workName, Map<String, Object> workParams) {
        DynamicUtils.addDynamicWorkItem((ProcessInstance)this.getProcessInstance(processInstanceId), (KieRuntime)this.ksession, (String)workName, workParams);
    }

    @Override
    public Map<String, String> getMilestones(String processId) {
        Process process = this.ksession.getKieBase().getProcess(processId);
        HashMap<String, String> result = new HashMap<String, String>();
        this.getMilestones((NodeContainer)((org.kie.api.definition.process.WorkflowProcess)process), result);
        return result;
    }

    private void getMilestones(NodeContainer container, Map<String, String> result) {
        for (Node node : container.getNodes()) {
            if (node instanceof WorkItemNode && "Milestone".equals(((WorkItemNode)node).getWork().getName())) {
                result.put(node.getName(), (String)node.getMetaData().get("UniqueId"));
            }
            if (!(node instanceof NodeContainer)) continue;
            this.getMilestones((NodeContainer)node, result);
        }
    }

    @Override
    public String[] getMilestoneNames(String processId) {
        Map<String, String> milestones = this.getMilestones(processId);
        return milestones.keySet().toArray(new String[milestones.size()]);
    }

    @Override
    public String[] getAchievedMilestones(long processInstanceId) {
        ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
        Map<String, String> milestones = this.getMilestones(processInstance.getProcessId());
        List nodeInstances = this.auditService.findNodeInstances(processInstanceId);
        HashMap<String, String> nodes = new HashMap<String, String>();
        for (NodeInstanceLog log : nodeInstances) {
            nodes.put(log.getNodeId(), log.getNodeName());
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> entry : milestones.entrySet()) {
            if (nodes.get(entry.getValue()) == null) continue;
            result.add(entry.getKey());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Task[] getActiveTasks(final long processInstanceId) {
        final ArrayList workItemIds = new ArrayList();
        this.ksession.execute((Command)new GenericCommand<Void>(){
            private static final long serialVersionUID = 630L;

            public Void execute(Context context) {
                ProcessInstance processInstance = CaseMgmtUtil.this.getProcessInstance(processInstanceId);
                CaseMgmtUtil.this.getActiveTasks((NodeInstanceContainer)((WorkflowProcessInstance)processInstance), workItemIds);
                return null;
            }
        });
        ArrayList<Task> result = new ArrayList<Task>();
        for (Long workItemId : workItemIds) {
            result.add(this.taskService.getTaskByWorkItemId(workItemId.longValue()));
        }
        return result.toArray(new Task[result.size()]);
    }

    private void getActiveTasks(NodeInstanceContainer nodeInstanceContainer, List<Long> workItemIds) {
        for (NodeInstance nodeInstance : nodeInstanceContainer.getNodeInstances()) {
            if (nodeInstance instanceof WorkItemNodeInstance) {
                WorkItemNodeInstance workItemNodeInstance = (WorkItemNodeInstance)nodeInstance;
                if (!"Human Task".equals(workItemNodeInstance.getWorkItem().getName())) continue;
                workItemIds.add(workItemNodeInstance.getWorkItemId());
                continue;
            }
            if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
            this.getActiveTasks((NodeInstanceContainer)nodeInstance, workItemIds);
        }
    }

    @Override
    public ProcessInstance[] getActiveSubProcesses(final long processInstanceId) {
        final ArrayList result = new ArrayList();
        this.ksession.execute((Command)new GenericCommand<Void>(){
            private static final long serialVersionUID = 630L;

            public Void execute(Context context) {
                ProcessInstance processInstance = CaseMgmtUtil.this.getProcessInstance(processInstanceId);
                CaseMgmtUtil.this.getActiveSubProcesses((NodeInstanceContainer)((WorkflowProcessInstance)processInstance), result);
                return null;
            }
        });
        return result.toArray(new ProcessInstance[result.size()]);
    }

    private void getActiveSubProcesses(NodeInstanceContainer nodeInstanceContainer, List<ProcessInstance> result) {
        for (NodeInstance nodeInstance : nodeInstanceContainer.getNodeInstances()) {
            if (nodeInstance instanceof SubProcessNodeInstance) {
                result.add(this.ksession.getProcessInstance(((SubProcessNodeInstance)nodeInstance).getProcessInstanceId()));
                continue;
            }
            if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
            this.getActiveSubProcesses((NodeInstanceContainer)nodeInstance, result);
        }
    }

    @Override
    public NodeInstanceLog[] getActiveNodes(final long processInstanceId) {
        final ArrayList nodes = new ArrayList();
        this.ksession.execute((Command)new GenericCommand<Void>(){
            private static final long serialVersionUID = 630L;

            public Void execute(Context context) {
                ProcessInstance processInstance = CaseMgmtUtil.this.getProcessInstance(processInstanceId);
                CaseMgmtUtil.this.getActiveNodes((NodeInstanceContainer)((WorkflowProcessInstance)processInstance), nodes);
                return null;
            }
        });
        HashMap<String, NodeInstanceLog> logMap = new HashMap<String, NodeInstanceLog>();
        List logs = this.auditService.findNodeInstances(processInstanceId);
        for (NodeInstanceLog log : logs) {
            NodeInstanceLog oldLog = (NodeInstanceLog)logMap.get(log.getNodeInstanceId());
            if (oldLog != null && oldLog.getDate().before(log.getDate())) continue;
            logMap.put(log.getNodeInstanceId(), log);
        }
        ArrayList result = new ArrayList();
        for (Long node : nodes) {
            result.add(logMap.get(Long.toString(node)));
        }
        return result.toArray(new NodeInstanceLog[result.size()]);
    }

    private void getActiveNodes(NodeInstanceContainer nodeInstanceContainer, List<Long> nodes) {
        for (NodeInstance nodeInstance : nodeInstanceContainer.getNodeInstances()) {
            nodes.add(nodeInstance.getId());
        }
    }
}

