/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.asset.backend.server;

import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.asset.service.AssetManagementEntryPoint;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;

@Service
@ApplicationScoped
public class AssetManagementEntryPointImpl
implements AssetManagementEntryPoint {
    @Inject
    private KieSessionEntryPoint sessionServices;

    @PostConstruct
    public void init() {
    }

    public void configureRepository(String repository, String devBranch, String releaseBranch, String version) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("RepositoryName", repository);
        params.put("DevBranchName", devBranch);
        params.put("RelBranchName", releaseBranch);
        params.put("Version", version);
        this.sessionServices.startProcess("org.kie.management:asset-management-kmodule:1.0.0-SNAPSHOT", "asset-management-kmodule.ConfigureRepository", params);
    }

    public void buildProject(String repository, String branch, String project, String userName, String password, String serverURL, Boolean deployToRuntime) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ProjectURI", repository + "/" + project);
        params.put("BranchName", branch);
        params.put("Username", userName);
        params.put("Password", password);
        params.put("ExecServerURL", serverURL);
        params.put("DeployToRuntime", deployToRuntime.toString());
        this.sessionServices.startProcess("org.kie.management:asset-management-kmodule:1.0.0-SNAPSHOT", "asset-management-kmodule.BuildProject", params);
    }

    public void promoteChanges(String repository, String sourceBranch, String destBranch) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GitRepositoryName", repository);
        params.put("SourceBranchName", sourceBranch);
        params.put("TargetBranchName", destBranch);
        this.sessionServices.startProcess("org.kie.management:asset-management-kmodule:1.0.0-SNAPSHOT", "asset-management-kmodule.PromoteAssets", params);
    }
}

