/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.asset.backend.server;

import java.util.Set;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.jbpm.console.ng.asset.backend.server.AssetMgmtDeploymentUnitProvider;
import org.jbpm.services.api.model.DeploymentUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AssetMgmtDeploymentUnitProviderTest {
    @Test
    public void testGetDeploymentUnits() throws Exception {
        AssetMgmtDeploymentUnitProvider provider = new AssetMgmtDeploymentUnitProvider();
        GuvnorM2Repository repo = new GuvnorM2Repository();
        repo.init();
        GuvnorM2Repository repoSpy = (GuvnorM2Repository)Mockito.spy((Object)repo);
        provider.setM2Repository(repoSpy);
        ArgumentCaptor fileNameCaptor = ArgumentCaptor.forClass(String.class);
        Set units = provider.getDeploymentUnits();
        ((GuvnorM2Repository)Mockito.verify((Object)repoSpy, (VerificationMode)Mockito.times((int)1))).getFileName((String)fileNameCaptor.capture());
        String fileNameArg = (String)fileNameCaptor.getValue();
        Assert.assertTrue((String)("Incorrect file name: " + fileNameArg), (fileNameArg != null && fileNameArg.contains("guvnor-asset-mgmt-project") ? 1 : 0) != 0);
        Assert.assertNotNull((String)"Null deployment units set", (Object)units);
        Assert.assertNotNull((String)"Empty deployment units set", (Object)units.isEmpty());
        String gavId = ((DeploymentUnit)units.iterator().next()).getIdentifier();
        Assert.assertTrue((String)("Unexpected GAV id:" + gavId), (boolean)gavId.contains("guvnor-asset-mgmt"));
    }
}

