/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server.provider;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jbpm.console.ng.bd.service.DeploymentUnitProvider;
import org.jbpm.kie.services.api.DeploymentUnit;
import org.jbpm.kie.services.api.Vfs;
import org.jbpm.kie.services.impl.VFSDeploymentUnit;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.Path;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.repositories.RepositoryService;

@ApplicationScoped
@Vfs
public class VFSRepoDeploymentUnitProvider
implements DeploymentUnitProvider<DeploymentUnit> {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private RepositoryService repositoryService;

    public Set<DeploymentUnit> getDeploymentUnits() {
        HashSet<DeploymentUnit> deploymentUnits = new HashSet<DeploymentUnit>();
        Collection repositories = this.repositoryService.getRepositories();
        if (repositories == null || repositories.isEmpty()) {
            return deploymentUnits;
        }
        for (Repository repository : repositories) {
            DirectoryStream assetDirectories = this.ioService.newDirectoryStream(this.ioService.get(repository.getUri() + "/processes", new String[0]), (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

                public boolean accept(Path entry) {
                    return Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]);
                }
            });
            for (Path p : assetDirectories) {
                String folder = p.toString();
                if (folder.startsWith("/")) {
                    folder = folder.substring(1);
                }
                deploymentUnits.add((DeploymentUnit)new VFSDeploymentUnit(p.getFileName().toString(), repository.getAlias(), folder));
            }
        }
        return deploymentUnits;
    }
}

