/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.service;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jbpm.console.ng.bd.api.FileException;
import org.jbpm.console.ng.bd.api.FileService;
import org.jbpm.console.ng.bd.api.VFSDeploymentUnit;
import org.jbpm.console.ng.bd.api.Vfs;
import org.jbpm.kie.services.api.IdentityProvider;
import org.jbpm.kie.services.api.bpmn2.BPMN2DataService;
import org.jbpm.kie.services.impl.AbstractDeploymentService;
import org.jbpm.kie.services.impl.DeployedUnitImpl;
import org.jbpm.kie.services.impl.audit.ServicesAwareAuditEventBuilder;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.runtime.manager.impl.RuntimeEnvironmentBuilder;
import org.jbpm.runtime.manager.impl.cdi.InjectableRegisterableItemsFactory;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.internal.deployment.DeploymentUnit;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
@Vfs
public class VFSDeploymentService
extends AbstractDeploymentService {
    private static final Logger logger = LoggerFactory.getLogger(VFSDeploymentService.class);
    @Inject
    private BeanManager beanManager;
    @Inject
    private FileService fs;
    @Inject
    private IdentityProvider identityProvider;
    @Inject
    private BPMN2DataService bpmn2Service;

    public void deploy(DeploymentUnit unit) {
        super.deploy(unit);
        if (!(unit instanceof VFSDeploymentUnit)) {
            throw new IllegalArgumentException("Invalid deployment unit provided - " + unit.getClass().getName());
        }
        DeployedUnitImpl deployedUnit = new DeployedUnitImpl(unit);
        VFSDeploymentUnit vfsUnit = (VFSDeploymentUnit)unit;
        RuntimeEnvironmentBuilder builder = RuntimeEnvironmentBuilder.getDefault().entityManagerFactory((Object)this.getEmf());
        AbstractAuditLogger auditLogger = this.getAuditLogger();
        ServicesAwareAuditEventBuilder auditEventBuilder = new ServicesAwareAuditEventBuilder();
        auditEventBuilder.setIdentityProvider(this.identityProvider);
        auditEventBuilder.setDeploymentUnitId(vfsUnit.getIdentifier());
        auditLogger.setBuilder((AuditEventBuilder)auditEventBuilder);
        if (this.beanManager != null) {
            builder.registerableItemsFactory(InjectableRegisterableItemsFactory.getFactory((BeanManager)this.beanManager, (AbstractAuditLogger)auditLogger));
        }
        this.loadProcesses(vfsUnit, builder, deployedUnit);
        this.loadRules(vfsUnit, builder, deployedUnit);
        this.commonDeploy(vfsUnit, deployedUnit, (RuntimeEnvironment)builder.get());
    }

    protected void loadProcesses(VFSDeploymentUnit vfsUnit, RuntimeEnvironmentBuilder builder, DeployedUnitImpl deployedUnit) {
        Iterable<Path> loadProcessFiles = null;
        try {
            Path processFolder = this.fs.getPath(vfsUnit.getRepository() + vfsUnit.getRepositoryFolder());
            loadProcessFiles = this.fs.loadFilesByType(processFolder, ".+bpmn[2]?$");
        }
        catch (FileException ex) {
            logger.error("Error while loading process files", (Throwable)ex);
        }
        for (Path p : loadProcessFiles) {
            String processString = "";
            try {
                processString = new String(this.fs.loadFile(p));
                builder.addAsset(ResourceFactory.newByteArrayResource((byte[])processString.getBytes()), ResourceType.BPMN2);
                ProcessAssetDesc process = this.bpmn2Service.findProcessId(processString, null);
                process.setOriginalPath(p.toUri().toString());
                process.setDeploymentId(vfsUnit.getIdentifier());
                deployedUnit.addAssetLocation(process.getId(), process);
            }
            catch (Exception ex) {
                logger.error("Error while reading process files", (Throwable)ex);
            }
        }
    }

    protected void loadRules(VFSDeploymentUnit vfsUnit, RuntimeEnvironmentBuilder builder, DeployedUnitImpl deployedUnit) {
        Iterable<Path> loadRuleFiles = null;
        try {
            Path rulesFolder = this.fs.getPath(vfsUnit.getRepository() + vfsUnit.getRepositoryFolder());
            loadRuleFiles = this.fs.loadFilesByType(rulesFolder, ".+drl");
        }
        catch (FileException ex) {
            logger.error("Error while loading rule files", (Throwable)ex);
        }
        for (Path p : loadRuleFiles) {
            String ruleString = "";
            try {
                ruleString = new String(this.fs.loadFile(p));
                builder.addAsset(ResourceFactory.newByteArrayResource((byte[])ruleString.getBytes()), ResourceType.DRL);
            }
            catch (Exception ex) {
                logger.error("Error while reading rule files", (Throwable)ex);
            }
        }
    }

    public FileService getFs() {
        return this.fs;
    }

    public void setFs(FileService fs) {
        this.fs = fs;
    }

    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public BPMN2DataService getBpmn2Service() {
        return this.bpmn2Service;
    }

    public void setBpmn2Service(BPMN2DataService bpmn2Service) {
        this.bpmn2Service = bpmn2Service;
    }
}

